/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.autoupdate.ModuleUpdate;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SafeModule {
    public static final String PUBLIC_ID = "-//NetBeans//DTD Module Status 1.0//EN";
    public static final String SYSTEM_ID = "http://www.netbeans.org/dtds/module-status-1_0.dtd";
    static final String PROP_AUTOLOAD = "autoload";
    static final String PROP_EAGER = "eager";
    private static final String PROP_SPEC = "specversion";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_JAR = "jar";
    private static final String PROP_ORIGIN = "origin";
    private static final String PROP_USER = "user";
    private static final String PROP_INSTALL = "installation";
    private static final String PROP_RELEASE = "release";
    private static final String PROP_RELOADABLE = "reloadable";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PARAM = "param";
    private static final String AUTOLOAD_SLASH = "autoload/";
    private static final String EAGER_SLASH = "eager/";
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static Map prepared = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$autoupdate$SafeModule;

    SafeModule() {
    }

    private static boolean register(ModuleUpdate moduleUpdate) {
        boolean bl = true;
        Iterator iterator = moduleUpdate.getJarList().iterator();
        while (bl && iterator.hasNext()) {
            String string = (String)iterator.next();
            bl = SafeModule.register(moduleUpdate, string);
        }
        return bl;
    }

    static boolean write(Map map) {
        Object object;
        boolean bl = true;
        prepared = new HashMap();
        Iterator iterator = map.entrySet().iterator();
        while (bl && iterator.hasNext()) {
            object = iterator.next();
            ModuleUpdate moduleUpdate = (ModuleUpdate)object.getKey();
            File file = (File)object.getValue();
            if (file.exists()) {
                bl = false;
                continue;
            }
            bl = SafeModule.register(moduleUpdate);
        }
        if (!bl) {
            return false;
        }
        try {
            object = Repository.getDefault().getDefaultFileSystem();
            object.runAtomicAction((FileSystem.AtomicAction)new DocAtomicAction((FileSystem)object));
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private static boolean register(ModuleUpdate moduleUpdate, String string) {
        Module module = new Module();
        try {
            SafeModule.loadManifest(string, module, moduleUpdate);
        }
        catch (IOException iOException) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(ATTR_NAME, module.getName());
        boolean bl = false;
        if (string.startsWith(AUTOLOAD_SLASH)) {
            bl = true;
            string = string.substring(AUTOLOAD_SLASH.length());
        }
        hashMap.put(PROP_AUTOLOAD, bl ? Boolean.TRUE : Boolean.FALSE);
        boolean bl2 = false;
        if (string.startsWith(EAGER_SLASH)) {
            bl2 = true;
            string = string.substring(EAGER_SLASH.length());
        }
        hashMap.put(PROP_EAGER, bl2 ? Boolean.TRUE : Boolean.FALSE);
        if (!bl && !bl2) {
            hashMap.put(PROP_ENABLED, Boolean.TRUE);
        }
        hashMap.put(PROP_JAR, string);
        String string2 = "";
        string2 = moduleUpdate.isToInstallDir() ? PROP_INSTALL : PROP_USER;
        if (bl) {
            string2 = string2 + '/' + PROP_AUTOLOAD;
        } else if (bl2) {
            string2 = string2 + '/' + PROP_EAGER;
        }
        hashMap.put(PROP_ORIGIN, string2);
        if (module.getRelease() != null) {
            hashMap.put(PROP_RELEASE, module.getRelease());
        }
        hashMap.put(PROP_RELOADABLE, Boolean.FALSE);
        if (module.getSpecVersion() != null) {
            hashMap.put(PROP_SPEC, module.getSpecVersion());
        }
        String string3 = module.getName().replace('.', '-');
        prepared.put(string3, hashMap);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadManifest(String string, Module module, ModuleUpdate moduleUpdate) throws IOException {
        String string2 = null;
        string2 = moduleUpdate.isToInstallDir() ? moduleUpdate.findInstallDirectory().toString() : System.getProperty("netbeans.user");
        string2 = string2 + FILE_SEPARATOR + "modules" + FILE_SEPARATOR + string;
        JarFile jarFile = new JarFile(string2);
        try {
            Manifest manifest = jarFile.getManifest();
            String string3 = manifest.getMainAttributes().getValue("OpenIDE-Module");
            int n = string3.indexOf(47);
            if (n > -1) {
                module.setRelease(string3.substring(n + 1));
                string3 = string3.substring(0, n);
            }
            module.setName(string3);
            String string4 = manifest.getMainAttributes().getValue("OpenIDE-Module-Specification-Version");
            module.setSpecVersion(string4);
        }
        finally {
            jarFile.close();
        }
    }

    static ModuleStatus getModuleStatus(String string) {
        Document document;
        Object object;
        String string2 = "Modules/" + string.replace('.', '-') + ".xml";
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource(string2);
        if (fileObject == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
            object = new InputSource(inputStream);
            document = XMLUtil.parse((InputSource)object, (boolean)false, (boolean)false, (ErrorHandler)new ErrorCatcher(), (EntityResolver)new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    return new InputSource((class$org$netbeans$modules$autoupdate$SafeModule == null ? (class$org$netbeans$modules$autoupdate$SafeModule = SafeModule.class$("org.netbeans.modules.autoupdate.SafeModule")) : class$org$netbeans$modules$autoupdate$SafeModule).getResource("module-status-1_0.dtd").toExternalForm());
                }
            });
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (SAXException sAXException) {
            System.out.println("Bad update_tracking");
            sAXException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            System.out.println("Missing update_tracking");
            iOException.printStackTrace();
            return null;
        }
        object = new ModuleStatus();
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("module")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(ATTR_PARAM)) continue;
                try {
                    SafeModule.readParam(element2, (ModuleStatus)object);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return object;
    }

    private static void readParam(Element element, ModuleStatus moduleStatus) throws Exception {
        Node node = element.getChildNodes().item(0);
        if (element.getAttribute(ATTR_NAME).equals(PROP_AUTOLOAD)) {
            moduleStatus.setAutoload(Boolean.valueOf(node.getNodeValue()));
        } else if (element.getAttribute(ATTR_NAME).equals(PROP_EAGER)) {
            moduleStatus.setEager(Boolean.valueOf(node.getNodeValue()));
        } else if (element.getAttribute(ATTR_NAME).equals(PROP_JAR)) {
            moduleStatus.setJar(node.getNodeValue());
        } else if (element.getAttribute(ATTR_NAME).equals(PROP_ORIGIN)) {
            moduleStatus.setOrigin(node.getNodeValue());
        }
    }

    private static class DocAtomicAction
    implements FileSystem.AtomicAction {
        private FileSystem fs;

        public DocAtomicAction(FileSystem fileSystem) {
            this.fs = fileSystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            this.fs.refresh(true);
            FileObject fileObject = this.fs.findResource("Modules");
            Iterator iterator = prepared.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Map map = (Map)entry.getValue();
                if (fileObject.getFileObject(string + ".xml") != null) continue;
                FileObject fileObject2 = fileObject.createData(string + ".xml");
                FileLock fileLock = fileObject2.lock();
                OutputStream outputStream = null;
                try {
                    outputStream = fileObject2.getOutputStream(fileLock);
                    this.writeStatus(map, outputStream);
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    fileLock.releaseLock();
                }
            }
        }

        private void writeStatus(Map map, OutputStream outputStream) throws IOException {
            String string = (String)map.get(SafeModule.ATTR_NAME);
            if (string == null) {
                throw new IllegalArgumentException("no code name present");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            outputStreamWriter.write("<!DOCTYPE module PUBLIC \"");
            outputStreamWriter.write(SafeModule.PUBLIC_ID);
            outputStreamWriter.write("\"\n                        \"");
            outputStreamWriter.write(SafeModule.SYSTEM_ID);
            outputStreamWriter.write("\">\n");
            outputStreamWriter.write("<module name=\"");
            outputStreamWriter.write(XMLUtil.toAttributeValue((String)string));
            outputStreamWriter.write("\">\n");
            Iterator iterator = new TreeMap(map).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string2 = (String)entry.getKey();
                if (string2.equals("installerState") || string2.equals(SafeModule.ATTR_NAME)) continue;
                Object v = entry.getValue();
                outputStreamWriter.write("    <param name=\"");
                outputStreamWriter.write(XMLUtil.toAttributeValue((String)string2));
                outputStreamWriter.write("\">");
                outputStreamWriter.write(XMLUtil.toElementContent((String)v.toString()));
                outputStreamWriter.write("</param>\n");
            }
            outputStreamWriter.write("</module>\n");
            ((Writer)outputStreamWriter).flush();
        }
    }

    static class ErrorCatcher
    implements ErrorHandler {
        ErrorCatcher() {
        }

        private void message(String string, SAXParseException sAXParseException) {
        }

        public void error(SAXParseException sAXParseException) {
        }

        public void warning(SAXParseException sAXParseException) {
            ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) {
        }
    }

    static class Module {
        private String name;
        private String specVersion;
        private String release;

        Module() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getSpecVersion() {
            return this.specVersion;
        }

        public void setSpecVersion(String string) {
            this.specVersion = string;
        }

        public String getRelease() {
            return this.release;
        }

        public void setRelease(String string) {
            this.release = string;
        }
    }

    static class ModuleStatus {
        private boolean autoload;
        private boolean eager;
        private String origin;
        private String jar;

        ModuleStatus() {
        }

        boolean isAutoload() {
            return this.autoload;
        }

        void setAutoload(boolean bl) {
            this.autoload = bl;
        }

        boolean isEager() {
            return this.eager;
        }

        void setEager(boolean bl) {
            this.eager = bl;
        }

        String getOrigin() {
            return this.origin;
        }

        void setOrigin(String string) {
            this.origin = string;
        }

        String getJar() {
            return this.jar;
        }

        String getJarName() {
            return this.jar.substring(0, this.jar.indexOf(46));
        }

        void setJar(String string) {
            this.jar = string;
        }

        boolean isFromUser() {
            return this.origin.startsWith(SafeModule.PROP_USER);
        }

        String getJarPath() {
            String string = "modules/";
            if (this.autoload) {
                string = string + SafeModule.AUTOLOAD_SLASH;
            } else if (this.eager) {
                string = string + SafeModule.EAGER_SLASH;
            }
            return string;
        }
    }
}

