/*
 * Decompiled with CFR 0.152.
 */
package tr.prefs.general;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import tr.prefs.general.GeneralOptionsModel;
import tr.prefs.general.GeneralOptionsPanelController;
import tr.prefs.general.GeneralPrefs;

final class GeneralOptionsPanel
extends JPanel {
    private static final String[] periods = new String[]{GeneralOptionsPanel.loc("CTL_Update_every_startup"), GeneralOptionsPanel.loc("CTL_Update_every_day"), GeneralOptionsPanel.loc("CTL_Update_every_week"), GeneralOptionsPanel.loc("CTL_Update_every_2_weeks"), GeneralOptionsPanel.loc("CTL_Update_every_month"), GeneralOptionsPanel.loc("CTL_Update_never")};
    private final GeneralOptionsPanelController controller;
    private final GeneralOptionsModel model = new GeneralOptionsModel();
    private JCheckBox askBeforeCheckBox;
    private JLabel jLabel2;
    private JLabel modulesLabel;
    private JComboBox periodCombo;
    private JLabel periodLabel;
    private JLabel versionLabel;
    private JComboBox versionPeriodCombo;
    private JLabel versionPeriodLabel;

    private static String loc(String key) {
        return NbBundle.getMessage((Class)GeneralOptionsPanel.class, (String)key);
    }

    GeneralOptionsPanel(GeneralOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.periodLabel = new JLabel();
        this.periodCombo = new JComboBox();
        this.modulesLabel = new JLabel();
        this.askBeforeCheckBox = new JCheckBox();
        this.versionLabel = new JLabel();
        this.versionPeriodLabel = new JLabel();
        this.versionPeriodCombo = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)"jLabel2");
        this.setMinimumSize(new Dimension(0, 0));
        Mnemonics.setLocalizedText((JLabel)this.periodLabel, (String)this.getCheckPeriodText());
        this.periodCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.periodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneralOptionsPanel.this.actionPerformed(evt);
            }
        });
        this.modulesLabel.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.modulesLabel, (String)this.getModulesCheckText());
        Mnemonics.setLocalizedText((AbstractButton)this.askBeforeCheckBox, (String)this.getAskBeforeCheck());
        this.askBeforeCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.askBeforeCheckBox.setHorizontalTextPosition(10);
        this.askBeforeCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.askBeforeCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneralOptionsPanel.this.actionPerformed(evt);
            }
        });
        this.versionLabel.setFont(new Font("Lucida Grande", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.versionLabel, (String)this.getVersionCheckText());
        Mnemonics.setLocalizedText((JLabel)this.versionPeriodLabel, (String)this.getCheckPeriodText());
        this.versionPeriodCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.versionPeriodCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneralOptionsPanel.this.actionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.versionLabel, -1, 548, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.versionPeriodLabel, -2, 168, -2).add(17, 17, 17).add((Component)this.versionPeriodCombo, 0, 363, Short.MAX_VALUE)).add((Component)this.modulesLabel, -1, 548, Short.MAX_VALUE)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.periodLabel, -2, 169, -2).add(15, 15, 15).add((Component)this.periodCombo, 0, 364, Short.MAX_VALUE).add(20, 20, 20)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.askBeforeCheckBox, -1, 545, Short.MAX_VALUE).add(23, 23, 23)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.versionLabel).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.versionPeriodLabel).add((Component)this.versionPeriodCombo, -2, -1, -2)).add(21, 21, 21).add((Component)this.modulesLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.periodLabel).add((Component)this.periodCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.askBeforeCheckBox).addContainerGap(139, Short.MAX_VALUE)));
    }

    private void actionPerformed(ActionEvent evt) {
        this.controller.changed();
    }

    private String getVersionCheckText() {
        return NbBundle.getMessage(this.getClass(), (String)"LBL_VersionCheck");
    }

    private String getModulesCheckText() {
        return NbBundle.getMessage(this.getClass(), (String)"LBL_ModulesCheck");
    }

    private String getCheckPeriodText() {
        return NbBundle.getMessage(this.getClass(), (String)"LBL_CheckPeriod");
    }

    private String getAskBeforeCheck() {
        return NbBundle.getMessage(this.getClass(), (String)"LBL_AskBeforeCheck");
    }

    void load() {
        this.versionPeriodCombo.setModel(new DefaultComboBoxModel<String>(periods));
        this.versionPeriodCombo.setMaximumRowCount(periods.length);
        this.versionPeriodCombo.setSelectedIndex(GeneralPrefs.getVersionCheckPeriod());
        this.askBeforeCheckBox.setSelected(this.model.getAutoUpdateAskBeforeCheck());
        this.periodCombo.setModel(new DefaultComboBoxModel<String>(periods));
        this.periodCombo.setMaximumRowCount(periods.length);
        this.periodCombo.setSelectedIndex(this.model.getAutoUpdatePeriod());
    }

    void store() {
        GeneralPrefs.setVersionCheckPeriod(this.versionPeriodCombo.getSelectedIndex());
        this.model.setAutoUpdateAskBeforeCheck(this.askBeforeCheckBox.isSelected());
        this.model.setAutoUpdatePeriod(this.periodCombo.getSelectedIndex());
    }

    boolean valid() {
        return true;
    }
}

