/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.ActionMap;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.Window;
import tr.view.future.Resources;
import tr.view.future.TopicChildren;

public final class FutureTopicsTopComponent
extends Window
implements ExplorerManager.Provider {
    private static FutureTopicsTopComponent instance;
    private static final String PREFERRED_ID = "FutureTopicsTopComponent";
    private final ExplorerManager manager = new ExplorerManager();
    private transient Lookup.Result dataResult;
    private transient boolean initialised;

    private FutureTopicsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(FutureTopicsTopComponent.class, (String)"CTL_TopicsListTopComponent"));
        this.setToolTipText(NbBundle.getMessage(FutureTopicsTopComponent.class, (String)"TTT_TopicsListTopComponent"));
        this.setIcon(Resources.ICON_FUTURE.getImage());
        ActionMap map = this.getActionMap();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map));
        ListView view = new ListView();
        this.add((Component)view, "Center");
        if ((Utilities.getOperatingSystem() & 0xA007) != 0) {
            view.getViewport().getView().setFont(new Font("SansSerif", 0, 12));
        }
    }

    private void initialise() {
        if (this.dataResult == null) {
            this.dataResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.dataResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    FutureTopicsTopComponent.this.initialised = false;
                }
            });
        }
        this.manager.setRootContext((Node)new AbstractNode((Children)new TopicChildren()));
    }

    public void componentOpened() {
        if (!this.initialised) {
            this.initialise();
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized FutureTopicsTopComponent getDefault() {
        if (instance == null) {
            instance = new FutureTopicsTopComponent();
        }
        return instance;
    }

    public static synchronized FutureTopicsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find TopicsList component. It will not be located properly in the window system.");
            return FutureTopicsTopComponent.getDefault();
        }
        if (win instanceof FutureTopicsTopComponent) {
            return (FutureTopicsTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'FutureTopicsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return FutureTopicsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.future");
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return FutureTopicsTopComponent.getDefault();
        }
    }
}

