/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;
import tr.model.future.Future;
import tr.runtime.Open;
import tr.swing.editorpane.HyperEditorPane;
import tr.util.DateButton;

public class FuturePanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("tr.view.future");
    private Future future;
    private boolean updating;
    private DocumentListener docListenerDescription;
    private DocumentListener docListenerNotes;
    private PropertyChangeListener propChangeListenerTickleDate;
    private HyperlinkListener hyperlinkListener;
    private JLabel descriptionLabel;
    private JTextField descriptionText;
    private HyperEditorPane notesEditorPane;
    private JLabel notesLabel;
    private DateButton tickleDateButton;
    private JLabel tickleDateLabel;

    public FuturePanel() {
        this.initComponents();
        this.initModel(null);
    }

    public void deactivate() {
        this.descriptionText.transferFocus();
        this.tickleDateButton.transferFocus();
        this.notesEditorPane.transferFocus();
        this.descriptionText.transferFocus();
        this.tickleDateButton.transferFocus();
        this.notesEditorPane.transferFocus();
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    private void addListeners() {
        this.docListenerDescription = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                FuturePanel.this.changedDescription();
            }

            public void insertUpdate(DocumentEvent arg0) {
                FuturePanel.this.changedDescription();
            }

            public void removeUpdate(DocumentEvent arg0) {
                FuturePanel.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.propChangeListenerTickleDate = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FuturePanel.this.tickleDateButtonPropertyChange(evt);
            }
        };
        this.tickleDateButton.addPropertyChangeListener(this.propChangeListenerTickleDate);
        this.docListenerNotes = new DocumentListener(){

            public void changedUpdate(DocumentEvent arg0) {
                FuturePanel.this.changedNotes();
            }

            public void insertUpdate(DocumentEvent arg0) {
                FuturePanel.this.changedNotes();
            }

            public void removeUpdate(DocumentEvent arg0) {
                FuturePanel.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.docListenerNotes);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                FuturePanel.this.hyperlink(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.hyperlinkListener);
    }

    private void removeListeners() {
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.tickleDateButton.removePropertyChangeListener(this.propChangeListenerTickleDate);
        this.notesEditorPane.removeDocumentListener(this.docListenerNotes);
        this.notesEditorPane.removeHyperlinkListener(this.hyperlinkListener);
        this.docListenerDescription = null;
        this.propChangeListenerTickleDate = null;
        this.docListenerNotes = null;
        this.hyperlinkListener = null;
    }

    private void hyperlink(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void changedDescription() {
        if (this.future == null || this.updating) {
            return;
        }
        this.future.setDescription(this.descriptionText.getText());
    }

    private void tickleDateButtonPropertyChange(PropertyChangeEvent evt) {
        if (this.future == null || this.updating) {
            return;
        }
        this.future.setTickle(this.tickleDateButton.getDate());
    }

    private void changedNotes() {
        if (this.future == null || this.updating) {
            return;
        }
        this.future.setNotes(this.notesEditorPane.getText());
    }

    private void initComponents() {
        this.descriptionLabel = new JLabel();
        this.descriptionText = new JTextField();
        this.notesLabel = new JLabel();
        this.notesEditorPane = new HyperEditorPane();
        this.tickleDateLabel = new JLabel();
        this.tickleDateButton = new DateButton();
        this.descriptionLabel.setText(NbBundle.getMessage(FuturePanel.class, (String)"FuturePanel.descriptionLabel.text"));
        this.notesLabel.setText(NbBundle.getMessage(FuturePanel.class, (String)"FuturePanel.notesLabel.text"));
        this.tickleDateLabel.setHorizontalAlignment(11);
        this.tickleDateLabel.setText(NbBundle.getMessage(FuturePanel.class, (String)"FuturePanel.tickle"));
        this.tickleDateButton.setNoSelectionText("Select a date");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.descriptionLabel).add((Component)this.tickleDateLabel, -2, 73, -2).add((Component)this.notesLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.tickleDateButton, -2, 144, -2).add((Component)this.descriptionText, -1, 271, Short.MAX_VALUE).add((Component)this.notesEditorPane, -1, 271, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionLabel).add((Component)this.descriptionText, -2, -1, -2)).add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.tickleDateLabel).add((Component)this.tickleDateButton, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.notesEditorPane, -1, 95, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add(31, 31, 31).add((Component)this.notesLabel))).addContainerGap()));
    }

    public void initModel(Future future) {
        this.future = future;
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.future == null) {
            this.descriptionText.setText("");
            this.notesEditorPane.setText("");
            this.tickleDateButton.setDate(null);
            this.setEnabled(false);
        } else {
            this.descriptionText.setText(this.future.getDescription());
            this.notesEditorPane.setText(this.future.getNotes());
            this.tickleDateButton.setDate(this.future.getTickle());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.tickleDateButton.setEnabled(enabled);
        this.tickleDateLabel.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
    }
}

