/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProductInformationPanel
extends JPanel {
    private static final int FONT_SIZE_PLUS = 5;
    private static final Color COLOR = Color.black;
    private static Dialog dialog;
    private JLabel currentDirLabel;
    private JLabel currentDirValueLabel;
    private JLabel homeDirLabel;
    private JLabel homeDirValueLabel;
    private JLabel ideImageLabel;
    private JLabel ideInstallLabel;
    private JTextArea ideInstallValueField;
    private JPanel jPanel1;
    private JLabel javaHomeLabel;
    private JLabel javaHomeValueLabel;
    private JLabel javaLabel;
    private JLabel javaValueLabel;
    private JLabel operatingSystemLabel;
    private JLabel operatingSystemValueLabel;
    private JLabel productInformationLabel;
    private JLabel productVersionLabel;
    private JLabel productVersionValueLabel;
    private JLabel systemLocaleLabel;
    private JLabel systemLocaleValueLabel;
    private JLabel userDirLabel;
    private JLabel userDirValueLabel;
    private JLabel vendorLabel;
    private JLabel vendorValueLabel;
    private JLabel vmLabel;
    private JLabel vmValueLabel;

    public ProductInformationPanel() {
        dialog = null;
        this.initComponents();
        this.initAccessibility();
        this.updateLabelFont(this.productInformationLabel, 1, 5, COLOR);
        this.updateLabelFont(this.productVersionLabel, 1, COLOR);
        this.updateLabelFont(this.operatingSystemLabel, 1, COLOR);
        this.updateLabelFont(this.javaLabel, 1, COLOR);
        this.updateLabelFont(this.vmLabel, 1, COLOR);
        this.updateLabelFont(this.vendorLabel, 1, COLOR);
        this.updateLabelFont(this.javaHomeLabel, 1, COLOR);
        this.updateLabelFont(this.systemLocaleLabel, 1, COLOR);
        this.updateLabelFont(this.homeDirLabel, 1, COLOR);
        this.updateLabelFont(this.currentDirLabel, 1, COLOR);
        this.updateLabelFont(this.ideInstallLabel, 1, COLOR);
        this.updateLabelFont(this.userDirLabel, 1, COLOR);
        this.updateLabelFont(this.productVersionValueLabel, COLOR);
        this.updateLabelFont(this.operatingSystemValueLabel, COLOR);
        this.updateLabelFont(this.javaValueLabel, COLOR);
        this.updateLabelFont(this.vmValueLabel, COLOR);
        this.updateLabelFont(this.vendorValueLabel, COLOR);
        this.updateLabelFont(this.javaHomeValueLabel, COLOR);
        this.updateLabelFont(this.systemLocaleValueLabel, COLOR);
        this.updateLabelFont(this.homeDirValueLabel, COLOR);
        this.updateLabelFont(this.currentDirValueLabel, COLOR);
        this.updateLabelFont(this.ideInstallValueField, COLOR);
        this.updateLabelFont(this.userDirValueLabel, COLOR);
        if (this.ideInstallValueField.getText().length() == 0) {
            this.ideInstallLabel.setVisible(false);
            this.ideInstallValueField.setVisible(false);
        }
    }

    private void initComponents() {
        this.ideImageLabel = new JLabel();
        this.productVersionLabel = new JLabel();
        this.operatingSystemLabel = new JLabel();
        this.javaLabel = new JLabel();
        this.vmLabel = new JLabel();
        this.vendorLabel = new JLabel();
        this.javaHomeLabel = new JLabel();
        this.systemLocaleLabel = new JLabel();
        this.homeDirLabel = new JLabel();
        this.currentDirLabel = new JLabel();
        this.ideInstallLabel = new JLabel();
        this.userDirLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.productInformationLabel = new FocusableLabel();
        this.productVersionValueLabel = new FocusableLabel();
        this.operatingSystemValueLabel = new FocusableLabel();
        this.javaValueLabel = new FocusableLabel();
        this.vmValueLabel = new FocusableLabel();
        this.vendorValueLabel = new FocusableLabel();
        this.javaHomeValueLabel = new FocusableLabel();
        this.systemLocaleValueLabel = new FocusableLabel();
        this.homeDirValueLabel = new FocusableLabel();
        this.currentDirValueLabel = new FocusableLabel();
        this.ideInstallValueField = new JTextArea();
        this.userDirValueLabel = new FocusableLabel();
        this.setLayout(new GridBagLayout());
        this.ideImageLabel.setIcon(this.getIcon());
        this.ideImageLabel.setLabelFor(this.productInformationLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.ideImageLabel, gridBagConstraints);
        this.productVersionLabel.setLabelFor(this.productVersionValueLabel);
        this.productVersionLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_ProductVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.productVersionLabel, gridBagConstraints);
        this.operatingSystemLabel.setLabelFor(this.operatingSystemValueLabel);
        this.operatingSystemLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_OperationgSystem"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.operatingSystemLabel, gridBagConstraints);
        this.javaLabel.setLabelFor(this.javaValueLabel);
        this.javaLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_Java"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.javaLabel, gridBagConstraints);
        this.vmLabel.setLabelFor(this.vmValueLabel);
        this.vmLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_VM"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.vmLabel, gridBagConstraints);
        this.vendorLabel.setLabelFor(this.vendorValueLabel);
        this.vendorLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_Vendor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.vendorLabel, gridBagConstraints);
        this.javaHomeLabel.setLabelFor(this.javaHomeValueLabel);
        this.javaHomeLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_JavaHome"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.javaHomeLabel, gridBagConstraints);
        this.systemLocaleLabel.setLabelFor(this.systemLocaleValueLabel);
        this.systemLocaleLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_SystemLocale"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.systemLocaleLabel, gridBagConstraints);
        this.homeDirLabel.setLabelFor(this.homeDirValueLabel);
        this.homeDirLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_HomeDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.homeDirLabel, gridBagConstraints);
        this.currentDirLabel.setLabelFor(this.currentDirValueLabel);
        this.currentDirLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_CurrentDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.currentDirLabel, gridBagConstraints);
        this.ideInstallLabel.setLabelFor(this.ideInstallValueField);
        this.ideInstallLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_IDEInstall"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 11, 0);
        this.add((Component)this.ideInstallLabel, gridBagConstraints);
        this.userDirLabel.setLabelFor(this.userDirValueLabel);
        this.userDirLabel.setText(NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_UserDir"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add((Component)this.userDirLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.productInformationLabel.setText(this.getProductInformationTitle());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.productInformationLabel, gridBagConstraints);
        this.productVersionValueLabel.setText(this.getProductVersionValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        this.add((Component)this.productVersionValueLabel, gridBagConstraints);
        this.operatingSystemValueLabel.setText(this.getOperatingSystemValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.operatingSystemValueLabel, gridBagConstraints);
        this.javaValueLabel.setText(this.getJavaValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.javaValueLabel, gridBagConstraints);
        this.vmValueLabel.setText(this.getVMValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.vmValueLabel, gridBagConstraints);
        this.vendorValueLabel.setText(this.getVendorValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.vendorValueLabel, gridBagConstraints);
        this.javaHomeValueLabel.setText(this.getJavaHomeValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.javaHomeValueLabel, gridBagConstraints);
        this.systemLocaleValueLabel.setText(this.getSystemLocaleValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.systemLocaleValueLabel, gridBagConstraints);
        this.homeDirValueLabel.setText(this.getHomeDirValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.homeDirValueLabel, gridBagConstraints);
        this.currentDirValueLabel.setText(this.getCurrentDirValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.currentDirValueLabel, gridBagConstraints);
        this.ideInstallValueField.setEditable(false);
        this.ideInstallValueField.setText(this.getIDEInstallValue());
        this.ideInstallValueField.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 12, 11, 11);
        this.add((Component)this.ideInstallValueField, gridBagConstraints);
        this.userDirValueLabel.setText(this.getUserDirValue());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 0, 11);
        this.add((Component)this.userDirValueLabel, gridBagConstraints);
    }

    private String fromBundle(String string) {
        return NbBundle.getMessage((Class)ProductInformationPanel.class, (String)string);
    }

    private void updateLabelFont(JComponent jComponent, Color color) {
        this.updateLabelFont(jComponent, 0, 0, color);
    }

    private void updateLabelFont(JComponent jComponent, int n, Color color) {
        this.updateLabelFont(jComponent, n, 0, color);
    }

    private void updateLabelFont(JComponent jComponent, int n, int n2, Color color) {
        Font font = jComponent.getFont();
        if (n != 0) {
            font = Utilities.getOperatingSystem() == 4096 ? new Font(jComponent.getFont().getName(), 1, jComponent.getFont().getSize()) : jComponent.getFont().deriveFont(1);
            jComponent.setFont(font);
        }
        if ((float)n2 != 0.0f) {
            font = new Font(font.getName(), font.getStyle(), font.getSize() + n2);
            jComponent.setFont(font);
        }
        if (color != null) {
            jComponent.setForeground(color);
        }
    }

    private ImageIcon getIcon() {
        return new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/startup/frame48.gif", (boolean)true));
    }

    private String getProductInformationTitle() {
        return NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"LBL_ProductInformation");
    }

    private String getProductVersionValue() {
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
    }

    private String getOperatingSystemValue() {
        return NbBundle.getMessage((Class)ProductInformationPanel.class, (String)"Format_OperatingSystem_Value", (Object)System.getProperty("os.name", "unknown"), (Object)System.getProperty("os.version", "unknown"), (Object)System.getProperty("os.arch", "unknown"));
    }

    private String getJavaValue() {
        return System.getProperty("java.version", "unknown");
    }

    private String getVMValue() {
        return System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "");
    }

    private String getVendorValue() {
        return System.getProperty("java.vendor", "unknown");
    }

    private String getJavaHomeValue() {
        return System.getProperty("java.home", "unknown");
    }

    private String getSystemLocaleValue() {
        String string;
        return Locale.getDefault().toString() + ((string = NbBundle.getBranding()) == null ? "" : " (" + string + ")");
    }

    private String getHomeDirValue() {
        return System.getProperty("user.home", "unknown");
    }

    private String getCurrentDirValue() {
        return System.getProperty("user.dir", "unknown");
    }

    private String getIDEInstallValue() {
        String string = System.getProperty("netbeans.home");
        String string2 = System.getProperty("netbeans.dirs");
        Enumeration<Object> enumeration = string2 != null ? new StringTokenizer(string2, File.pathSeparator) : Enumerations.empty();
        Enumeration enumeration2 = Enumerations.concat((Enumeration)Enumerations.singleton((Object)string), (Enumeration)enumeration);
        HashSet<File> hashSet = new HashSet<File>();
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "";
        while (enumeration2.hasMoreElements()) {
            File file;
            String string4 = (String)enumeration2.nextElement();
            if (string4 == null || !hashSet.add(file = FileUtil.normalizeFile((File)new File(string4)))) continue;
            stringBuffer.append(string3);
            stringBuffer.append(file.getAbsolutePath());
            string3 = "\n";
        }
        return stringBuffer.toString();
    }

    private String getUserDirValue() {
        return System.getProperty("netbeans.user");
    }

    private void initAccessibility() {
        this.productVersionValueLabel.getAccessibleContext().setAccessibleName(this.productVersionLabel.getText() + this.productVersionValueLabel.getText());
        this.operatingSystemValueLabel.getAccessibleContext().setAccessibleName(this.operatingSystemLabel.getText() + this.operatingSystemValueLabel.getText());
        this.javaValueLabel.getAccessibleContext().setAccessibleName(this.javaLabel.getText() + this.vmValueLabel.getText());
        this.vmValueLabel.getAccessibleContext().setAccessibleName(this.vmLabel.getText() + this.vmValueLabel.getText());
        this.vendorValueLabel.getAccessibleContext().setAccessibleName(this.vendorLabel.getText() + this.vendorValueLabel.getText());
        this.javaHomeValueLabel.getAccessibleContext().setAccessibleName(this.javaHomeLabel.getText() + this.javaHomeValueLabel.getText());
        this.systemLocaleValueLabel.getAccessibleContext().setAccessibleName(this.systemLocaleLabel.getText() + this.systemLocaleValueLabel.getText());
        this.homeDirValueLabel.getAccessibleContext().setAccessibleName(this.homeDirLabel.getText() + this.homeDirValueLabel.getText());
        this.currentDirValueLabel.getAccessibleContext().setAccessibleName(this.currentDirLabel.getText() + this.currentDirValueLabel.getText());
        this.ideInstallValueField.getAccessibleContext().setAccessibleName(this.ideInstallLabel.getText() + this.ideInstallValueField.getText());
        this.userDirValueLabel.getAccessibleContext().setAccessibleName(this.userDirLabel.getText() + this.userDirValueLabel.getText());
    }

    static class FocusableLabel
    extends JLabel {
        private boolean isFocused = false;

        public FocusableLabel() {
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    FocusableLabel.this.isFocused = true;
                    FocusableLabel.this.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    FocusableLabel.this.isFocused = false;
                    FocusableLabel.this.repaint();
                }
            });
            this.getAccessibleContext().setAccessibleDescription(this.getText());
            this.getAccessibleContext().setAccessibleName(this.getText());
        }

        public boolean isFocusTraversable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics graphics) {
            if (this.ui != null) {
                try {
                    this.ui.update(graphics, this);
                }
                finally {
                    graphics.dispose();
                }
            }
            if (this.isFocused) {
                Dimension dimension = this.getSize();
                graphics.setColor(UIManager.getColor("Button.focus"));
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }
    }
}

