/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

abstract class DefaultParser
extends DefaultHandler {
    protected FileObject fo;
    private Locator locator = null;
    protected short state = 0;
    protected static final short PARSED = 1000;
    protected static final short ERROR = -1;
    protected static final short INIT = 0;

    protected DefaultParser() {
    }

    protected DefaultParser(FileObject fileObject) {
        this.fo = fileObject;
    }

    protected XMLReader createXMLReader() throws IOException, SAXException {
        return XMLUtil.createXMLReader((boolean)false);
    }

    protected boolean isStopException(Exception exception) {
        return false;
    }

    protected short getState() {
        return this.state;
    }

    protected final Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(FileObject fileObject) {
        this.state = 0;
        InputStream inputStream = null;
        this.fo = fileObject;
        try {
            XMLReader xMLReader = this.createXMLReader();
            xMLReader.setEntityResolver(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setContentHandler(this);
            InputSource inputSource = new InputSource();
            inputStream = fileObject.getInputStream();
            inputSource.setByteStream(inputStream);
            inputSource.setSystemId(fileObject.getURL().toExternalForm());
            this.customizeInputSource(inputSource);
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            if (!this.isStopException(iOException) && fileObject.isValid() && fileObject.canRead()) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.log("While parsing: " + fileObject.toString());
                errorManager.notify(1, (Throwable)iOException);
                this.state = (short)-1;
            }
        }
        catch (SAXException sAXException) {
            if (!this.isStopException(sAXException)) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)sAXException, 0, "While parsing: " + fileObject, null, null, null);
                errorManager.notify(1, (Throwable)sAXException);
                this.state = (short)-1;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void customizeInputSource(InputSource inputSource) {
    }

    protected final void parse() {
        if (this.fo == null) {
            throw new NullPointerException();
        }
        this.parse(this.fo);
    }

    protected void error() throws SAXException {
        String string = NbBundle.getMessage((Class)DefaultParser.class, (String)"Invalid_XML_document");
        this.error(string);
    }

    protected void error(String string) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer(string).append(": ").append(this.fo.toString());
        if (this.locator != null) {
            stringBuffer.append(" line: ").append(this.locator.getLineNumber());
            stringBuffer.append(" column: ").append(this.locator.getColumnNumber());
        }
        String string2 = stringBuffer.toString();
        SAXException sAXException = new SAXException(string2);
        throw sAXException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void endDocument() throws SAXException {
        this.state = (short)1000;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }
}

