/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.awt.Color;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.ui.ProductInformationPanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public class AboutAction
extends CallableSystemAction {
    public AboutAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public void performAction() {
        Splash.showSplashDialog((Frame)WindowManager.getDefault().getMainWindow(), (JComponent)new ProductInformationPanel(), (JComponent)AboutAction.getLicenseComp());
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AboutAction.class);
    }

    public String getName() {
        return NbBundle.getMessage((Class)AboutAction.class, (String)"About");
    }

    static JComponent getLicenseComp() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("About/Licenses");
        if (fileObject == null) {
            return null;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray.length <= 0) {
            return null;
        }
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            String string = AboutAction.loadLicenseText(fileObjectArray[i]);
            if (string != null) {
                stringWriter.write(string);
                bl = true;
            }
            if (i >= fileObjectArray.length - 1) continue;
            stringWriter.write("\n");
        }
        if (!bl) {
            return null;
        }
        JTextArea jTextArea = new JTextArea(stringWriter.toString(), 4, 0);
        jTextArea.setBorder(new EmptyBorder(5, 12, 0, 12));
        jTextArea.setEditable(false);
        jTextArea.setBackground(new Color(0, 27, 51));
        jTextArea.setForeground(Color.WHITE);
        jTextArea.setFont(jTextArea.getFont().deriveFont(9.0f));
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    private static String loadLicenseText(FileObject fileObject) {
        InputStream inputStream = null;
        try {
            inputStream = fileObject.getInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = MessageFormat.format(NbBundle.getBundle((Class)AboutAction.class).getString("EXC_LicenseFileNotFound"), fileObject.getPath());
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)fileNotFoundException, string);
            errorManager.notify(1, (Throwable)fileNotFoundException);
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = bufferedReader.read()) != -1) {
                stringWriter.write(n);
            }
        }
        catch (IOException iOException) {
            String string = MessageFormat.format(NbBundle.getBundle((Class)AboutAction.class).getString("EXC_LicenseReadBroken"), fileObject.getPath());
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.annotate((Throwable)iOException, string);
            errorManager.notify(1, (Throwable)iOException);
            return null;
        }
        return stringWriter.toString();
    }
}

