/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import org.netbeans.core.FlashingIcon;
import org.netbeans.core.NbErrorManager;
import org.netbeans.core.startup.CLIOptions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class NotifyException
extends JPanel
implements ActionListener {
    static final long serialVersionUID = 3680397500573480127L;
    private static NotifyException INSTANCE;
    private static final int MAXIMUM_TEXT_WIDTH = 40;
    private static final int SIZE_PREFERRED_WIDTH = 550;
    private static final int SIZE_PREFERRED_HEIGHT = 250;
    private static ArrayListPos exceptions;
    private NbErrorManager.Exc current;
    private DialogDescriptor descriptor;
    Dialog dialog;
    private JButton next;
    private JButton previous;
    private JButton details;
    private JTextPane output;
    private static boolean showDetails;
    private static Rectangle lastBounds;
    private static ExceptionFlasher flasher;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NotifyException() {
        this.setPreferredSize(new Dimension(550, 250));
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)NotifyException.class);
        this.next = new JButton(resourceBundle.getString("CTL_NextException"));
        this.next.setDefaultCapable(false);
        this.previous = new JButton(resourceBundle.getString("CTL_PreviousException"));
        this.previous.setDefaultCapable(false);
        this.details = new JButton();
        this.details.setDefaultCapable(false);
        this.output = new JTextPane(){

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.output.setEditable(false);
        this.output.setFont(new Font("Monospaced", 0, this.output.getFont().getSize() + 1));
        this.output.setForeground(UIManager.getColor("Label.foreground"));
        this.output.setBackground(UIManager.getColor("Label.background"));
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.output));
        this.setBorder(new BevelBorder(1));
        this.next.setMnemonic(resourceBundle.getString("CTL_NextException_Mnemonic").charAt(0));
        this.previous.setMnemonic(resourceBundle.getString("CTL_PreviousException_Mnemonic").charAt(0));
        this.next.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_NextException"));
        this.previous.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_PreviousException"));
        this.output.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_ExceptionStackTrace"));
        this.output.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ExceptionStackTrace"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_NotifyExceptionPanel"));
        this.descriptor = new DialogDescriptor((Object)"", "");
        this.descriptor.setMessageType(0);
        this.descriptor.setOptions(new Object[]{this.previous, this.next, DialogDescriptor.OK_OPTION});
        this.descriptor.setAdditionalOptions(new Object[]{this.details});
        this.descriptor.setClosingOptions(new Object[0]);
        this.descriptor.setButtonListener((ActionListener)this);
        this.descriptor.setModal(NotifyException.isModalDialogPresent() && WindowManager.getDefault().getMainWindow().isVisible());
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        if (null != lastBounds) {
            this.dialog.setBounds(lastBounds);
        }
    }

    private static boolean isModalDialogPresent() {
        return NotifyException.hasModalDialog(WindowManager.getDefault().getMainWindow()) || NotifyException.hasModalDialog(new JDialog().getOwner());
    }

    private static boolean hasModalDialog(Window window) {
        if (window == null) {
            return false;
        }
        Window[] windowArray = window.getOwnedWindows();
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] instanceof Dialog && ((Dialog)windowArray[i]).isModal() && windowArray[i].isVisible()) {
                return true;
            }
            if (!NotifyException.hasModalDialog(windowArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssertionsEnabled() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl;
    }

    static NotifyException newInstance() {
        return new NotifyException();
    }

    public static void notify(final NbErrorManager.Exc exc) {
        if ("java.awt.HeadlessException".equals(exc.getClassName()) && GraphicsEnvironment.isHeadless()) {
            exc.printStackTrace(System.err);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String string = exc.getLocalizedMessage();
                int n = exc.getSeverity();
                boolean bl = exc.isLocalized();
                if (n == 16 && bl) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
                } else if (n == 256 && bl) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 1));
                } else if (n == 65536 && bl) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                } else {
                    if (null == exceptions) {
                        exceptions = new ArrayListPos();
                    }
                    exceptions.add(exc);
                    exceptions.position = exceptions.size() - 1;
                    if (NotifyException.isAssertionsEnabled()) {
                        if (INSTANCE == null) {
                            INSTANCE = new NotifyException();
                        }
                        INSTANCE.updateState(exc);
                    } else if (null != flasher && null == INSTANCE) {
                        flasher.setToolTipText(NotifyException.getExceptionSummary(exc));
                        flasher.startFlashing();
                    } else {
                        if (INSTANCE == null) {
                            INSTANCE = new NotifyException();
                        }
                        INSTANCE.updateState(exc);
                    }
                }
            }
        });
    }

    private static String getExceptionSummary(NbErrorManager.Exc exc) {
        String string = exc.getLocalizedMessage();
        String string2 = string != null ? string : (exc.getMessage() != null ? exc.getMessage() : exc.getClassName());
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        return string2;
    }

    private void updateState(NbErrorManager.Exc exc) {
        if (!exceptions.existsNextElement()) {
            this.current = exc;
            this.update();
        } else {
            this.next.setVisible(true);
        }
        try {
            this.ensurePreferredSize();
            this.dialog.show();
        }
        catch (Exception exception) {
            exceptions.add(new NbErrorManager().createExc(exception, 4096));
            this.next.setVisible(true);
        }
    }

    private void ensurePreferredSize() {
        if (null != lastBounds) {
            return;
        }
        Dimension dimension = this.dialog.getSize();
        Dimension dimension2 = this.dialog.getPreferredSize();
        if (dimension2.height == 0) {
            dimension2.height = 250;
        }
        if (dimension2.width == 0) {
            dimension2.width = 550;
        }
        if (!dimension.equals(dimension2)) {
            this.dialog.setSize(dimension2.width, dimension2.height);
            this.dialog.validate();
            this.dialog.repaint();
        }
    }

    private void update() {
        boolean bl = this.current.isLocalized();
        this.next.setVisible(exceptions.existsNextElement());
        this.previous.setVisible(exceptions.existsPreviousElement());
        if (showDetails) {
            this.details.setText(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Hide_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Hide_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)NotifyException.class).getString("ACSD_Exception_Hide_Details"));
        } else {
            this.details.setText(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Show_Details"));
            this.details.setMnemonic(NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Exception_Show_Details_Mnemonic").charAt(0));
            this.details.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)NotifyException.class).getString("ACSD_Exception_Show_Details"));
        }
        String string = NbBundle.getBundle((Class)NotifyException.class).getString("CTL_Title_Exception");
        if (showDetails) {
            this.descriptor.setMessage((Object)this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StringWriter stringWriter = new StringWriter();
                    NotifyException.this.current.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                    NotifyException.this.output.setText(stringWriter.toString());
                    NotifyException.this.output.getCaret().setDot(0);
                    NotifyException.this.output.requestFocus();
                }
            });
        } else if (bl) {
            String string2 = this.current.getLocalizedMessage();
            if (string2 != null) {
                this.descriptor.setMessage((Object)string2);
            }
        } else {
            ResourceBundle resourceBundle = NbBundle.getBundle((Class)NotifyException.class);
            if (this.current.getSeverity() == 16) {
                this.descriptor.setMessage((Object)MessageFormat.format(resourceBundle.getString("NTF_ExceptionWarning"), this.current.getClassName()));
                string = resourceBundle.getString("NTF_ExceptionWarningTitle");
            } else {
                this.descriptor.setMessage((Object)MessageFormat.format(resourceBundle.getString("NTF_ExceptionalException"), this.current.getClassName(), CLIOptions.getLogDir()));
                string = resourceBundle.getString("NTF_ExceptionalExceptionTitle");
            }
        }
        this.descriptor.setTitle(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.next && exceptions.setNextElement() || actionEvent.getSource() == this.previous && exceptions.setPreviousElement()) {
            this.current = (NbErrorManager.Exc)exceptions.get();
            this.update();
            return;
        }
        if (actionEvent.getSource() == this.details) {
            showDetails = !showDetails;
            lastBounds = null;
            try {
                this.update();
                this.ensurePreferredSize();
            }
            catch (Exception exception) {
                exceptions.add(new NbErrorManager().createExc(exception, 4096));
                this.next.setVisible(true);
            }
            return;
        }
        if (actionEvent.getSource() == DialogDescriptor.OK_OPTION || actionEvent.getSource() == DialogDescriptor.CLOSED_OPTION) {
            try {
                exceptions.removeAll();
                lastBounds = this.dialog.getBounds();
                this.dialog.dispose();
                exceptions = null;
                INSTANCE = null;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            finally {
                exceptions = null;
                INSTANCE = null;
            }
        }
    }

    public static Component getNotificationVisualizer() {
        if (NotifyException.isAssertionsEnabled()) {
            return null;
        }
        if (null == flasher) {
            ImageIcon imageIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/core/resources/exception.gif", (boolean)true));
            flasher = new ExceptionFlasher(imageIcon);
        }
        return flasher;
    }

    static {
        $assertionsDisabled = !NotifyException.class.desiredAssertionStatus();
        INSTANCE = null;
        flasher = null;
    }

    protected static class ArrayListPos
    extends ArrayList {
        protected int position = 0;

        protected ArrayListPos() {
        }

        protected boolean existsElement() {
            return this.size() > 0;
        }

        protected boolean existsNextElement() {
            return this.position + 1 < this.size();
        }

        protected boolean existsPreviousElement() {
            return this.position > 0 && this.size() > 0;
        }

        protected boolean setNextElement() {
            if (!this.existsNextElement()) {
                return false;
            }
            ++this.position;
            return true;
        }

        protected boolean setPreviousElement() {
            if (!this.existsPreviousElement()) {
                return false;
            }
            --this.position;
            return true;
        }

        protected Object get() {
            return this.existsElement() ? this.get(this.position) : null;
        }

        protected void removeAll() {
            this.clear();
            this.position = 0;
        }
    }

    private static class ExceptionFlasher
    extends FlashingIcon {
        public ExceptionFlasher(Icon icon) {
            super(icon);
        }

        protected void onMouseClick() {
            if (null != exceptions && exceptions.size() > 0) {
                if (INSTANCE == null) {
                    INSTANCE = new NotifyException();
                }
                INSTANCE.updateState((NbErrorManager.Exc)exceptions.get(exceptions.size() - 1));
            }
        }

        protected void timeout() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (null != INSTANCE) {
                        return;
                    }
                    if (null != exceptions) {
                        exceptions.clear();
                    }
                    exceptions = null;
                }
            });
        }
    }
}

