/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.EnvironmentNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;

public final class NbPlaces {
    private final List listeners = new ArrayList();
    private static NbPlaces DEFAULT;

    private NbPlaces() {
    }

    public static synchronized NbPlaces getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new NbPlaces();
        }
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChange() {
        ChangeListener[] changeListenerArray;
        Object object = this.listeners;
        synchronized (object) {
            changeListenerArray = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        object = new ChangeEvent(this);
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged((ChangeEvent)object);
        }
    }

    public Node environment() {
        return EnvironmentNode.find("environment");
    }

    public Node session() {
        return EnvironmentNode.find("session");
    }

    public Node[] roots() {
        return EnvironmentNode.find("roots").getChildren().getNodes();
    }

    public DataFolder templates() {
        return NbPlaces.findSessionFolder("Templates");
    }

    public DataFolder toolbars() {
        return NbPlaces.findSessionFolder("Toolbars");
    }

    public DataFolder menus() {
        return NbPlaces.findSessionFolder("Menu");
    }

    public DataFolder actions() {
        return NbPlaces.findSessionFolder("Actions");
    }

    public static DataFolder findSessionFolder(String string) {
        try {
            Object object;
            FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) {
                fileObject = fileSystem.getRoot();
                object = new StringTokenizer(string, "/");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    FileObject fileObject2 = fileObject.getFileObject(string2);
                    if (fileObject2 != null && fileObject2.isFolder()) {
                        fileObject = fileObject2;
                        continue;
                    }
                    fileObject = fileObject.createFolder(string2);
                }
            }
            object = DataFolder.findFolder((FileObject)fileObject);
            return object;
        }
        catch (IOException iOException) {
            IllegalStateException illegalStateException = new IllegalStateException("Folder not found and cannot be created: " + string);
            ErrorManager.getDefault().annotate((Throwable)illegalStateException, (Throwable)iOException);
            throw illegalStateException;
        }
    }
}

