/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.beaninfo.editors.ArrayOfIntSupport;
import org.netbeans.beaninfo.editors.DimensionEditor;
import org.netbeans.beaninfo.editors.PointEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public class PointCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    static final long serialVersionUID = -4067033871196801978L;
    private boolean dimensionMode = false;
    private JPanel insidePanel;
    private JTextField xField;
    private JLabel xLabel;
    private JTextField yField;
    private JLabel yLabel;
    private ArrayOfIntSupport editor;

    public PointCustomEditor(PointEditor pointEditor) {
        this.initComponents();
        this.editor = pointEditor;
        Point point = (Point)pointEditor.getValue();
        if (point == null) {
            point = new Point(0, 0);
        }
        this.xField.setText(Integer.toString(point.x));
        this.yField.setText(Integer.toString(point.y));
        this.xLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_X_Mnemonic").charAt(0));
        this.yLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_Y_Mnemonic").charAt(0));
        this.xField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"ACSD_CTL_X"));
        this.yField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"ACSD_CTL_Y"));
        this.commonInit(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_Point"));
    }

    public PointCustomEditor(DimensionEditor dimensionEditor) {
        this.dimensionMode = true;
        this.initComponents();
        this.editor = dimensionEditor;
        Dimension dimension = (Dimension)dimensionEditor.getValue();
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        this.xField.setText(Integer.toString(dimension.width));
        this.yField.setText(Integer.toString(dimension.height));
        this.xLabel.setText(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_Width"));
        this.xLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_Width_mnemonic").charAt(0));
        this.xLabel.setLabelFor(this.xField);
        this.yLabel.setText(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_Height"));
        this.yLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_Height_mnemonic").charAt(0));
        this.yLabel.setLabelFor(this.yField);
        this.xField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"ACSD_CTL_Width"));
        this.yField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"ACSD_CTL_Height"));
        this.commonInit(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_Dimension"));
    }

    private void commonInit(String string) {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PointCustomEditor.class, (String)"ACSD_PointCustomEditor"));
        this.setBorder(new EmptyBorder(12, 12, 0, 11));
        this.insidePanel.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), " " + string + " "), new EmptyBorder(new Insets(5, 5, 5, 5))));
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 160);
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            int n = Integer.parseInt(this.xField.getText());
            int n2 = Integer.parseInt(this.yField.getText());
            if (n < 0 || n2 < 0) {
                IllegalStateException illegalStateException = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)illegalStateException, 256, null, NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_NegativeSize"), null, null);
                throw illegalStateException;
            }
            if (this.dimensionMode) {
                return new Dimension(n, n2);
            }
            return new Point(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            ErrorManager.getDefault().annotate((Throwable)illegalStateException, 256, null, NbBundle.getMessage((Class)PointCustomEditor.class, (String)"CTL_InvalidValue"), null, null);
            throw illegalStateException;
        }
    }

    private void initComponents() {
        this.insidePanel = new JPanel();
        this.xLabel = new JLabel();
        this.xField = new JTextField();
        this.yLabel = new JLabel();
        this.yField = new JTextField();
        this.setLayout(new BorderLayout());
        this.insidePanel.setLayout(new GridBagLayout());
        this.xLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_X"));
        this.xLabel.setLabelFor(this.xField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.insidePanel.add((Component)this.xLabel, gridBagConstraints);
        this.xField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.insidePanel.add((Component)this.xField, gridBagConstraints);
        this.yLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_Y"));
        this.yLabel.setLabelFor(this.yField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.insidePanel.add((Component)this.yLabel, gridBagConstraints);
        this.yField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointCustomEditor.this.updateInsets(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.insidePanel.add((Component)this.yField, gridBagConstraints);
        this.add((Component)this.insidePanel, "Center");
    }

    private void updateInsets(ActionEvent actionEvent) {
        try {
            int n = Integer.parseInt(this.xField.getText());
            int n2 = Integer.parseInt(this.yField.getText());
            if (this.dimensionMode) {
                this.editor.setValue(new Dimension(n, n2));
            } else {
                this.editor.setValue(new Point(n, n2));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

