/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.awt.EventQueue;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import tr.data.Resources;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.model.Data;
import tr.model.DataLookup;
import tr.util.Observable;
import tr.util.Observer;

public final class SaveAction
extends CallableSystemAction
implements Observer {
    public SaveAction() {
        this.setEnabled(false);
        this.setIcon(Resources.ICON_SAVE);
        this.dataChanged();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                SaveAction.this.dataChanged();
            }
        });
    }

    private void dataChanged() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                if (data == null) {
                    SaveAction.this.setEnabled(false);
                } else {
                    SaveAction.this.setEnabled(data.hasChanged());
                    data.addObserver((Observer)SaveAction.this);
                }
            }
        });
    }

    public void performAction() {
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            return;
        }
        try {
            ds.store();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return NbBundle.getMessage(SaveAction.class, (String)"CTL_SaveAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void update(Observable observable, Object arguement) {
        this.dataChanged();
    }
}

