/*
 * Decompiled with CFR 0.152.
 */
package tr.extract.reports.pocketmod;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.openide.util.NbBundle;
import tr.extract.Extract;
import tr.extract.Param;
import tr.extract.ParamBoolean;
import tr.extract.ParamFont;
import tr.extract.ParamList;
import tr.extract.ParamsDialog;
import tr.model.Data;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportImpl
extends Extract {
    public String getID() {
        return "pocketmod";
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ReportAction");
    }

    public List<Param> getParams() {
        Vector<Param.Item> pageItems = new Vector<Param.Item>(14);
        pageItems.add(new Param.Item(this.getString("page-blank"), "blank"));
        pageItems.add(new Param.Item(this.getString("page-doasap-1"), "doasap-1"));
        pageItems.add(new Param.Item(this.getString("page-doasap-2"), "doasap-2"));
        pageItems.add(new Param.Item(this.getString("page-doasap-3"), "doasap-3"));
        pageItems.add(new Param.Item(this.getString("page-thoughts"), "new-thoughts"));
        pageItems.add(new Param.Item(this.getString("page-overdue-1"), "overdue-1"));
        pageItems.add(new Param.Item(this.getString("page-overdue-2"), "overdue-2"));
        pageItems.add(new Param.Item(this.getString("page-overdue-3"), "overdue-3"));
        pageItems.add(new Param.Item(this.getString("page-this-week-1"), "this-week-1"));
        pageItems.add(new Param.Item(this.getString("page-this-week-2"), "this-week-2"));
        pageItems.add(new Param.Item(this.getString("page-this-week-3"), "this-week-3"));
        pageItems.add(new Param.Item(this.getString("page-today-1"), "today-1"));
        pageItems.add(new Param.Item(this.getString("page-today-2"), "today-2"));
        pageItems.add(new Param.Item(this.getString("page-today-3"), "today-3"));
        Vector<Param> params = new Vector<Param>(11);
        params.add((Param)new ParamList("page-1", this.getString("param-page-1"), pageItems));
        params.add((Param)new ParamList("page-2", this.getString("param-page-2"), pageItems));
        params.add((Param)new ParamList("page-3", this.getString("param-page-3"), pageItems));
        params.add((Param)new ParamList("page-4", this.getString("param-page-4"), pageItems));
        params.add((Param)new ParamList("page-5", this.getString("param-page-5"), pageItems));
        params.add((Param)new ParamList("page-6", this.getString("param-page-6"), pageItems));
        params.add((Param)new ParamList("page-7", this.getString("param-page-7"), pageItems));
        params.add((Param)new ParamList("page-8", this.getString("param-page-8"), pageItems));
        params.add((Param)new ParamBoolean("show-project", this.getString("param-show-project-thought")));
        params.add((Param)new ParamBoolean("colour", this.getString("param-use-colour")));
        params.add((Param)new ParamFont("font", this.getString("param-font")));
        return params;
    }

    public void process(Data data) throws Exception {
        String title = this.getDialogTitleReport(this.getName());
        List<Param> params = this.getParams();
        ParamsDialog dlg = new ParamsDialog(title, this.getID(), params);
        if (dlg.showDialog() == 2) {
            return;
        }
        String timestamp = this.getTimeStamp();
        File extfile = this.getTmpFile("data.xml");
        File xmlfile = this.getOutFile("pocketmod-" + timestamp + ".xml");
        File outfile = this.getOutFile("pocketmod-" + timestamp + ".pdf");
        URL xslURL = ((Object)((Object)this)).getClass().getResource("pocketmod.xsl");
        URL xfoURL = ((Object)((Object)this)).getClass().getResource("pocketmod.fo.xml");
        this.extractData(data, extfile);
        this.transformXSL(extfile, xslURL, params, xmlfile);
        this.transformXSLFO(xmlfile, xfoURL, params, outfile);
        this.openFile(outfile);
    }
}

