/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.LegacyHighlighter;
import org.jdesktop.swingx.decorator.UIDependent;

public class CompoundHighlighter
extends AbstractHighlighter
implements UIDependent,
LegacyHighlighter.UIHighlighter {
    public static final Highlighter[] EMPTY_HIGHLIGHTERS = new Highlighter[0];
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();
    private ChangeListener highlighterChangeListener;

    public CompoundHighlighter(Highlighter ... inList) {
        for (int i = 0; i < inList.length; ++i) {
            this.addHighlighter(inList[i]);
        }
    }

    public void addHighlighter(Highlighter highlighter) {
        this.addHighlighter(highlighter, false);
    }

    public void addHighlighter(Highlighter highlighter, boolean prepend) {
        if (prepend) {
            this.highlighters.add(0, highlighter);
        } else {
            this.highlighters.add(this.highlighters.size(), highlighter);
        }
        this.updateUI(highlighter);
        highlighter.addChangeListener(this.getHighlighterChangeListener());
        this.fireStateChanged();
    }

    public void removeHighlighter(Highlighter hl) {
        boolean success = this.highlighters.remove(hl);
        if (success) {
            hl.removeChangeListener(this.getHighlighterChangeListener());
            this.fireStateChanged();
        }
    }

    public Highlighter[] getHighlighters() {
        return this.highlighters.toArray(new Highlighter[this.highlighters.size()]);
    }

    public void updateUI() {
        for (Highlighter highlighter : this.highlighters) {
            this.updateUI(highlighter);
        }
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        this.highlighterChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CompoundHighlighter.this.fireStateChanged();
            }
        };
        return this.highlighterChangeListener;
    }

    private void updateUI(Highlighter hl) {
        if (hl instanceof UIDependent) {
            ((UIDependent)((Object)hl)).updateUI();
        } else if (hl instanceof LegacyHighlighter.UIHighlighter) {
            ((LegacyHighlighter.UIHighlighter)((Object)hl)).updateUI();
        }
    }

    public Component apply(Component stamp, ComponentAdapter adapter) {
        return this.highlight(stamp, adapter);
    }

    protected Component doHighlight(Component stamp, ComponentAdapter adapter) {
        Iterator<Highlighter> iter = this.highlighters.iterator();
        while (iter.hasNext()) {
            stamp = iter.next().highlight(stamp, adapter);
        }
        return stamp;
    }
}

