/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.RolloverController;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.RolloverRenderer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.DefaultSelectionMapper;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.renderer.DefaultListRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXList
extends JList {
    private static final Logger LOG = Logger.getLogger(JXList.class.getName());
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected FilterPipeline filters;
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    protected ComponentAdapter dataAdapter;
    private RolloverProducer rolloverProducer;
    private ListRolloverController linkController;
    private DelegatingRenderer delegatingRenderer;
    private WrappingListModel wrappingModel;
    private PipelineListener pipelineListener;
    private boolean filterEnabled;
    private SelectionMapper selectionMapper;
    private Searchable searchable;
    private Comparator comparator;

    public JXList() {
        this(false);
    }

    public JXList(ListModel dataModel) {
        this(dataModel, false);
    }

    public JXList(Object[] listData) {
        this(listData, false);
    }

    public JXList(Vector<?> listData) {
        this(listData, false);
    }

    public JXList(boolean filterEnabled) {
        this.init(filterEnabled);
    }

    public JXList(ListModel dataModel, boolean filterEnabled) {
        super(dataModel);
        this.init(filterEnabled);
    }

    public JXList(Object[] listData, boolean filterEnabled) {
        super(listData);
        if (listData == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(filterEnabled);
    }

    public JXList(Vector<?> listData, boolean filterEnabled) {
        super(listData);
        if (listData == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(filterEnabled);
    }

    private void init(boolean filterEnabled) {
        this.setFilterEnabled(filterEnabled);
        Action findAction = this.createFindAction();
        this.getActionMap().put("find", findAction);
        KeyStroke findStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createFindAction() {
        return new UIAction("find"){

            public void actionPerformed(ActionEvent e) {
                JXList.this.doFind();
            }
        };
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new ListSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    protected ListRolloverController getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected ListRolloverController createLinkController() {
        return new ListRolloverController();
    }

    protected RolloverProducer createRolloverProducer() {
        return new RolloverProducer(){

            protected void updateRolloverPoint(JComponent component, Point mousePoint) {
                int col;
                Rectangle cellBounds;
                JList list = (JList)component;
                int row = list.locationToIndex(mousePoint);
                if (row >= 0 && !(cellBounds = list.getCellBounds(row, row)).contains(mousePoint)) {
                    row = -1;
                }
                this.rollover.x = col = row < 0 ? -1 : 0;
                this.rollover.y = row;
            }
        };
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    public void resetSortOrder() {
        SortController controller = this.getSortController();
        if (controller != null) {
            controller.setSortKeys(null);
        }
    }

    public void toggleSortOrder() {
        SortController controller = this.getSortController();
        if (controller != null) {
            controller.toggleSortOrder(0, this.getComparator());
        }
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (sortOrder == null || !sortOrder.isSorted()) {
            this.resetSortOrder();
            return;
        }
        SortController sortController = this.getSortController();
        if (sortController != null) {
            SortKey sortKey = new SortKey(sortOrder, 0, this.getComparator());
            sortController.setSortKeys(Collections.singletonList(sortKey));
        }
    }

    public SortOrder getSortOrder() {
        SortController sortController = this.getSortController();
        if (sortController == null) {
            return SortOrder.UNSORTED;
        }
        SortKey sortKey = SortKey.getFirstSortKeyForColumn(sortController.getSortKeys(), 0);
        return sortKey != null ? sortKey.getSortOrder() : SortOrder.UNSORTED;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        Comparator old = this.getComparator();
        this.comparator = comparator;
        this.updateSortAfterComparatorChange();
        this.firePropertyChange("comparator", old, this.getComparator());
    }

    protected void updateSortAfterComparatorChange() {
        this.setSortOrder(this.getSortOrder());
    }

    protected SortController getSortController() {
        if (!this.isFilterEnabled()) {
            return null;
        }
        return this.getFilters().getSortController();
    }

    public Object getElementAt(int viewIndex) {
        return this.getModel().getElementAt(viewIndex);
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public int convertIndexToModel(int viewIndex) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToModel(viewIndex) : viewIndex;
    }

    public int convertIndexToView(int modelIndex) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToView(modelIndex) : modelIndex;
    }

    public ListModel getWrappedModel() {
        return this.isFilterEnabled() ? this.wrappingModel.getModel() : this.getModel();
    }

    public void setFilterEnabled(boolean enabled) {
        boolean old = this.isFilterEnabled();
        if (old == enabled) {
            return;
        }
        if (old) {
            throw new IllegalStateException("must not reset filterEnabled");
        }
        this.filterEnabled = enabled;
        this.wrappingModel = new WrappingListModel(this.getModel());
        super.setModel(this.wrappingModel);
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        super.setSelectionModel(newModel);
        this.getSelectionMapper().setViewSelectionModel(this.getSelectionModel());
    }

    public void setModel(ListModel model) {
        if (this.isFilterEnabled()) {
            this.wrappingModel.setModel(model);
        } else {
            super.setModel(model);
        }
    }

    protected SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = new DefaultSelectionMapper(this.filters, this.getSelectionModel());
        }
        return this.selectionMapper;
    }

    public FilterPipeline getFilters() {
        if (this.filters == null && this.isFilterEnabled()) {
            this.setFilters(null);
        }
        return this.filters;
    }

    public void setFilters(FilterPipeline pipeline) {
        if (!this.isFilterEnabled()) {
            throw new IllegalStateException("filters not enabled - not allowed to set filters");
        }
        FilterPipeline old = this.filters;
        List<? extends SortKey> sortKeys = null;
        if (old != null) {
            old.removePipelineListener(this.pipelineListener);
            sortKeys = old.getSortController().getSortKeys();
        }
        if (pipeline == null) {
            pipeline = new FilterPipeline();
        }
        this.filters = pipeline;
        this.filters.getSortController().setSortKeys(sortKeys);
        this.use(this.filters);
        this.getSelectionMapper().setFilters(this.filters);
    }

    private void use(FilterPipeline pipeline) {
        if (pipeline != null) {
            if (this.initialUse(pipeline)) {
                pipeline.addPipelineListener(this.getFilterPipelineListener());
                pipeline.assign(this.getComponentAdapter());
            } else {
                pipeline.flush();
            }
        }
    }

    private boolean initialUse(FilterPipeline pipeline) {
        if (this.pipelineListener == null) {
            return true;
        }
        PipelineListener[] l = pipeline.getPipelineListeners();
        for (int i = 0; i < l.length; ++i) {
            if (!this.pipelineListener.equals(l[i])) continue;
            return false;
        }
        return true;
    }

    protected PipelineListener getFilterPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = this.createPipelineListener();
        }
        return this.pipelineListener;
    }

    protected PipelineListener createPipelineListener() {
        return new PipelineListener(){

            public void contentsChanged(PipelineEvent e) {
                JXList.this.updateOnFilterContentChanged();
            }
        };
    }

    protected void updateOnFilterContentChanged() {
        if (this.wrappingModel != null) {
            this.wrappingModel.updateOnFilterContentChanged();
        }
        this.revalidate();
        this.repaint();
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new ListAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int index) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.column = 0;
        adapter.row = index;
        return adapter;
    }

    private CompoundHighlighter getCompoundHighlighter() {
        return this.compoundHighlighter;
    }

    private void setCompoundHighlighter(CompoundHighlighter pipeline) {
        CompoundHighlighter old = this.getCompoundHighlighter();
        if (old != null) {
            old.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.compoundHighlighter = pipeline;
        if (this.compoundHighlighter != null) {
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", old, this.getCompoundHighlighter());
    }

    public void setHighlighters(Highlighter ... highlighters) {
        CompoundHighlighter pipeline = null;
        if (highlighters != null && highlighters.length > 0 && highlighters[0] != null) {
            pipeline = new CompoundHighlighter(highlighters);
        }
        this.setCompoundHighlighter(pipeline);
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter() != null ? this.getCompoundHighlighter().getHighlighters() : CompoundHighlighter.EMPTY_HIGHLIGHTERS;
    }

    public void addHighlighter(Highlighter highlighter) {
        CompoundHighlighter pipeline = this.getCompoundHighlighter();
        if (pipeline == null) {
            this.setCompoundHighlighter(new CompoundHighlighter(highlighter));
        } else {
            pipeline.addHighlighter(highlighter);
        }
    }

    public void removeHighlighter(Highlighter highlighter) {
        if (this.getCompoundHighlighter() == null) {
            return;
        }
        this.getCompoundHighlighter().removeHighlighter(highlighter);
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JXList.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer(this.createDefaultCellRenderer());
        }
        return this.delegatingRenderer;
    }

    protected ListCellRenderer createDefaultCellRenderer() {
        return new DefaultListRenderer();
    }

    public ListCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateRendererUI();
    }

    private void updateRendererUI() {
        if (this.delegatingRenderer != null) {
            this.delegatingRenderer.updateUI();
        } else {
            ListCellRenderer renderer = this.getCellRenderer();
            if (renderer instanceof JComponent) {
                ((JComponent)((Object)renderer)).updateUI();
            }
        }
    }

    public class DelegatingRenderer
    implements ListCellRenderer,
    RolloverRenderer {
        private ListCellRenderer delegateRenderer;

        public DelegatingRenderer(ListCellRenderer delegate) {
            this.setDelegateRenderer(delegate);
        }

        public void setDelegateRenderer(ListCellRenderer delegate) {
            if (delegate == null) {
                delegate = new DefaultListCellRenderer();
            }
            this.delegateRenderer = delegate;
        }

        public ListCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        public boolean isEnabled() {
            return this.delegateRenderer instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegateRenderer)).isEnabled();
        }

        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegateRenderer)).doClick();
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.delegateRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (JXList.this.compoundHighlighter != null && index >= 0 && index < JXList.this.getElementCount()) {
                comp = JXList.this.compoundHighlighter.highlight(comp, JXList.this.getComponentAdapter(index));
            }
            return comp;
        }

        public void updateUI() {
            this.updateRendererUI(this.delegateRenderer);
        }

        private void updateRendererUI(ListCellRenderer renderer) {
            Component comp;
            if (renderer instanceof JComponent) {
                ((JComponent)((Object)renderer)).updateUI();
            } else if (renderer != null && (comp = renderer.getListCellRendererComponent(JXList.this, null, -1, false, false)) instanceof JComponent) {
                ((JComponent)comp).updateUI();
            }
        }
    }

    protected static class ListAdapter
    extends ComponentAdapter {
        private final JXList list;

        public ListAdapter(JXList component) {
            super(component);
            this.list = component;
        }

        public JXList getList() {
            return this.list;
        }

        public boolean hasFocus() {
            return this.list.isFocusOwner() && this.row == this.list.getLeadSelectionIndex();
        }

        public int getRowCount() {
            return this.list.getWrappedModel().getSize();
        }

        public Object getValue() {
            return this.list.getElementAt(this.row);
        }

        public Object getValueAt(int row, int column) {
            return this.list.getWrappedModel().getElementAt(row);
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.list.getElementAt(row);
        }

        public void setValueAt(Object aValue, int row, int column) {
            throw new UnsupportedOperationException("Method getFilteredValueAt() not yet implemented.");
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean isSelected() {
            return this.list.isSelectedIndex(this.row);
        }

        public String getColumnName(int columnIndex) {
            return "Column_" + columnIndex;
        }

        public String getColumnIdentifier(int columnIndex) {
            return null;
        }
    }

    private class WrappingListModel
    extends AbstractListModel {
        private ListModel delegate;
        private ListDataListener listDataListener;

        public WrappingListModel(ListModel model) {
            this.setModel(model);
        }

        public void updateOnFilterContentChanged() {
            this.fireContentsChanged(this, -1, -1);
        }

        public void setModel(ListModel model) {
            ListModel old = this.getModel();
            if (old != null) {
                old.removeListDataListener(this.listDataListener);
            }
            this.delegate = model;
            this.delegate.addListDataListener(this.getListDataListener());
            this.fireContentsChanged(this, -1, -1);
            JXList.this.getSelectionMapper().clearModelSelection();
            JXList.this.getFilters().flush();
        }

        private ListDataListener getListDataListener() {
            if (this.listDataListener == null) {
                this.listDataListener = this.createListDataListener();
            }
            return this.listDataListener;
        }

        private ListDataListener createListDataListener() {
            return new ListDataListener(){

                public void intervalAdded(ListDataEvent e) {
                    this.contentsChanged(e);
                }

                public void intervalRemoved(ListDataEvent e) {
                    this.contentsChanged(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void contentsChanged(ListDataEvent e) {
                    boolean wasEnabled = JXList.this.getSelectionMapper().isEnabled();
                    JXList.this.getSelectionMapper().setEnabled(false);
                    try {
                        WrappingListModel.this.fireContentsChanged(this, -1, -1);
                        WrappingListModel.this.updateSelection(e);
                    }
                    finally {
                        JXList.this.getSelectionMapper().setEnabled(wasEnabled);
                    }
                    JXList.this.getFilters().flush();
                }
            };
        }

        protected void updateSelection(ListDataEvent e) {
            if (e.getType() == 2) {
                JXList.this.getSelectionMapper().removeIndexInterval(e.getIndex0(), e.getIndex1());
            } else if (e.getType() == 1) {
                int minIndex = Math.min(e.getIndex0(), e.getIndex1());
                int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
                int length = maxIndex - minIndex + 1;
                JXList.this.getSelectionMapper().insertIndexInterval(minIndex, length, true);
            } else {
                JXList.this.getSelectionMapper().clearModelSelection();
            }
        }

        public ListModel getModel() {
            return this.delegate;
        }

        public int getSize() {
            return JXList.this.getFilters().getOutputSize();
        }

        public Object getElementAt(int index) {
            return JXList.this.getFilters().getValueAt(index, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListRolloverController<T extends JList>
    extends RolloverController<T> {
        private Cursor oldCursor;

        @Override
        protected void rollover(Point oldLocation, Point newLocation) {
            Rectangle r;
            if (oldLocation != null && (r = ((JList)this.component).getCellBounds(oldLocation.y, oldLocation.y)) != null) {
                ((JList)this.component).repaint(r);
            }
            if (newLocation != null && (r = ((JList)this.component).getCellBounds(newLocation.y, newLocation.y)) != null) {
                ((JList)this.component).repaint(r);
            }
            this.setRolloverCursor(newLocation);
        }

        private void setRolloverCursor(Point location) {
            if (this.hasRollover(location)) {
                if (this.oldCursor == null) {
                    this.oldCursor = ((JList)this.component).getCursor();
                    ((JList)this.component).setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.oldCursor != null) {
                ((JList)this.component).setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }

        @Override
        protected RolloverRenderer getRolloverRenderer(Point location, boolean prepare) {
            RolloverRenderer rollover;
            ListCellRenderer renderer = ((JList)this.component).getCellRenderer();
            RolloverRenderer rolloverRenderer = rollover = renderer instanceof RolloverRenderer ? (RolloverRenderer)((Object)renderer) : null;
            if (rollover != null && !rollover.isEnabled()) {
                rollover = null;
            }
            if (rollover != null && prepare) {
                Object element = ((JList)this.component).getModel().getElementAt(location.y);
                renderer.getListCellRendererComponent((JList)this.component, element, location.y, false, true);
            }
            return rollover;
        }

        @Override
        protected Point getFocusedCell() {
            int leadRow = ((JList)this.component).getLeadSelectionIndex();
            if (leadRow < 0) {
                return null;
            }
            return new Point(0, leadRow);
        }
    }

    public class ListSearchable
    extends AbstractSearchable {
        protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
            AbstractSearchable.SearchResult searchResult = null;
            if (backwards) {
                for (int index = startRow; index >= 0 && searchResult == null; --index) {
                    searchResult = this.findMatchAt(pattern, index);
                }
            } else {
                for (int index = startRow; index < this.getSize() && searchResult == null; ++index) {
                    searchResult = this.findMatchAt(pattern, index);
                }
            }
            this.updateState(searchResult);
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
            return this.findMatchAt(pattern, row);
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row) {
            Matcher matcher;
            Object value = JXList.this.getElementAt(row);
            if (value != null && (matcher = pattern.matcher(value.toString())).find()) {
                return this.createSearchResult(matcher, row, -1);
            }
            return null;
        }

        protected int getSize() {
            return JXList.this.getElementCount();
        }

        protected void moveMatchMarker() {
            JXList.this.setSelectedIndex(this.lastSearchResult.foundRow);
            if (this.lastSearchResult.foundRow >= 0) {
                JXList.this.ensureIndexIsVisible(this.lastSearchResult.foundRow);
            }
        }
    }
}

