/*
 * Decompiled with CFR 0.152.
 */
package tr.datastore.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import tr.model.Data;
import tr.model.action.Action;
import tr.model.action.ActionStateASAP;
import tr.model.action.ActionStateDelegated;
import tr.model.action.ActionStateInactive;
import tr.model.action.ActionStateScheduled;
import tr.model.context.Context;
import tr.model.criteria.Criterion;
import tr.model.criteria.Value;
import tr.model.future.Future;
import tr.model.information.Information;
import tr.model.project.Project;
import tr.model.project.ProjectProjects;
import tr.model.project.ProjectSingleActions;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.util.Manager;

public final class XStreamWrapper {
    private static final Object[][] aliases = new Object[][]{{"data", Data.class}, {"action", Action.class}, {"actionStateASAP", ActionStateASAP.class}, {"actionStateScheduled", ActionStateScheduled.class}, {"actionStateDelegated", ActionStateDelegated.class}, {"actionStateInactive", ActionStateInactive.class}, {"topic", Topic.class}, {"context", Context.class}, {"project", Project.class}, {"projects", ProjectProjects.class}, {"actions", ProjectSingleActions.class}, {"info", Information.class}, {"future", Future.class}, {"thought", Thought.class}, {"list", Manager.class}, {"criterion", Criterion.class}, {"value", Value.class}};
    private static XStreamWrapper instance;
    private final XStream xstream = new XStream();

    private XStreamWrapper() {
        for (int i = 0; i < aliases.length; ++i) {
            this.xstream.alias((String)aliases[i][0], (Class)aliases[i][1]);
        }
    }

    public static XStreamWrapper instance() {
        if (instance == null) {
            instance = new XStreamWrapper();
        }
        return instance;
    }

    public Data load(File file) throws Exception {
        System.out.println("Loading data started... ");
        Reader fr = this.getReader(file);
        Data data = (Data)this.xstream.unmarshal((HierarchicalStreamReader)new XppReader(fr));
        if (data.getVersion() == 0) {
            fr.close();
            fr = new FileReader(file);
            data = (Data)this.xstream.unmarshal((HierarchicalStreamReader)new XppReader(fr));
        }
        fr.close();
        data.checkVersion();
        System.out.println("Loading data finished.");
        return data;
    }

    public synchronized void store(Data data, File file) throws Exception {
        System.out.println("Storing data started... ");
        Writer fw = this.getWriter(file);
        this.xstream.marshal((Object)data, (HierarchicalStreamWriter)new CompactWriter(fw));
        fw.close();
        System.out.println("Storing data finished.");
    }

    private Reader getReader(File file) throws Exception {
        return new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
    }

    private Writer getWriter(File file) throws Exception {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
    }
}

