/*
 * Decompiled with CFR 0.152.
 */
package tr.view.context;

import java.awt.BorderLayout;
import java.io.Serializable;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.view.Window;
import tr.view.context.ContextsPanel;
import tr.view.context.Resources;

public final class ContextsTopComponent
extends Window {
    private static ContextsTopComponent instance;
    public static final String PREFERRED_ID = "ContextsTopComponent";
    private transient ContextsPanel panel;
    private transient Lookup lookup;
    private transient Lookup.Result result;

    private ContextsTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ContextsTopComponent.class, (String)"CTL_ContextsTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ContextsTopComponent.class, (String)"HINT_ContextsTopComponent"));
        this.setIcon(Resources.ICON_CONTEXT.getImage());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized ContextsTopComponent getDefault() {
        if (instance == null) {
            instance = new ContextsTopComponent();
        }
        return instance;
    }

    public static synchronized ContextsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find Contexts component. It will not be located properly in the window system.");
            return ContextsTopComponent.getDefault();
        }
        if (win instanceof ContextsTopComponent) {
            return (ContextsTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ContextsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ContextsTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (this.panel == null) {
            this.removeAll();
            this.panel = new ContextsPanel();
            this.add(this.panel, "Center");
            super.revalidate();
            super.repaint();
        }
        if (this.result == null) {
            this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
            this.result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ContextsTopComponent.this.removeAll();
                    ContextsTopComponent.this.panel = null;
                }
            });
        }
    }

    public void componentClosed() {
        if (this.panel != null) {
            this.panel.deactivate();
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    public void refresh() {
    }

    public Lookup getLookup() {
        if (this.panel == null) {
            return super.getLookup();
        }
        if (this.lookup == null) {
            this.lookup = Lookups.singleton((Object)this.panel);
        }
        return this.lookup;
    }

    public void deactivate() {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("tr.view.contexts");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ContextsTopComponent.getDefault();
        }
    }
}

