/*
 * Decompiled with CFR 0.152.
 */
package tr.view.context;

import java.awt.Color;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import tr.model.context.Context;
import tr.model.util.Manager;
import tr.swing.StyledString;
import tr.swing.StyledStringEditor;
import tr.swing.StyledStringRenderer;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.context.Resources;

public class ContextsTableModel
extends AbstractTableModel
implements Observer {
    public static final String[] HEADINGS = new String[]{"", " Name", " Description"};
    public static final Class[] CLASSES = new Class[]{Icon.class, StyledString.class, StyledString.class};
    public static final TableCellRenderer[] RENDERERS = new TableCellRenderer[]{null, new StyledStringRenderer(), new StyledStringRenderer()};
    public static final TableCellEditor[] EDITORS = new TableCellEditor[]{null, new StyledStringEditor(), new StyledStringEditor()};
    public static final int[] MAX_WIDTHS = new int[]{17, 800, -1};
    public static final int[] MIN_WIDTHS = new int[]{17, -1, -1};
    public static final int[] PREF_WIDTHS = new int[]{17, 300, -1};
    private final Manager contextManager;
    private List contexts;

    public ContextsTableModel(Manager contextManager) {
        this.contextManager = contextManager;
        this.contextManager.addObserver((Observer)this);
        this.initModel();
    }

    private void initModel() {
        this.contexts = this.contextManager.list();
    }

    public int getColumnCount() {
        return CLASSES.length;
    }

    public Class getColumnClass(int column) {
        return CLASSES[column];
    }

    public String getColumnName(int column) {
        return HEADINGS[column];
    }

    public int getRowCount() {
        return this.contexts.size();
    }

    public Context getValueAt(int row) {
        return (Context)this.contexts.get(row);
    }

    public Object getValueAt(int row, int column) {
        StyledString ss = new StyledString();
        switch (column) {
            case 0: {
                return Resources.ICON_CONTEXT;
            }
            case 1: {
                ss.setString(((Context)this.contexts.get(row)).getName());
                ss.setForeground(Color.black);
                ss.setBackground(Color.white);
                return ss;
            }
            case 2: {
                ss.setString(((Context)this.contexts.get(row)).getDescription());
                ss.setForeground(Color.black);
                ss.setBackground(Color.white);
                return ss;
            }
        }
        return "";
    }

    public boolean isCellEditable(int row, int column) {
        return row > 0 && column > 0;
    }

    public void setValueAt(Object value, int row, int column) {
        if (row > this.contexts.size() - 1) {
            return;
        }
        switch (column) {
            case 0: {
                break;
            }
            case 1: {
                ((Context)this.contexts.get(row)).setName(((StyledString)value).getString());
                break;
            }
            case 2: {
                ((Context)this.contexts.get(row)).setDescription(((StyledString)value).getString());
            }
        }
    }

    public void update(Observable o, Object arg) {
        this.initModel();
        this.fireTableDataChanged();
    }
}

