/*
 * Decompiled with CFR 0.152.
 */
package tr.view.context;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import tr.global.Constants;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.context.Context;
import tr.model.context.ContextUtils;
import tr.model.util.Manager;
import tr.prefs.gui.GUIPrefs;
import tr.util.Observable;
import tr.view.Add;
import tr.view.Delete;
import tr.view.Resources;
import tr.view.context.ContextsComboBox;
import tr.view.context.ContextsComboBoxModel;
import tr.view.context.ContextsTableModel;

public class ContextsPanel
extends JPanel
implements Add,
Delete {
    private static final String HEADING = "Contexts";
    private final Data data = (Data)DataLookup.instance().lookup(Data.class);
    private final Manager<Context> manager = this.data.getContextManager();
    private ContextsTableModel tableModel = new ContextsTableModel(this.manager);
    private JPanel buttonsPanel;
    private JButton addButton;
    private JButton deleteButton;
    private JPanel bodyPanel;
    private JTable table;
    private JTableHeader tableHeader;
    private JScrollPane tableScrollPane;

    public ContextsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.initButtonsPanel();
        this.initTable();
        this.initBodyPanel();
        this.initFrame();
    }

    private void initButtonsPanel() {
        this.addButton = new JButton(Constants.STRING_PLUS);
        this.addButton.setToolTipText(Resources.ADD_TOOLTIP);
        this.addButton.setIcon(tr.view.context.Resources.ICON_CONTEXT);
        this.addButton.putClientProperty("JButton.buttonType", "icon");
        this.addButton.setPreferredSize(Constants.BUTTON_SIZE_BIG);
        this.addButton.setEnabled(true);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContextsPanel.this.add();
            }
        });
        this.deleteButton = new JButton(Constants.STRING_MINUS);
        this.deleteButton.setToolTipText(Resources.DELETE_TOOLTIP);
        this.deleteButton.setIcon(tr.view.context.Resources.ICON_CONTEXT);
        this.deleteButton.putClientProperty("JButton.buttonType", "icon");
        this.deleteButton.setPreferredSize(Constants.BUTTON_SIZE_BIG);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ContextsPanel.this.delete();
            }
        });
        this.buttonsPanel = new JPanel(new FlowLayout(0, 2, 2));
        this.buttonsPanel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.buttonsPanel.add(this.addButton);
        this.buttonsPanel.add(this.deleteButton);
    }

    private void initTable() {
        JXTable jxtable = new JXTable((TableModel)this.tableModel);
        jxtable.setColumnControlVisible(false);
        jxtable.setSortable(false);
        this.table = jxtable;
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setEnabled(true);
        this.table.setFocusable(true);
        this.table.setShowGrid(false);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    if (ContextsPanel.this.table.isEditing()) {
                        e.consume();
                        ContextsPanel.this.stopEditing();
                    } else if (ContextsPanel.this.isLastRowSelected()) {
                        e.consume();
                        ContextsPanel.this.add();
                    }
                } else if (e.getKeyCode() == 9) {
                    if (!e.isShiftDown() && ContextsPanel.this.isLastRowSelected() && ContextsPanel.this.isLastColumnSelected()) {
                        e.consume();
                        ContextsPanel.this.add();
                    }
                } else if (e.getKeyCode() == 10) {
                    e.consume();
                    if (ContextsPanel.this.table.isEditing()) {
                        ContextsPanel.this.stopEditing();
                    } else {
                        int row = ContextsPanel.this.table.getSelectedRow();
                        int last = ContextsPanel.this.table.getRowCount() - 1;
                        if (row > -1 && row < last) {
                            int column = ContextsPanel.this.table.getSelectedColumn();
                            ContextsPanel.this.table.changeSelection(row + 1, column, false, false);
                        } else {
                            ContextsPanel.this.add();
                        }
                    }
                } else if (e.getKeyCode() == 127) {
                    e.consume();
                    ContextsPanel.this.delete();
                }
            }
        });
        this.table.setSelectionMode(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ContextsPanel.this.enableModifyAndDeleteButtons();
                if (ContextsPanel.this.table.getSelectedColumn() == 0) {
                    ContextsPanel.this.table.setColumnSelectionInterval(1, 1);
                }
            }
        });
        TableCellRenderer tcr = this.table.getTableHeader().getDefaultRenderer();
        if (tcr instanceof DefaultTableCellRenderer) {
            DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)tcr;
            dtcr.setHorizontalAlignment(2);
        }
        this.tableHeader = this.table.getTableHeader();
        this.tableHeader.setResizingAllowed(true);
        for (int i = 0; i < ContextsTableModel.CLASSES.length; ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            if (ContextsTableModel.RENDERERS[i] != null) {
                tc.setCellRenderer(ContextsTableModel.RENDERERS[i]);
            }
            if (ContextsTableModel.EDITORS[i] != null) {
                tc.setCellEditor(ContextsTableModel.EDITORS[i]);
            }
            if (ContextsTableModel.MAX_WIDTHS[i] > -1) {
                tc.setMaxWidth(ContextsTableModel.MAX_WIDTHS[i]);
            }
            if (ContextsTableModel.MIN_WIDTHS[i] > -1) {
                tc.setMinWidth(ContextsTableModel.MIN_WIDTHS[i]);
            }
            if (ContextsTableModel.PREF_WIDTHS[i] <= -1) continue;
            tc.setPreferredWidth(ContextsTableModel.PREF_WIDTHS[i]);
        }
        this.tableScrollPane = new JScrollPane(this.table);
    }

    private void stopEditing() {
        if (!this.table.isEditing()) {
            return;
        }
        int row = this.table.getEditingRow();
        int column = this.table.getEditingColumn();
        this.table.getCellEditor().stopCellEditing();
        if (Utilities.isWindows()) {
            this.table.changeSelection(row, column, false, false);
        }
    }

    private void enableModifyAndDeleteButtons() {
        boolean b = false;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow > -1 && !this.tableModel.getValueAt(selectedRow).equals((Object)Context.getDefault())) {
            b = true;
        }
        this.deleteButton.setEnabled(b);
        this.addButton.setEnabled(this.canAdd());
    }

    public void focus() {
        this.table.requestFocusInWindow();
    }

    private void initBodyPanel() {
        this.bodyPanel = new JPanel();
        this.bodyPanel.setLayout(new BorderLayout());
        this.bodyPanel.add((Component)this.tableScrollPane, "Center");
        if (GUIPrefs.getButtonsPosition().equals("top")) {
            this.bodyPanel.add((Component)this.buttonsPanel, "North");
        } else {
            this.bodyPanel.add((Component)this.buttonsPanel, "South");
        }
    }

    private void initFrame() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(new Insets(2, 2, 2, 2)));
        this.add((Component)this.bodyPanel, "Center");
    }

    private boolean isLastColumnSelected() {
        int last = this.table.getColumnCount() - 1;
        return this.table.getSelectedColumn() == last || this.table.getEditingColumn() == last;
    }

    private boolean isLastRowSelected() {
        return this.table.isRowSelected(this.table.getRowCount() - 1);
    }

    private boolean canAdd() {
        if (this.table.getRowCount() < 1) {
            return true;
        }
        Context context = this.tableModel.getValueAt(this.table.getRowCount() - 1);
        return !context.getName().trim().equals("");
    }

    public void add() {
        this.stopEditing();
        if (this.canAdd()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ContextsPanel.this.table.requestFocus();
                    ContextsPanel.this.manager.add((Observable)new Context());
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    int row = ContextsPanel.this.table.getRowCount() - 1;
                    int col = 1;
                    ContextsPanel.this.table.changeSelection(row, col, false, false);
                    ContextsPanel.this.table.requestFocus();
                    ContextsPanel.this.table.editCellAt(row, col);
                }
            });
        }
    }

    public void delete() {
        this.stopEditing();
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        Context context = this.tableModel.getValueAt(selectedRow);
        if (ContextUtils.instance().isUsed(this.data, context)) {
            ContextsComboBox ccb = new ContextsComboBox((ComboBoxModel)new ContextsComboBoxModel(false));
            ccb.setSelectedIndex(0);
            JPanel panel = new JPanel();
            panel.add(new JLabel(NbBundle.getMessage(this.getClass(), (String)"MSG_ReplaceContext")));
            panel.add(ccb);
            String title = "Delete Context: " + context.getName();
            int r = JOptionPane.showConfirmDialog(null, panel, title, 2);
            if (r == 2) {
                return;
            }
            Context replacement = (Context)ccb.getSelectedItem();
            if (!ContextUtils.instance().replace(this.data, context, replacement)) {
                String msg = "Can not replace context: " + context.getName() + "\n" + " with context: " + replacement.getName() + "\n\n";
                JOptionPane.showMessageDialog(this, msg);
                return;
            }
        }
        this.manager.remove((Observable)context);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        int rowCount = this.table.getRowCount();
        if (selectedRow < rowCount) {
            this.table.changeSelection(selectedRow, 1, false, false);
            this.table.requestFocus();
        } else if (rowCount > 0) {
            this.table.changeSelection(rowCount - 1, 1, false, false);
            this.table.requestFocus();
        }
    }

    public void deactivate() {
        this.stopEditing();
        Manager manager = this.data.getContextManager();
        for (Context context : manager.list()) {
            if (context.getName().trim().length() != 0 || ContextUtils.instance().isUsed(this.data, context)) continue;
            manager.remove((Observable)context);
        }
    }
}

