/*
 * Decompiled with CFR 0.152.
 */
package tr.background.recurrence;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.action.ActionState;
import tr.model.action.ActionStateScheduled;
import tr.model.action.Recurrence;
import tr.model.project.Project;

final class RecurrenceTaskThread
extends Thread {
    private static final Logger LOG = Logger.getLogger("tr.recurrence");
    private Data data;
    private List<Integer> done;

    public void run() {
        LOG.info("Started.");
        this.process();
        LOG.info("Finished.");
    }

    private Data getData() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            LOG.severe("Data instance could not be obtained.");
        }
        return data;
    }

    private void process() {
        this.data = this.getData();
        if (this.data == null) {
            return;
        }
        this.done = new Vector<Integer>();
        Iterator i = this.data.getRootActions().iterator(Action.class);
        while (i.hasNext()) {
            this.process((Action)i.next());
        }
        i = this.data.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            this.process((Project)i.next());
        }
    }

    private void process(Project project) {
        Iterator i = project.iterator(Project.class);
        while (i.hasNext()) {
            this.process((Project)i.next());
        }
        i = project.iterator(Action.class);
        while (i.hasNext()) {
            this.process((Action)i.next());
        }
    }

    private void process(Action action) {
        ActionState state = action.getState();
        if (!(state instanceof ActionStateScheduled)) {
            return;
        }
        Recurrence recurrence = ((ActionStateScheduled)state).getRecurrence();
        if (recurrence == null) {
            return;
        }
        if (recurrence.getBasis() != Recurrence.Basis.START_DATE) {
            return;
        }
        if (this.done.contains(recurrence.getID())) {
            return;
        }
        recurrence.generateOccurrencesFromGenToDate();
        this.done.add(recurrence.getID());
    }
}

