/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.netbeans.modules.options.OptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public class OptionsWindowAction
extends AbstractAction {
    private static Dialog dialog;
    private static WeakReference optionsDialogDescriptor;
    private static ErrorManager log;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public OptionsWindowAction() {
        this.putValue("Name", OptionsWindowAction.loc("CTL_Options_Window_Action"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (dialog != null) {
            dialog.setVisible(true);
            dialog.toFront();
            log.log("Front Options Dialog");
            return;
        }
        DialogDescriptor dialogDescriptor = (DialogDescriptor)optionsDialogDescriptor.get();
        OptionsPanel optionsPanel = null;
        if (dialogDescriptor == null) {
            Object[] objectArray;
            JButton jButton = (JButton)OptionsWindowAction.loc(new JButton(), "CTL_Classic");
            JButton jButton2 = (JButton)OptionsWindowAction.loc(new JButton(), "CTL_OK");
            optionsPanel = new OptionsPanel();
            String string = OptionsWindowAction.loc("CTL_Options_Dialog_Title");
            if (Utilities.getOperatingSystem() == 4096) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = DialogDescriptor.CANCEL_OPTION;
                objectArray = objectArray2;
                objectArray2[1] = jButton2;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = jButton2;
                objectArray = objectArray3;
                objectArray3[1] = DialogDescriptor.CANCEL_OPTION;
            }
            dialogDescriptor = new DialogDescriptor((Object)optionsPanel, string, false, objectArray, DialogDescriptor.OK_OPTION, 0, null, null);
            dialogDescriptor.setAdditionalOptions(new Object[]{jButton});
            dialogDescriptor.setHelpCtx(optionsPanel.getHelpCtx());
            OptionsPanelListener optionsPanelListener = new OptionsPanelListener(dialogDescriptor, optionsPanel, jButton2, jButton);
            dialogDescriptor.setButtonListener((ActionListener)optionsPanelListener);
            optionsPanel.addPropertyChangeListener(optionsPanelListener);
            optionsDialogDescriptor = new WeakReference<DialogDescriptor>(dialogDescriptor);
            log.log("Create new Options Dialog");
        } else {
            optionsPanel = (OptionsPanel)dialogDescriptor.getMessage();
            optionsPanel.update();
            log.log("Reopen Options Dialog");
        }
        dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        dialog.addWindowListener(new MyWindowListener(optionsPanel));
        dialogDescriptor = null;
    }

    private static String loc(String string) {
        return NbBundle.getMessage((Class)OptionsWindowAction.class, (String)string);
    }

    private static Component loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)OptionsWindowAction.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)OptionsWindowAction.loc(string));
        }
        return component;
    }

    static {
        optionsDialogDescriptor = new WeakReference<Object>(null);
        log = ErrorManager.getDefault().getInstance(OptionsWindowAction.class.getName());
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;

        MyWindowListener(OptionsPanel optionsPanel) {
            this.optionsPanel = optionsPanel;
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (dialog == null) {
                return;
            }
            log.log("Options Dialog - windowClosed ");
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    MyWindowListener.this.optionsPanel.cancel();
                }
            });
            OptionsWindowAction.dialog = null;
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    log.log("Options Dialog - Back to modern.");
                    OptionsWindowAction.this.actionPerformed(new ActionEvent(this, 0, "Open"));
                }
            });
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bClassic;

        OptionsPanelListener(DialogDescriptor dialogDescriptor, OptionsPanel optionsPanel, JButton jButton, JButton jButton2) {
            this.descriptor = dialogDescriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = jButton;
            this.bClassic = jButton2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("buranhelpCtx")) {
                this.descriptor.setHelpCtx(this.optionsPanel.getHelpCtx());
            } else if (propertyChangeEvent.getPropertyName().equals("buranvalid")) {
                this.bOK.setEnabled(this.optionsPanel.dataValid());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Class<?> clazz;
            Object object;
            if (dialog == null) {
                return;
            }
            if (actionEvent.getSource() == this.bOK) {
                log.log("Options Dialog - Ok pressed.");
                Dialog dialog = dialog;
                OptionsWindowAction.dialog = null;
                dialog.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.save();
                    }
                });
                return;
            }
            if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION || actionEvent.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.log("Options Dialog - Cancel pressed.");
                Dialog dialog = dialog;
                OptionsWindowAction.dialog = null;
                dialog.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
                return;
            }
            if (actionEvent.getSource() != this.bClassic) return;
            log.log("Options Dialog - Classic pressed.");
            Dialog dialog = dialog;
            OptionsWindowAction.dialog = null;
            if (this.optionsPanel.isChanged()) {
                object = new NotifyDescriptor.Confirmation((Object)OptionsWindowAction.loc("CTL_Some_values_changed"), 1, 3);
                clazz = DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                if (clazz == NotifyDescriptor.YES_OPTION) {
                    dialog.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.save();
                        }
                    });
                } else {
                    if (clazz != NotifyDescriptor.NO_OPTION) {
                        OptionsWindowAction.dialog = dialog;
                        return;
                    }
                    dialog.dispose();
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            OptionsPanelListener.this.optionsPanel.cancel();
                        }
                    });
                }
            } else {
                dialog.dispose();
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        OptionsPanelListener.this.optionsPanel.cancel();
                    }
                });
            }
            try {
                object = (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = OptionsWindowAction.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                clazz = ((ClassLoader)object).loadClass("org.netbeans.core.actions.OptionsAction");
                CallableSystemAction callableSystemAction = (CallableSystemAction)SystemAction.findObject(clazz, (boolean)true);
                callableSystemAction.putValue("additionalActionName", (Object)OptionsWindowAction.loc("CTL_Modern"));
                callableSystemAction.putValue("optionsDialogTitle", (Object)OptionsWindowAction.loc("CTL_Classic_Title"));
                callableSystemAction.putValue("additionalActionListener", (Object)new OpenOptionsListener());
                callableSystemAction.performAction();
                return;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
    }
}

