/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.options.ui.LoweredBorder;
import org.netbeans.modules.options.ui.VariableBorder;
import org.netbeans.spi.options.OptionsCategory;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.ProxyLookup;

public class OptionsPanel
extends JPanel {
    private JPanel pCategories;
    private JPanel pOptions;
    private JLabel lTitle;
    private List optionCategories;
    private int currentCategory = -1;
    private Button[] buttons;
    private Map categoryToPanel = new HashMap();
    private Map categoryToController = new HashMap();
    private Set updatedCategories = new HashSet();
    private Color selected = new Color(193, 210, 238);
    private Color selectedB = new Color(149, 106, 197);
    private Color highlighted = new Color(224, 232, 246);
    private Color highlightedB = new Color(152, 180, 226);
    private Color iconViewBorder = new Color(127, 157, 185);
    private ControllerListener coltrollerListener = new ControllerListener();
    private final boolean isMac = UIManager.getLookAndFeel().getID().equals("Aqua");
    private final Color selectedMac = new Color(221, 221, 221);
    private final Color selectedBMac = new Color(183, 183, 183);
    private final Color borderMac = new Color(141, 141, 141);
    private final Font labelFontMac = new Font("Lucida Grande", 0, 10);

    private static String loc(String string) {
        return NbBundle.getMessage((Class)OptionsPanel.class, (String)string);
    }

    public OptionsPanel() {
        Object object;
        Button button;
        OptionsCategory optionsCategory;
        JComponent jComponent;
        Object object2;
        Object object3;
        OptionsCategory optionsCategory2;
        int n;
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("OptionsDialog");
        if (fileObject != null) {
            Lookup lookup = new FolderLookup((DataObject.Container)DataFolder.findFolder((FileObject)fileObject)).getLookup();
            this.optionCategories = new ArrayList(lookup.lookup(new Lookup.Template(OptionsCategory.class)).allInstances());
        }
        this.pOptions = new JPanel();
        this.pOptions.setLayout(new BorderLayout());
        int n2 = 0;
        int n3 = 0;
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        int n4 = this.optionCategories.size();
        for (n = 0; n < n4; ++n) {
            optionsCategory2 = (OptionsCategory)this.optionCategories.get(n);
            object3 = optionsCategory2.create();
            arrayList.add(((OptionsPanelController)object3).getLookup());
            this.categoryToController.put(optionsCategory2, object3);
            ((OptionsPanelController)object3).addPropertyChangeListener(this.coltrollerListener);
        }
        optionsCategory2 = new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
        n4 = this.optionCategories.size();
        for (n = 0; n < n4; ++n) {
            object3 = (OptionsCategory)this.optionCategories.get(n);
            object2 = (OptionsPanelController)this.categoryToController.get(object3);
            jComponent = ((OptionsPanelController)object2).getComponent((Lookup)optionsCategory2);
            this.categoryToPanel.put(object3, jComponent);
            n2 = Math.max(n2, jComponent.getPreferredSize().width);
            n3 = Math.max(n3, jComponent.getPreferredSize().height);
        }
        this.pOptions.setPreferredSize(new Dimension(n2, n3));
        object3 = new JPanel(new BorderLayout());
        this.lTitle = new JLabel();
        if (Utilities.isWindows()) {
            this.lTitle.setBackground(SystemColor.activeCaption);
            this.lTitle.setForeground(SystemColor.activeCaptionText);
        } else {
            this.lTitle.setBackground(Color.white);
            this.lTitle.setForeground(Color.black);
        }
        object2 = this.lTitle.getFont();
        this.lTitle.setFont(new Font(((Font)object2).getName(), 1, 16));
        this.lTitle.setIconTextGap(8);
        this.lTitle.setOpaque(true);
        if (Utilities.isWindows()) {
            ((JComponent)object3).setBorder(new CompoundBorder(new LoweredBorder(), new LineBorder(SystemColor.activeCaption, 1)));
        } else {
            ((JComponent)object3).setBorder(new CompoundBorder(new LineBorder(this.iconViewBorder, 1), new LineBorder(Color.white, 2)));
        }
        ((Container)object3).add("Center", this.lTitle);
        this.pCategories = new JPanel(new BorderLayout());
        jComponent = new JPanel(new GridBagLayout());
        this.pCategories.add("North", jComponent);
        if (this.isMac) {
            this.pCategories.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 4, 0, 4)));
        } else {
            this.pCategories.setBorder(new LineBorder(this.iconViewBorder));
        }
        this.pCategories.setBackground(Color.white);
        jComponent.setBackground(Color.white);
        jComponent.setBorder(null);
        n4 = this.optionCategories.size();
        this.buttons = new Button[n4];
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(this.isMac ? KeyStroke.getKeyStroke(37, 0) : KeyStroke.getKeyStroke(38, 0), "UP");
        this.getActionMap().put("UP", new UpAction());
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "SPACE");
        this.getActionMap().put("SPACE", new SelectCurrentAction());
        inputMap.put(this.isMac ? KeyStroke.getKeyStroke(39, 0) : KeyStroke.getKeyStroke(40, 0), "DOWN");
        this.getActionMap().put("DOWN", new DownAction());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        if (this.isMac) {
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
        } else {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
        }
        for (n = 0; n < n4; ++n) {
            optionsCategory = (OptionsCategory)this.optionCategories.get(n);
            this.buttons[n] = button = new Button(optionsCategory, n);
            int n5 = button.getDisplayedMnemonic();
            object = KeyStroke.getKeyStroke(n5, 8);
            inputMap.put((KeyStroke)object, button);
            this.getActionMap().put(button, new SelectAction(n));
            if (this.isMac) {
                gridBagConstraints.gridx = n;
                gridBagConstraints.gridy = 0;
            } else {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n;
            }
            jComponent.add((Component)button, gridBagConstraints);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (this.isMac) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridy = 0;
        } else {
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
        }
        jComponent.add((Component)new JLabel(""), gridBagConstraints);
        optionsCategory = this.isMac ? new FormLayout("p:g", "p, 5dlu, p:g") : new FormLayout("p, 5dlu, p:g", "p, 5dlu, p:g");
        button = new PanelBuilder((FormLayout)optionsCategory, (JPanel)this);
        if (this.isMac) {
            this.pOptions.setBorder(new CompoundBorder(new VariableBorder(null, null, this.borderMac, null), BorderFactory.createEmptyBorder(0, 20, 5, 20)));
        } else {
            button.setDefaultDialogBorder();
        }
        CellConstraints cellConstraints = new CellConstraints();
        if (this.isMac) {
            button.add(this.pCategories, cellConstraints.xy(1, 1));
            button.add(this.pOptions, cellConstraints.xy(1, 3, "f,f"));
        } else {
            button.add(this.pCategories, cellConstraints.xywh(1, 1, 1, 3));
            button.add((Component)object3, cellConstraints.xy(3, 1));
            button.add(this.pOptions, cellConstraints.xy(3, 3, "f,f"));
        }
        if (n4 < 1) {
            return;
        }
        object = (OptionsCategory)this.optionCategories.get(0);
        OptionsPanelController optionsPanelController = (OptionsPanelController)this.categoryToController.get(object);
        try {
            optionsPanelController.update();
            this.updatedCategories.add(object);
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
        this.setCurrentIndex(0);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Iterator iterator = OptionsPanel.this.optionCategories.iterator();
                iterator.next();
                int n = 1;
                while (iterator.hasNext()) {
                    try {
                        OptionsCategory optionsCategory = (OptionsCategory)iterator.next();
                        ((OptionsPanelController)OptionsPanel.this.categoryToController.get(optionsCategory)).update();
                        OptionsPanel.this.updatedCategories.add(optionsCategory);
                        if (OptionsPanel.this.getCurrentIndex() == n) {
                            OptionsPanel.this.setCurrentIndex(n);
                        }
                        ++n;
                    }
                    catch (Throwable throwable) {
                        ErrorManager.getDefault().notify(throwable);
                    }
                }
            }
        });
    }

    int getCurrentIndex() {
        return this.currentCategory;
    }

    void setCurrentIndex(final int n) {
        Object object;
        if (this.currentCategory != -1) {
            this.buttons[this.currentCategory].setNormal();
        }
        if (n != -1) {
            this.buttons[n].setSelected();
        }
        this.currentCategory = n;
        OptionsCategory optionsCategory = (OptionsCategory)this.optionCategories.get(n);
        this.pOptions.removeAll();
        if (this.updatedCategories.contains(optionsCategory)) {
            object = (JComponent)this.categoryToPanel.get(optionsCategory);
            this.pOptions.add("Center", (Component)object);
        } else {
            object = new JLabel(OptionsPanel.loc("CTL_Loading_Options"));
            ((JLabel)object).setHorizontalAlignment(0);
            this.pOptions.add("Center", (Component)object);
        }
        object = optionsCategory.getIcon();
        if (object != null) {
            this.lTitle.setIcon((Icon)object);
        }
        this.lTitle.setText(optionsCategory.getTitle());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OptionsPanel.this.invalidate();
                OptionsPanel.this.validate();
                OptionsPanel.this.repaint();
                if (n != -1) {
                    OptionsPanel.this.buttons[n].requestFocus();
                }
            }
        });
        this.firePropertyChange("buranhelpCtx", null, null);
    }

    HelpCtx getHelpCtx() {
        OptionsCategory optionsCategory = (OptionsCategory)this.optionCategories.get(this.getCurrentIndex());
        OptionsPanelController optionsPanelController = (OptionsPanelController)this.categoryToController.get(optionsCategory);
        return optionsPanelController.getHelpCtx();
    }

    void update() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            try {
                ((OptionsPanelController)iterator.next()).update();
            }
            catch (Throwable throwable) {
                ErrorManager.getDefault().notify(throwable);
            }
        }
    }

    void save() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            ((OptionsPanelController)iterator.next()).applyChanges();
        }
    }

    void cancel() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            ((OptionsPanelController)iterator.next()).cancel();
        }
    }

    boolean dataValid() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (((OptionsPanelController)iterator.next()).isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (!((OptionsPanelController)iterator.next()).isChanged()) continue;
            return true;
        }
        return false;
    }

    class Button
    extends JLabel
    implements MouseListener {
        private int index;

        Button(OptionsCategory optionsCategory, int n) {
            super(optionsCategory.getIcon());
            this.index = n;
            Mnemonics.setLocalizedText((JLabel)this, (String)optionsCategory.getCategoryName());
            this.setOpaque(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setHorizontalAlignment(0);
            this.addMouseListener(this);
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(true);
            this.setForeground(Color.black);
            if (OptionsPanel.this.isMac) {
                this.setFont(OptionsPanel.this.labelFontMac);
                this.setIconTextGap(2);
            }
            if (n == OptionsPanel.this.currentCategory) {
                this.setSelected();
            } else {
                this.setNormal();
            }
            this.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    if (Button.this.index != OptionsPanel.this.currentCategory) {
                        Button.this.setHighlighted();
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (Button.this.index != OptionsPanel.this.currentCategory) {
                        Button.this.setNormal();
                    }
                }
            });
        }

        void setNormal() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new EmptyBorder(5, 6, 3, 6));
            } else {
                this.setBorder(new EmptyBorder(2, 4, 2, 4));
            }
            this.setBackground(Color.white);
        }

        void setSelected() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedBMac, null, OptionsPanel.this.selectedBMac), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
                this.setBackground(OptionsPanel.this.selectedMac);
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.selectedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.selected);
            }
        }

        void setHighlighted() {
            if (OptionsPanel.this.isMac) {
                this.setBorder(new CompoundBorder(new VariableBorder(null, OptionsPanel.this.selectedBMac, null, OptionsPanel.this.selectedBMac), BorderFactory.createEmptyBorder(5, 5, 3, 5)));
                this.setBackground(OptionsPanel.this.selectedMac);
            } else {
                this.setBorder(new CompoundBorder(new CompoundBorder(new LineBorder(Color.white), new LineBorder(OptionsPanel.this.highlightedB)), new EmptyBorder(0, 2, 0, 2)));
                this.setBackground(OptionsPanel.this.highlighted);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            OptionsPanel.this.setCurrentIndex(this.index);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!OptionsPanel.this.isMac) {
                this.setSelected();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.index != OptionsPanel.this.currentCategory && !OptionsPanel.this.isMac) {
                this.setHighlighted();
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.index != OptionsPanel.this.currentCategory && !OptionsPanel.this.isMac) {
                this.setNormal();
            }
        }
    }

    class ControllerListener
    implements PropertyChangeListener {
        ControllerListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            OptionsPanel.this.firePropertyChange("buran" + propertyChangeEvent.getPropertyName(), null, null);
        }
    }

    private class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = OptionsPanel.this.getCurrentIndex();
            if (n < OptionsPanel.this.optionCategories.size() - 1) {
                OptionsPanel.this.setCurrentIndex(n + 1);
            } else {
                OptionsPanel.this.setCurrentIndex(0);
            }
        }
    }

    private class SelectAction
    extends AbstractAction {
        private int index;

        SelectAction(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsPanel.this.setCurrentIndex(this.index);
        }
    }

    private class SelectCurrentAction
    extends AbstractAction {
        private SelectCurrentAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (component instanceof Button) {
                OptionsPanel.this.setCurrentIndex(((Button)component).index);
                ((Button)component).setSelected();
            }
        }
    }

    private class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = OptionsPanel.this.getCurrentIndex();
            if (n > 0) {
                OptionsPanel.this.setCurrentIndex(n - 1);
            } else {
                OptionsPanel.this.setCurrentIndex(OptionsPanel.this.optionCategories.size() - 1);
            }
        }
    }
}

