/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CloseAllDocumentsAction
extends AbstractAction {
    private boolean isContext;

    public CloseAllDocumentsAction() {
        this(false);
    }

    public CloseAllDocumentsAction(boolean bl) {
        this.isContext = bl;
        String string = bl ? "LBL_CloseAllDocumentsAction" : "CTL_CloseAllDocumentsAction";
        this.putValue("Name", NbBundle.getMessage(CloseAllDocumentsAction.class, (String)string));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ActionUtils.closeAllDocuments(this.isContext);
    }

    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("CloseAllDocuments", object);
        } else {
            super.putValue(string, object);
        }
    }

    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("CloseAllDocuments");
        }
        return super.getValue(string);
    }

    public boolean isEnabled() {
        WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
        if (this.isContext) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(topComponent);
            return modeImpl != null && modeImpl.getKind() == 1 && !modeImpl.getOpenedTopComponents().isEmpty();
        }
        return windowManagerImpl.getEditorTopComponents().length > 0;
    }
}

