/*
 * Decompiled with CFR 0.152.
 */
package tr.view.action.recurrence;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import tr.appl.Constants;
import tr.model.action.Intervals;
import tr.model.action.Period;
import tr.model.action.PeriodDay;
import tr.model.action.PeriodMonth;
import tr.model.action.PeriodType;
import tr.model.action.PeriodWeek;
import tr.model.action.PeriodWeekday;
import tr.model.action.PeriodYear;
import tr.model.action.Recurrence;
import tr.swing.date.field.DateField;
import tr.util.DateUtils;
import tr.view.action.PeriodMonthlyPanel;
import tr.view.action.PeriodWeeklyPanel;
import tr.view.action.PeriodYearlyPanel;
import tr.view.action.recurrence.PeriodTypeComboBox;

public final class NewRecurrenceVisualPanel4
extends JPanel {
    private static int counter;
    private final Recurrence recurrence;
    private final Date actionScheduledDate;
    private Map<PeriodType, Period> mapPeriods;
    private Map<PeriodType, Integer> mapAdvanceNbrs;
    private PeriodWeeklyPanel periodWeeklyPanel;
    private PeriodMonthlyPanel periodMonthlyPanel;
    private PeriodYearlyPanel periodYearlyPanel;
    private JLabel advanceLabel1;
    private JLabel advanceLabel2;
    private JSpinner advanceSpinner;
    private ButtonGroup buttonGroup;
    private DateField endDateField;
    private JRadioButton endDateRadioButton;
    private JLabel endLabel;
    private JLabel endNbrLabel;
    private JRadioButton endNbrRadioButton;
    private JSpinner endNbrSpinner;
    private JRadioButton endNeverRadioButton;
    private JLabel errorLabel1;
    private JLabel errorLabel2;
    private JSpinner frequencySpinner;
    private PeriodTypeComboBox periodComboBox;
    private JLabel periodLabel;
    private JPanel periodPanel;
    private DateField startDateField;
    private JLabel startLabel;

    public NewRecurrenceVisualPanel4(Recurrence recurrence, Date actionScheduledDate) {
        this.recurrence = recurrence;
        this.actionScheduledDate = actionScheduledDate;
        this.initComponents();
        this.initPeriods();
        this.initPanel();
    }

    private void initPeriods() {
        this.setPeriod((Period)new PeriodWeekday());
        this.setPeriod((Period)new PeriodDay());
        this.setPeriod((Period)new PeriodWeek());
        this.setPeriod((Period)new PeriodMonth());
        this.setPeriod((Period)new PeriodYear());
        this.setPeriod(this.recurrence.getPeriod());
        this.setAdvanceNbr(this.recurrence.getPeriod().getType(), this.recurrence.getAdvanceNbr());
    }

    private Period getPeriod(PeriodType type) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        return this.mapPeriods.get(type);
    }

    private void setPeriod(Period period) {
        if (this.mapPeriods == null) {
            this.mapPeriods = new HashMap<PeriodType, Period>();
        }
        this.mapPeriods.put(period.getType(), period);
    }

    private Integer getAdvanceNbr(PeriodType type) {
        Integer n;
        if (this.mapAdvanceNbrs == null) {
            this.mapAdvanceNbrs = new HashMap<PeriodType, Integer>();
        }
        if ((n = this.mapAdvanceNbrs.get(type)) == null || n < 1) {
            n = this.getPeriod(type).getDefaultAdvanceNbr();
        }
        return n;
    }

    private void setAdvanceNbr(PeriodType type, Integer advanceNbr) {
        if (this.mapAdvanceNbrs == null) {
            this.mapAdvanceNbrs = new HashMap<PeriodType, Integer>();
        }
        this.mapAdvanceNbrs.put(type, advanceNbr);
    }

    public String getName() {
        return "Define Regular Recurrence";
    }

    public void stateChange() {
        this.putClientProperty("state.change", ++counter);
    }

    public void initPanel() {
        this.startDateField.setDate(this.recurrence.getStartDate());
        this.frequencySpinner.setValue(this.recurrence.getFrequency());
        this.periodComboBox.setSelectedItem(this.recurrence.getPeriod().getType());
        this.advanceSpinner.setValue(this.recurrence.getAdvanceNbr());
        this.endNbrRadioButton.setSelected(this.recurrence.getEndNbr() != null);
        this.endNbrSpinner.setValue(this.recurrence.getEndNbr() == null ? 2 : this.recurrence.getEndNbr());
        this.endDateRadioButton.setSelected(this.recurrence.getEndDate() != null);
        this.endDateField.setDate(this.recurrence.getEndDate());
        this.endNeverRadioButton.setSelected(!this.endNbrRadioButton.isSelected() && !this.endDateRadioButton.isSelected());
        this.enableDisableComponents();
    }

    private void enableDisableComponents() {
        this.endDateField.setEnabled(this.endDateRadioButton.isSelected());
        this.endNbrSpinner.setEnabled(this.endNbrRadioButton.isSelected());
    }

    private void setEndValues() {
        if (this.endNbrRadioButton.isSelected()) {
            this.recurrence.setEndNbr((Integer)this.endNbrSpinner.getValue());
            this.recurrence.setEndDate(null);
            Date start = this.recurrence.getStartDate();
            if (start != null) {
                Period per = this.recurrence.getPeriod();
                int freq = this.recurrence.getFrequency();
                int endNbr = this.recurrence.getEndNbr();
                Intervals intervals = new Intervals(per, freq, start);
                Date endDate = Recurrence.getTerminationEndDate((Intervals)intervals, (int)endNbr);
                this.endDateField.setDate(endDate);
            }
            return;
        }
        if (this.endDateRadioButton.isSelected()) {
            this.recurrence.setEndNbr(null);
            this.recurrence.setEndDate(this.endDateField.getDate());
            return;
        }
    }

    public boolean isValidForm() {
        if (this.startDateField.getDate() == null) {
            this.errorLabel1.setText("Start date must be entered.");
            return false;
        }
        if (this.actionScheduledDate != null && this.startDateField.getDate().before(DateUtils.clearTime((Date)this.actionScheduledDate))) {
            String d = Constants.DATE_FORMAT_FIXED.format(this.actionScheduledDate);
            this.errorLabel1.setText("Start date can not be before action date (" + d + ").");
            this.errorLabel2.setText("Maybe you need to change the selected action date.");
            return false;
        }
        if (this.endDateRadioButton.isSelected() && this.endDateField.getDate() == null) {
            this.errorLabel1.setText("Termination date must be entered.");
            return false;
        }
        this.errorLabel1.setText("");
        this.errorLabel2.setText("");
        return true;
    }

    private Dialog getDialog() {
        return (Dialog)SwingUtilities.getWindowAncestor(this);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.startLabel = new JLabel();
        this.startDateField = new DateField();
        this.periodLabel = new JLabel();
        this.frequencySpinner = new JSpinner();
        this.periodComboBox = new PeriodTypeComboBox();
        this.periodPanel = new JPanel();
        this.advanceLabel1 = new JLabel();
        this.advanceSpinner = new JSpinner();
        this.advanceLabel2 = new JLabel();
        this.endLabel = new JLabel();
        this.endNeverRadioButton = new JRadioButton();
        this.endNbrRadioButton = new JRadioButton();
        this.endNbrSpinner = new JSpinner();
        this.endNbrLabel = new JLabel();
        this.endDateRadioButton = new JRadioButton();
        this.endDateField = new DateField();
        this.errorLabel1 = new JLabel();
        this.errorLabel2 = new JLabel();
        this.setMaximumSize(new Dimension(1024, 768));
        this.setMinimumSize(new Dimension(480, 360));
        this.startLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.startLabel, (String)"Start Date");
        this.startLabel.setMaximumSize(new Dimension(100, 23));
        this.startLabel.setMinimumSize(new Dimension(100, 23));
        this.startLabel.setPreferredSize(new Dimension(100, 23));
        this.startDateField.setMaximumSize(new Dimension(110, 23));
        this.startDateField.setMinimumSize(new Dimension(110, 23));
        this.startDateField.setPreferredSize(new Dimension(110, 23));
        this.startDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NewRecurrenceVisualPanel4.this.startDateFieldPropertyChange(evt);
            }
        });
        this.periodLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.periodLabel, (String)"Period");
        this.periodLabel.setMaximumSize(new Dimension(100, 23));
        this.periodLabel.setMinimumSize(new Dimension(100, 23));
        this.periodLabel.setPreferredSize(new Dimension(100, 23));
        this.frequencySpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.frequencySpinner.setMaximumSize(new Dimension(50, 23));
        this.frequencySpinner.setMinimumSize(new Dimension(50, 23));
        this.frequencySpinner.setPreferredSize(new Dimension(50, 23));
        this.frequencySpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel4.this.frequencySpinnerStateChanged(evt);
            }
        });
        this.periodComboBox.setMaximumSize(new Dimension(125, 23));
        this.periodComboBox.setMinimumSize(new Dimension(125, 23));
        this.periodComboBox.setPreferredSize(new Dimension(125, 23));
        this.periodComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel4.this.periodActionPerformed(evt);
            }
        });
        this.periodPanel.setMaximumSize(new Dimension(530, 26));
        this.periodPanel.setMinimumSize(new Dimension(530, 26));
        this.periodPanel.setPreferredSize(new Dimension(530, 26));
        this.periodPanel.setLayout(new FlowLayout(0, 5, 0));
        this.advanceLabel1.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.advanceLabel1, (String)"Generate");
        this.advanceLabel1.setMaximumSize(new Dimension(100, 23));
        this.advanceLabel1.setMinimumSize(new Dimension(100, 23));
        this.advanceLabel1.setPreferredSize(new Dimension(100, 23));
        this.advanceSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.advanceSpinner.setMaximumSize(new Dimension(50, 23));
        this.advanceSpinner.setMinimumSize(new Dimension(50, 23));
        this.advanceSpinner.setPreferredSize(new Dimension(50, 23));
        this.advanceSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel4.this.advanceSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.advanceLabel2, (String)"periods in advance (from current date)");
        this.advanceLabel2.setMaximumSize(new Dimension(67, 23));
        this.advanceLabel2.setMinimumSize(new Dimension(67, 23));
        this.advanceLabel2.setPreferredSize(new Dimension(67, 23));
        this.endLabel.setHorizontalAlignment(11);
        Mnemonics.setLocalizedText((JLabel)this.endLabel, (String)"Terminate");
        this.endLabel.setMaximumSize(new Dimension(100, 23));
        this.endLabel.setMinimumSize(new Dimension(100, 23));
        this.endLabel.setPreferredSize(new Dimension(100, 23));
        this.buttonGroup.add(this.endNeverRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNeverRadioButton, (String)"never");
        this.endNeverRadioButton.setMaximumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setMinimumSize(new Dimension(90, 23));
        this.endNeverRadioButton.setPreferredSize(new Dimension(90, 23));
        this.endNeverRadioButton.setVerticalTextPosition(1);
        this.endNeverRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel4.this.endNeverRadioButtonActionPerformed(evt);
            }
        });
        this.buttonGroup.add(this.endNbrRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endNbrRadioButton, (String)"after");
        this.endNbrRadioButton.setMaximumSize(new Dimension(62, 23));
        this.endNbrRadioButton.setMinimumSize(new Dimension(62, 23));
        this.endNbrRadioButton.setPreferredSize(new Dimension(62, 23));
        this.endNbrRadioButton.setVerticalTextPosition(1);
        this.endNbrRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel4.this.endNbrRadioButtonActionPerformed(evt);
            }
        });
        this.endNbrSpinner.setModel(new SpinnerNumberModel((Number)2, Integer.valueOf(2), null, (Number)1));
        this.endNbrSpinner.setMaximumSize(new Dimension(50, 23));
        this.endNbrSpinner.setMinimumSize(new Dimension(50, 23));
        this.endNbrSpinner.setPreferredSize(new Dimension(50, 23));
        this.endNbrSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                NewRecurrenceVisualPanel4.this.endNbrSpinnerStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.endNbrLabel, (String)"periods");
        this.endNbrLabel.setMaximumSize(new Dimension(90, 23));
        this.endNbrLabel.setMinimumSize(new Dimension(90, 23));
        this.endNbrLabel.setPreferredSize(new Dimension(90, 23));
        this.buttonGroup.add(this.endDateRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.endDateRadioButton, (String)"after");
        this.endDateRadioButton.setMaximumSize(new Dimension(62, 23));
        this.endDateRadioButton.setMinimumSize(new Dimension(62, 23));
        this.endDateRadioButton.setPreferredSize(new Dimension(62, 23));
        this.endDateRadioButton.setVerticalTextPosition(1);
        this.endDateRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewRecurrenceVisualPanel4.this.endDateRadioButtonActionPerformed(evt);
            }
        });
        this.endDateField.setMaximumSize(new Dimension(110, 23));
        this.endDateField.setMinimumSize(new Dimension(110, 23));
        this.endDateField.setPreferredSize(new Dimension(110, 23));
        this.endDateField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                NewRecurrenceVisualPanel4.this.endDateFieldPropertyChange(evt);
            }
        });
        this.errorLabel1.setForeground(Color.red);
        this.errorLabel1.setHorizontalAlignment(2);
        this.errorLabel1.setHorizontalTextPosition(0);
        this.errorLabel1.setMaximumSize(new Dimension(1024, 23));
        this.errorLabel1.setMinimumSize(new Dimension(16, 23));
        this.errorLabel1.setOpaque(true);
        this.errorLabel1.setPreferredSize(new Dimension(16, 23));
        this.errorLabel2.setForeground(Color.red);
        this.errorLabel2.setHorizontalAlignment(2);
        this.errorLabel2.setHorizontalTextPosition(0);
        this.errorLabel2.setMaximumSize(new Dimension(1024, 23));
        this.errorLabel2.setMinimumSize(new Dimension(16, 23));
        this.errorLabel2.setOpaque(true);
        this.errorLabel2.setPreferredSize(new Dimension(16, 23));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.errorLabel1, -1, 640, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.startLabel, -1, -1, Short.MAX_VALUE).add((Component)this.periodLabel, 0, 0, Short.MAX_VALUE).add(1, (Component)this.endLabel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.advanceLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.frequencySpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.periodComboBox, -2, -1, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.advanceSpinner, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.advanceLabel2, -2, 256, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.endNeverRadioButton, -2, -1, -2).addPreferredGap(1).add((Component)this.endNbrRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrSpinner, -2, -1, -2).addPreferredGap(0).add((Component)this.endNbrLabel, -2, -1, -2))).addPreferredGap(0).add((Component)this.endDateRadioButton, -2, -1, -2).addPreferredGap(0).add((Component)this.endDateField, -2, -1, -2))).add(35, 35, 35)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.startDateField, -2, -1, -2).add(66, 66, 66)).add(2, (Component)this.periodPanel, -2, -1, -2))).add((Component)this.errorLabel2, -1, 640, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(30, 30, 30).add((GroupLayout.Group)layout.createParallelGroup(4).add((Component)this.startLabel, -2, -1, -2).add((Component)this.startDateField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.periodLabel, -2, -1, -2).add(2, (Component)this.frequencySpinner, -2, -1, -2).add(2, (Component)this.periodComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.periodPanel, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.advanceLabel1, -2, -1, -2).add((Component)this.advanceSpinner, -2, -1, -2).add((Component)this.advanceLabel2, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.endLabel, -2, -1, -2).add((Component)this.endNeverRadioButton, -2, -1, -2).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.endNbrLabel, -2, -1, -2).add(2, (Component)this.endNbrRadioButton, -2, -1, -2).add(2, (Component)this.endNbrSpinner, -2, -1, -2)))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.endDateRadioButton, -2, -1, -2).add((Component)this.endDateField, -2, -1, -2))).add(18, 18, 18).add((Component)this.errorLabel1, -2, -1, -2).add(0, 0, 0).add((Component)this.errorLabel2, -2, -1, -2).addContainerGap(109, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.frequencySpinner, this.periodComboBox, this.periodLabel}, 2);
        layout.linkSize(new Component[]{this.advanceLabel1, this.advanceLabel2, this.advanceSpinner}, 2);
    }

    private void endNbrRadioButtonActionPerformed(ActionEvent evt) {
        this.stateChange();
        this.setEndValues();
        this.enableDisableComponents();
    }

    private void periodActionPerformed(ActionEvent evt) {
        PeriodType periodType = (PeriodType)this.periodComboBox.getSelectedItem();
        Period period = this.getPeriod(periodType);
        Integer advanceNbr = this.getAdvanceNbr(periodType);
        this.recurrence.setPeriod(period);
        this.recurrence.setAdvanceNbr(advanceNbr.intValue());
        this.periodPanel.removeAll();
        switch (periodType) {
            case WEEK: {
                this.periodPanel.add(new JLabel("on "));
                if (this.periodWeeklyPanel == null) {
                    this.periodWeeklyPanel = new PeriodWeeklyPanel();
                    this.periodWeeklyPanel.setPeriodWeek((PeriodWeek)period);
                }
                this.periodWeeklyPanel.notifyStartDate(this.startDateField.getDate());
                this.periodPanel.add(this.periodWeeklyPanel);
                break;
            }
            case MONTH: {
                if (this.periodMonthlyPanel == null) {
                    this.periodMonthlyPanel = new PeriodMonthlyPanel(this.getDialog(), (PeriodMonth)period);
                }
                this.periodMonthlyPanel.notifyStartDate(this.startDateField.getDate());
                this.periodPanel.add(this.periodMonthlyPanel);
                break;
            }
            case YEAR: {
                if (this.periodYearlyPanel == null) {
                    this.periodYearlyPanel = new PeriodYearlyPanel(this.getDialog(), (PeriodYear)period);
                }
                this.periodYearlyPanel.notifyStartDate(this.startDateField.getDate());
                this.periodPanel.add(this.periodYearlyPanel);
            }
        }
        this.advanceSpinner.setValue(advanceNbr);
        this.stateChange();
        this.setEndValues();
        this.periodPanel.validate();
        this.periodPanel.repaint();
    }

    private void advanceSpinnerStateChanged(ChangeEvent evt) {
        Integer newValue;
        Integer oldValue = this.getAdvanceNbr(this.recurrence.getPeriod().getType());
        if (oldValue != (newValue = (Integer)this.advanceSpinner.getValue())) {
            this.recurrence.setAdvanceNbr(newValue.intValue());
            this.setAdvanceNbr(this.recurrence.getPeriod().getType(), this.recurrence.getAdvanceNbr());
            this.stateChange();
        }
    }

    private void startDateFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.recurrence.setStartDate(this.startDateField.getDate());
            this.putClientProperty("start", this.startDateField.getDate());
            this.stateChange();
            this.setEndValues();
        }
    }

    private void endNeverRadioButtonActionPerformed(ActionEvent evt) {
        this.stateChange();
        this.setEndValues();
        this.enableDisableComponents();
    }

    private void endDateRadioButtonActionPerformed(ActionEvent evt) {
        this.stateChange();
        this.setEndValues();
        this.enableDisableComponents();
    }

    private void endNbrSpinnerStateChanged(ChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
    }

    private void endDateFieldPropertyChange(PropertyChangeEvent evt) {
        this.stateChange();
        this.setEndValues();
    }

    private void frequencySpinnerStateChanged(ChangeEvent evt) {
        this.recurrence.setFrequency(((Integer)this.frequencySpinner.getValue()).intValue());
        this.stateChange();
        this.setEndValues();
    }
}

