/*
 * Decompiled with CFR 0.152.
 */
package tr.model.future;

import java.util.Calendar;
import java.util.Date;
import tr.model.thought.Thought;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;
import tr.util.Utils;

public class Future
extends ObservableImpl
implements Comparable,
Observer,
TopicChangeCookie {
    private Date created = Calendar.getInstance().getTime();
    private Thought thought;
    private String description;
    private Topic topic;
    private String notes;
    private Date tickle;

    public Future() {
        this.setThought(null);
        this.setDescription("");
        this.setTopic(Topic.getDefault());
        this.setNotes("");
    }

    public Date getCreated() {
        return this.created;
    }

    public Thought getThought() {
        return this.thought;
    }

    public void setThought(Thought thought) {
        if (Utils.equal((Object)this.thought, (Object)thought)) {
            return;
        }
        this.thought = thought;
        this.notifyObservers((Observable)this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (Utils.equal((Object)this.description, (Object)description)) {
            return;
        }
        this.description = description;
        this.notifyObservers((Observable)this, (Object)Change.DESCRIPTION);
    }

    public Topic getTopic() {
        if (this.topic == null) {
            return Topic.getDefault();
        }
        if (this.topic.getName().equals(Topic.getDefault().getName())) {
            return Topic.getDefault();
        }
        return this.topic;
    }

    public void setTopic(Topic topic) {
        if (Utils.equal((Object)this.topic, (Object)topic)) {
            return;
        }
        this.topic = topic;
        this.notifyObservers((Observable)this, (Object)Change.TOPIC);
    }

    public String getNotes() {
        return this.notes == null ? "" : this.notes;
    }

    public void setNotes(String notes) {
        if (Utils.equal((Object)this.notes, (Object)notes)) {
            return;
        }
        this.notes = notes;
        this.notifyObservers((Observable)this, (Object)Change.NOTES);
    }

    public Date getTickle() {
        return this.tickle;
    }

    public void setTickle(Date date) {
        if (!Utils.equal((Object)this.tickle, (Object)date)) {
            this.tickle = date;
            this.notifyObservers((Observable)this, (Object)Change.TICKLE);
        }
    }

    public int compareTo(Object object) {
        if (!(object instanceof Future)) {
            return -1;
        }
        Future other = (Future)object;
        int result = this.topic.compareTo(other.topic);
        if (result != 0) {
            return result;
        }
        return this.description.compareToIgnoreCase(other.description);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Future)) {
            return false;
        }
        Future future = (Future)object;
        if (!Utils.equal((Object)this.created, (Object)future.created)) {
            return false;
        }
        if (!Utils.equal((Object)this.thought, (Object)future.thought)) {
            return false;
        }
        if (!Utils.equal((Object)this.description, (Object)future.description)) {
            return false;
        }
        if (!Utils.equal((Object)this.topic, (Object)future.topic)) {
            return false;
        }
        return Utils.equal((Object)this.notes, (Object)future.notes);
    }

    public String toString() {
        return this.description;
    }

    public void update(Observable observable, Object arguement) {
        this.notifyObservers(observable, arguement);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Change {
        DESCRIPTION,
        TOPIC,
        NOTES,
        TICKLE;

    }
}

