/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.openide.actions.FindAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceSupport;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public final class DataSystem
extends AbstractNode
implements RepositoryListener {
    private static DataSystem def;
    private transient Repository fileSystemPool;
    DataFilter filter;

    private DataSystem(Children children, Repository repository, DataFilter dataFilter) {
        super(children);
        this.fileSystemPool = repository;
        this.filter = dataFilter;
        this.initialize();
        this.setIconBaseWithExtension("org/netbeans/core/resources/repository.gif");
        this.setName(NbBundle.getBundle(DataSystem.class).getString("dataSystemName"));
        this.setShortDescription(NbBundle.getBundle(DataSystem.class).getString("CTL_Repository_Hint"));
        this.getCookieSet().add((Node.Cookie)new InstanceSupport.Instance((Object)repository));
    }

    private DataSystem(Children children, DataFilter dataFilter) {
        this(children, Repository.getDefault(), dataFilter);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(DataSystem.class);
    }

    public static Node getDataSystem(DataFilter dataFilter) {
        if (dataFilter == null) {
            if (def != null) {
                return def;
            }
            def = new DataSystem((Children)new DSMap(), DataFilter.ALL);
            return def;
        }
        return new DataSystem((Children)new DSMap(), dataFilter);
    }

    public static Node getDataSystem() {
        return DataSystem.getDataSystem(null);
    }

    void initialize() {
        this.fileSystemPool.addRepositoryListener((RepositoryListener)WeakListeners.create(RepositoryListener.class, (EventListener)((Object)this), (Object)this.fileSystemPool));
        Enumeration enumeration = this.fileSystemPool.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            fileSystem.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)fileSystem));
        }
        this.refresh();
    }

    public Node.Handle getHandle() {
        return this.filter == DataFilter.ALL ? new DSHandle(null) : new DSHandle(this.filter);
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{SystemAction.get(FindAction.class), SystemAction.get(ToolsAction.class)};
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        repositoryEvent.getFileSystem().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)((DSMap)this.getChildren()), (Object)repositoryEvent.getFileSystem()));
        this.refresh();
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        this.refresh();
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        this.refresh();
    }

    void refresh() {
        this.refresh(null);
    }

    void refresh(FileSystem fileSystem) {
        URLMapper uRLMapper = DataSystem.getMasterFsURLMapper();
        if (uRLMapper == null) {
            ((DSMap)this.getChildren()).refresh(this.fileSystemPool, fileSystem);
        } else {
            ((DSMap)this.getChildren()).refreshListRoots(uRLMapper);
        }
    }

    private static URLMapper getMasterFsURLMapper() {
        URLMapper uRLMapper = null;
        Lookup.Result result = Lookup.getDefault().lookupResult(URLMapper.class);
        Collection collection = result.allInstances();
        for (URLMapper uRLMapper2 : collection) {
            if (uRLMapper2 == null || !"org.netbeans.modules.masterfs.MasterURLMapper".equals(uRLMapper2.getClass().getName())) continue;
            uRLMapper = uRLMapper2;
            break;
        }
        return uRLMapper;
    }

    public boolean hasCustomizer() {
        return true;
    }

    private static class DSHandle
    implements Node.Handle {
        DataFilter filter;
        static final long serialVersionUID = -2266375092419944364L;

        public DSHandle(DataFilter dataFilter) {
            this.filter = dataFilter;
        }

        public Node getNode() {
            return DataSystem.getDataSystem(this.filter);
        }
    }

    static class DSMap
    extends Children.Keys
    implements PropertyChangeListener {
        DSMap() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DataSystem dataSystem = this.getDS();
            if (dataSystem == null) {
                return;
            }
            if ("root".equals(propertyChangeEvent.getPropertyName())) {
                FileSystem fileSystem = (FileSystem)propertyChangeEvent.getSource();
                dataSystem.refresh(fileSystem);
                dataSystem.refresh();
            }
        }

        private DataSystem getDS() {
            return (DataSystem)this.getNode();
        }

        protected Node[] createNodes(Object object) {
            DataFolder dataFolder = (DataFolder)object;
            FilterNode filterNode = new FilterNode(dataFolder.getNodeDelegate(), dataFolder.createNodeChildren(this.getDS().filter));
            return new Node[]{filterNode};
        }

        public void refresh(Repository repository, FileSystem fileSystem) {
            Enumeration enumeration = repository.getFileSystems();
            ArrayList<DataFolder> arrayList = new ArrayList<DataFolder>();
            while (enumeration.hasMoreElements()) {
                FileSystem fileSystem2 = (FileSystem)enumeration.nextElement();
                DataObject dataObject = null;
                try {
                    dataObject = DataObject.find((FileObject)fileSystem2.getRoot());
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger(DataSystem.class.getName()).log(Level.WARNING, null, dataObjectNotFoundException);
                }
                if (!(dataObject instanceof DataFolder) || !this.getDS().filter.acceptDataObject(dataObject)) continue;
                arrayList.add((DataFolder)dataObject);
            }
            this.setKeys(arrayList);
        }

        private void refreshListRoots(URLMapper uRLMapper) {
            File[] fileArray = File.listRoots();
            LinkedHashSet<DataFolder> linkedHashSet = new LinkedHashSet<DataFolder>();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                FileObject fileObject = this.fetchFileObject(file, uRLMapper);
                if (fileObject == null) continue;
                try {
                    fileObject = fileObject.getFileSystem().getRoot();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    continue;
                }
                DataObject dataObject = null;
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    Logger.getLogger(DataSystem.class.getName()).log(Level.WARNING, null, dataObjectNotFoundException);
                }
                if (!(dataObject instanceof DataFolder) || !this.getDS().filter.acceptDataObject(dataObject)) continue;
                linkedHashSet.add((DataFolder)dataObject);
            }
            this.setKeys(linkedHashSet);
        }

        private FileObject fetchFileObject(File file, URLMapper uRLMapper) {
            FileObject fileObject = null;
            try {
                FileObject[] fileObjectArray = uRLMapper.getFileObjects(this.toUrl(file));
                if (fileObjectArray != null && fileObjectArray.length > 0) {
                    fileObject = fileObjectArray[0];
                }
            }
            catch (MalformedURLException malformedURLException) {
                fileObject = null;
            }
            return fileObject;
        }

        private URL toUrl(File file) throws MalformedURLException {
            return Utilities.isWindows() ? new URL("file:/" + file.getAbsolutePath()) : file.toURI().toURL();
        }
    }

    public static final class NbRepositoryNodeFactory
    extends RepositoryNodeFactory {
        public Node repository(DataFilter dataFilter) {
            return DataSystem.getDataSystem(dataFilter == DataFilter.ALL ? null : dataFilter);
        }
    }
}

