/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future.screen;

import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.future.Future;
import tr.model.thought.Thought;
import tr.util.Observable;
import tr.view.future.FutureDeleteCookie;
import tr.view.future.FutureEditCookie;
import tr.view.future.FutureReprocessCookie;
import tr.view.future.screen.FutureTopComponent;
import tr.view.process.ProcessThoughtsAction;

public class FutureNode
extends AbstractNode
implements FutureEditCookie,
FutureDeleteCookie,
FutureReprocessCookie {
    public final Future future;

    public FutureNode(Future future) {
        super(Children.LEAF, Lookups.singleton((Object)future));
        this.future = future;
    }

    public String getName() {
        return this.future == null ? "" : this.future.getDescription();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == FutureEditCookie.class) {
            return this;
        }
        if (clazz == FutureDeleteCookie.class) {
            return this;
        }
        if (clazz == FutureReprocessCookie.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    public void editFuture() {
        if (this.future == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        FutureTopComponent rtc = FutureTopComponent.findInstance();
        if (rtc == null) {
            return;
        }
        rtc.edit();
    }

    public void deleteFuture() {
        if (this.future == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        data.getFutureManager().remove((Observable)this.future);
    }

    public void reprocessFuture() {
        if (this.future == null) {
            return;
        }
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        data.getFutureManager().remove((Observable)this.future);
        Thought thought = new Thought();
        thought.setDescription(this.future.getDescription());
        thought.setTopic(this.future.getTopic());
        thought.setNotes(this.future.getNotes());
        data.getThoughtManager().insert((Observable)thought, 0);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        ProcessThoughtsAction pta = (ProcessThoughtsAction)SystemAction.get(ProcessThoughtsAction.class);
        pta.performAction();
    }
}

