/*
 * Decompiled with CFR 0.152.
 */
package tr.view.future;

import au.com.thinkingrock.tr.resource.Icons;
import java.awt.Frame;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;
import tr.model.future.Future;
import tr.view.future.FutureDeleteCookie;

public class FutureDeleteAction
extends CookieAction {
    public FutureDeleteAction() {
        this.setIcon(Icons.SomedayMaybeDelete);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_FutureDeleteAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Class[] cookieClasses() {
        return new Class[]{Future.class};
    }

    public int mode() {
        return 4;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        String title = "Confirm Deletion";
        String message = nodes.length == 1 ? "Are you sure you want to delete someday/maybe item: \n" + nodes[0].getName() + "?\n" : "Are you sure you want to delete " + nodes.length + " someday/maybe items?";
        Frame p = WindowManager.getDefault().getMainWindow();
        int opt = JOptionPane.showConfirmDialog(p, message, title, 0);
        if (opt != 0) {
            return;
        }
        for (Node node : nodes) {
            FutureDeleteCookie cookie = (FutureDeleteCookie)node.getCookie(FutureDeleteCookie.class);
            if (cookie == null) continue;
            cookie.deleteFuture();
        }
    }
}

