/*
 * Decompiled with CFR 0.152.
 */
package tr.view.topics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CookieAction;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.topic.Topic;
import tr.model.topic.TopicChangeCookie;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;

public class TopicChangeAction
extends CookieAction {
    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ChangeTopicAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Class[] cookieClasses() {
        return new Class[]{TopicChangeCookie.class};
    }

    public int mode() {
        return 7;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodes) {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Frame frame = WindowManager.getDefault().getMainWindow();
        final JDialog jd = new JDialog(frame, this.getName(), true);
        TopicsComboBox cb = new TopicsComboBox((ComboBoxModel)new TopicsComboBoxModel(false));
        cb.setSelectedIndex(0);
        JPanel panel = new JPanel();
        panel.add(new JLabel(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"LBL_NewTopic")));
        panel.add(cb);
        JOptionPane op = new JOptionPane(panel, 1, 2, null, null, null);
        op.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                jd.dispose();
            }
        });
        jd.getContentPane().add((Component)op, "Center");
        jd.setDefaultCloseOperation(2);
        jd.pack();
        Rectangle r = Utilities.findCenterBounds((Dimension)jd.getSize());
        jd.setLocation(r.x, r.y);
        jd.setVisible(true);
        Object value = op.getValue();
        if (value instanceof Integer && (Integer)value == 0) {
            this.change((Topic)cb.getSelectedItem(), nodes);
        }
    }

    private void change(Topic topic, Node[] nodes) {
        if (topic == null) {
            return;
        }
        if (nodes == null) {
            return;
        }
        for (Node node : nodes) {
            TopicChangeCookie cookie = (TopicChangeCookie)node.getCookie(TopicChangeCookie.class);
            if (cookie == null) continue;
            cookie.setTopic(topic);
        }
    }
}

