/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: totd.c,v 3.25 2000/09/28 11:52:35 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: totd.c,v 3.25 2000/09/28 11:52:35 dillema Exp $");

struct ToT T;
char *version = "Trick or Treat Daemon (totd) version 1.2";

void usage (int exitcode)
{
	printf ("%s\n\
Usage: totd [-6|-no6|-4|-no4|-64|-dn]\n\
\n\
-[no]6    : enable[disable] IPv6 service functionality\n\
-[no]4    : enable[disable] IPv4 service functionality\n\
-64       : alias to -6 -4\n\
-dn       : debug mode (no fork / loglevel = n)\n\
\n\
default   : IPv6 is %s and IPv4 is %s%s\n\n\
totd %s use IPv6 because it was compiled %s USE_INET6 option in config.h\n\
totd %s use IPv4 because it was compiled %s USE_INET4 option in config.h\n",
		version,
		(T.ip6) ? "enabled" : "disabled",
		(T.ip4) ? "enabled" : "disabled",
		(T.debug > 0) ? ", debug mode" : "", 
		(V4 (1) + 0) ? "can" : "can not",
		(V4 (1) + 0) ? "with" : "without",
		(V6 (1) + 0) ? "can" : "can not",
		(V6 (1) + 0) ? "with" : "without"
	);

	exit (exitcode);
}

int main (int argc, char **argv) {
	int i;

	/* get UID of tot and use it if applicable */
#ifdef TOT_USER
	{
		struct passwd *pwd_p;
		if ((pwd_p = getpwnam (TOT_USER)) == NULL) {
			syslog (LOG_ERR, "can't find user record of %s\n", TOT_USER);
			perror ("getpwnam");
			exit (-1);
		} else {
			T.tot_uid = pwd_p->pw_uid;
			T.tot_gid = pwd_p->pw_gid;
			T.su = 0;
			syslog (LOG_INFO, "Found user record of %s; uid: %d gid: %d\n",
				TOT_USER, T.tot_uid, T.tot_gid);
		}
	}
#else				/* !TOT_USER */
	T.tot_uid = 0;
	T.tot_gid = 0;
	T.su = 1;
#endif				/* TOT_USER */

	/* initialize global */
	T.progname = argv[0];
	T.argv = argv;
	T.argc = argc;
	T.ip4 = V4 (1) + 0;	/* bit ugly, but short */
	T.ip6 = V6 (1) + 0;
	T.debug = 0;
	T.prefixnum = 0;
	T.stf = 0;
	T.retry_interval = 300;
	T.Fwd_list = NULL;
	T.current_fwd = NULL;
	/* make sure these start out empty */
	for (i = 0; i < MAXPREFIXES; i++) {
		*T.tot_prefix[i] = '\0';
	}

#ifdef TOT_PID_FILE
	{
		FILE *pid_fp;
		pid_t pid;

		/* check if pid file exists */
		if ((pid_fp = fopen (TOT_PID_FILE, "r")) != NULL) {
			if (fscanf (pid_fp, "%d", &pid) != 1) {
				syslog (LOG_ERR, "totd: removing bogus lockfile\n");
				unlink (TOT_PID_FILE);
			} else if (kill (pid, 0) == -1) {
				syslog (LOG_ERR, "totd: removing stale lockfile\n");
				unlink (TOT_PID_FILE);
			} else {
				fprintf (stderr, "PID file %s already exists.\n", TOT_PID_FILE);
				fprintf (stderr, "\
There can be another tot server. Please make sure\n\
there's no tot server present, first. Then delete the\n\
file and restart the server.\n");
				exit (1);
			}
			fclose (pid_fp);
		}
	}
#endif


	for (i = 1; i < argc; i++) {
		if (!strncmp (argv[i], "-d", 2) ) {
			/* debug option */
			T.debug = atoi(&argv[i][2]);
			printf ("debug level %d enabled.\n", T.debug);
#ifdef NDEBUG
			if (T.debug > 1) {
				printf ("NDEBUG was defined at compile time, so not much more debug info available.\n");
				printf ("Comment NDEBUG in config.h and recompile to enable verbose debugging.\n");
			}
#endif
		} else if (!strcmp (argv[i], "-6"))
			T.ip6 = 1;
		else if (!strcmp (argv[i], "-4"))
			T.ip4 = 1;
		else if (!strcmp (argv[i], "-46") || !strcmp (argv[i], "-64"))
			T.ip4 = 1, T.ip6 = 1;
		else if (!strcmp (argv[i], "-no4"))
			T.ip4 = 0;
		else if (!strcmp (argv[i], "-no6"))
			T.ip6 = 0;
		else if (!strcmp (argv[i], "-p")) {
			T.prefixnum = 1;
			if (conv_trick_conf(argv[++i])) {
			    syslog (LOG_ERR, "invalid prefix on command line: %s\n", argv[++i]);
			    usage(1);
			}
		}
		else if (!strcmp (argv[i], "-v"))
			usage (1);
		else {
			fprintf (stderr, "unknown option %s\n", argv[i]);
			usage (1);
		}
	}

	if (getuid () != 0) {
		fprintf (stderr, "You must be ROOT to run tot.\n");
		exit (-1);
	}
	if (T.debug > 0)
	    openlog("totd", LOG_PID | LOG_NDELAY | LOG_CONS | LOG_PERROR, LOG_DAEMON);
	else
	    openlog ("totd", LOG_PID | LOG_NDELAY | LOG_CONS, LOG_DAEMON);
	syslog (LOG_NOTICE, "%s", version);
	setlogmask (LOG_UPTO (LOG_NOTICE));

	if (T.debug > 1)
		setlogmask (LOG_UPTO (LOG_DEBUG));

	/*
	 * Let's do some sanity checking now
	 */
	if (T.ip4) {
#ifdef USE_INET4
		syslog (LOG_INFO, "IPv4 activated\n");
#else
		fprintf (stderr, "IPv4 is not included.\n\
You can re-compile with USE_INET4 option in config.h\n");
		exit (1);
#endif
	}
	if (T.ip6) {
#ifdef USE_INET6
		syslog (LOG_INFO, "IPv6 activated\n");
#else
		fprintf (stderr, "IPv6 support is not included.\n\
You can re-compile with USE_INET6 option in config.h\n");
		exit (1);
#endif
	}
	/* error correction */
	if (!T.ip4 && !T.ip6) {
		fprintf (stderr, "all protocols are deactivated.\n\
No reason to continue.\n");
		exit (1);
	}

	fwd_init ();
	if (read_config (TOT_CONFIG_FILE)) {
	    fprintf (stderr, "Totd terminated after config failure.\n\
Check syslog, or try -d option for debug mode...\n");
	    exit(-1);
	}

	if (!T.debug) {
		/* purge tty */

		if (fork () != 0) {
			exit (0);	/* go background */
		}
		close (0);
		close (1);
		close (2);
		open ("/dev/null", O_RDONLY);
		dup2 (0, 1);
		dup2 (0, 2);
		if ((i = open ("/dev/tty", O_RDWR)) >= 0) {
			ioctl (i, TIOCNOTTY, (char *) 0);
			close (i);
		}
	}
	/* write pid file */
	if (TOT_PID_FILE != NULL) {
		FILE *pid_fp;
		if ((pid_fp = fopen (TOT_PID_FILE, "w")) == NULL) {
			fprintf (stderr, "can't open pid file.\n");
			exit (-1);
		}
		fprintf (pid_fp, "%d\n", getpid ());
		fclose (pid_fp);
	}

	ev_main (PORT_SRV);
	exit (0);
}

void tot_exit (int status) {

	ROOTPRIV_ENABLE ("exit");

	/* finish in reverse order of initialize */
	ev_tcp_out_finish ();
	ev_udp_in_finish ();
	ev_tcp_conn_in_finish ();
	/* ev_tcp_srv_in_finish() -- no such func */
	ev_to_finish ();
	ev_signal_finish ();
	fwd_finish ();

	if (TOT_PID_FILE)
		unlink (TOT_PID_FILE);

	ROOTPRIV_DISABLE ("exit");
	setlogmask (LOG_UPTO (LOG_INFO));
	syslog (LOG_INFO, "terminated.%s euid = %d", (T.su) ? " (in su mode)" : "", geteuid ());

	exit (status);
}
