/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: list.c,v 3.10 2000/09/06 20:28:37 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: list.c,v 3.10 2000/09/06 20:28:37 dillema Exp $");

G_List *list_init (void) {
	G_List *gl_new = NULL;

	gl_new = malloc (sizeof (G_List));
	if (gl_new) {
		gl_new->next = gl_new;
		gl_new->prev = gl_new;
		gl_new->list_data = NULL;
	}
	else
		syslog (EM_F (EM_F_MEMEX), "list_init");

	return gl_new;
}

int list_add (G_List *gl_head, void *list_data) {
	G_List *gl_new;

	gl_new = malloc (sizeof (G_List));
	if (gl_new) {
		gl_new->list_data = list_data;
		gl_new->next = gl_head->next;
		gl_new->prev = gl_head;
		gl_head->next->prev = gl_new;
		gl_head->next = gl_new;
		/* SUCCESS */
		return 0;
	}
	else
		syslog (EM_F (EM_F_MEMEX), "list_init");

	/* FAILURE */
	return -1;
}

int list_add_tail (G_List *gl_head, void *list_data) {
	G_List *gl_new;

	gl_new = malloc (sizeof (G_List));
	if (gl_new) {
		gl_new->list_data = list_data;
		gl_new->next = gl_head;
		gl_new->prev = gl_head->prev;
		gl_head->prev->next = gl_new;
		gl_head->prev = gl_new;
		/* SUCCESS */
		return 0;
	}
	else
		syslog (EM_F (EM_F_MEMEX), "list_init");

	/* FAILURE */
	return -1;
}

G_List *list_search (G_List *list_head, void *comp_data, int (*comp_func) (void *, void *)) {
	G_List *gl_tmp;

	list_head->list_data = comp_data;
	for (gl_tmp = list_head->next; (*comp_func) (comp_data, gl_tmp->list_data); gl_tmp = gl_tmp->next);

	list_head->list_data = NULL;
	if (gl_tmp == list_head)
		return NULL;
	else 
		return gl_tmp;
}

void *list_delete (G_List *gl) {
	void *p;

	gl->next->prev = gl->prev;
	gl->prev->next = gl->next;

	p = gl->list_data;
	free (gl);

	return p;
}

void list_destroy (G_List *gl, void (*freefnc) (void *)) {

	G_List *gl_tmp;
	G_List *gl_next;

	if (!gl)
		return;

	for (gl_tmp = gl->next; gl_tmp != gl; gl_tmp = gl_next) {
		gl_next = gl_tmp->next;
		if (gl_tmp->list_data)
			(*freefnc) (gl_tmp->list_data);

		free (gl_tmp);
	}

	/* head record */
	free (gl);

	return;
}


G_List *list_dup (G_List *gl, void (freefunc) (void *), void *(dupfunc) (void *)) {
	G_List *gl_new;
	G_List *gl_tmp;
	void *p;

	gl_new = list_init ();
	if (!gl_new)
		return NULL;

	gl->list_data = NULL;
	for (gl_tmp = gl->next; gl_tmp->list_data != NULL; gl_tmp = gl_tmp->next) {
		p = (*dupfunc) (gl_tmp->list_data);
		if (!p) {
			list_destroy (gl_new, freefunc);
			return NULL;
		}
		if (list_add (gl_new, p) < 0) {
			list_destroy (gl_new, freefunc);
			return NULL;
		}
	}

	return gl_new;
}

void list_cat (G_List *list, G_List *toadd) {

	toadd->list_data = NULL;
	if (toadd->next->list_data) {
		toadd->prev->next = list->next->prev;
		list->next->prev = toadd->prev;
		list->next = toadd->next;
		toadd->next->prev = list;
		toadd->prev = toadd;
		toadd->next = toadd;
	}
}

void list_move_f (G_List *to, G_List *from, void (*freefnc) (void *)) {

	if (to && freefnc)
		list_destroy (to, freefnc);

	to = from;
	from = NULL;
}
