/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ev_signal.c,v 3.11 2000/09/06 20:28:36 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: ev_signal.c,v 3.11 2000/09/06 20:28:36 dillema Exp $");

static void ev_signal_initiator_generic (int sig);
static void ev_handler_sigusr1 (void);
static void ev_handler_sigusr2 (void);
static void ev_handler_cleanup (void);

/* event initiator (== signal handler) matrix */
const struct {
	int signal_id;		/* signal id */
	void (*initiator) (int);/* event initiator */
	void (*handler) (void);	/* event handler */
}   Ev_matrix[] = {
	{
		SIGINT, ev_signal_initiator_generic, ev_handler_cleanup
	},
	{
		SIGHUP, ev_signal_initiator_generic, ev_handler_cleanup
	},
	{
		SIGTERM, ev_signal_initiator_generic, ev_handler_cleanup
	},
	{
		SIGUSR1, ev_signal_initiator_generic, ev_handler_sigusr1
	},
	{
		SIGUSR2, ev_signal_initiator_generic, ev_handler_sigusr2
	},
	{
		-1, NULL, NULL
	}			/* <- terminator -- don't forget */
};

/* signal event queue */
static Q_Set *Ev_signal_queue = NULL;

/*
 * (private) generic event initiator(== signal handler)
 */
static void ev_signal_initiator_generic (int sig) {
	int i;
	Ev_Sig_Data *sd_tmp;

	if (T.debug > 2) {
		DX (syslog (LOG_DEBUG, "ev_signal_initiator_generic(): start.\n"));
	}

	if (Ev_signal_queue == NULL) {
		syslog (LOG_ERR, "ev_signal_initiator_generic(): no queue to process.\n");
		return;
	}
	for (i = 0; Ev_matrix[i].signal_id > 0 && Ev_matrix[i].signal_id != sig; i++);

	if ((sd_tmp = malloc (sizeof (Ev_Sig_Data))) == NULL) {
		syslog (LOG_WARNING, "ev_signal_initiator_generic(): memory exhausted\n");
		return;
	}
	sd_tmp->handler = Ev_matrix[i].handler;

	if (enqueue (Ev_signal_queue, (void *) sd_tmp) < -1) {
		syslog (LOG_WARNING, "ev_signal_initiator_generic(): signal queue full?\n");
	}
	return;
}

/*
 * event handlers
 */
void ev_handler_sigusr1 (void) {
	syslog (LOG_INFO, "ev_handler_sigusr1(): processing SIGUSR1\n");
}

void ev_handler_sigusr2 (void) {
	syslog (LOG_INFO, "ev_handler_sigusr2(): processing SIGUSR2\n");
}

void ev_handler_cleanup (void) {
	tot_exit (0);
}

/* == end of private section == */

/*
 * event initializer
 */
int ev_signal_init (void) {
	int i;

	/* set event initiator */
	for (i = 0; Ev_matrix[i].signal_id > 0; i++)
		signal (Ev_matrix[i].signal_id, Ev_matrix[i].initiator);

	/* initialize queue */
	if ((Ev_signal_queue = queue_create ()) == NULL)
		return -1;

	return 0;
}


/*
 * event dequeue/process
 */
void ev_signal_process (void) {
	Ev_Sig_Data *sd_tmp;

	if (Ev_signal_queue)
		while ((sd_tmp = (Ev_Sig_Data *) dequeue (Ev_signal_queue)) != NULL) {
			(sd_tmp->handler) ();	/* process event */
			free (sd_tmp);
		}
	else
		syslog (LOG_ERR, "ev_signal_process(): no queue to process.\n");
}

/*
 * finish signal routine
 */
void ev_signal_finish (void) {
	/* don't process signal. It may cause event loop */
	queue_destroy (Ev_signal_queue, free);
	Ev_signal_queue = NULL;
}
