/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: context.c,v 3.16 2000/12/13 21:29:25 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: context.c,v 3.16 2000/12/13 21:29:25 dillema Exp $");

int context_timeout_handler (Ev_TO_Data * td) {

	if (td->type != EV_TIMEOUT_CONTEXT)
		return -1;

	td->data.cont->tout = NULL;
	return td->data.cont->retry (td->data.cont);	/* call retry routine */
}

int context_timeout_register (Context * cont, int timeout) {
	const char *fn = "context_timeout_register()";
	Ev_TO_Data *edtp;

	if (T.debug > 2) {
		DX (syslog (LOG_DEBUG, "%s: start\n", fn));
	}

	if (cont->tout && cont->tout->handler)
		syslog (LOG_INFO, "%s: duplicated timeout registration. ignore.\n", fn);
	else {
		edtp = malloc (sizeof (Ev_TO_Data));
		if (!edtp) 
			syslog (EM_F (EM_F_MEMEX), fn);
		else {
			edtp->at = time (NULL) + timeout;
			edtp->handler = context_timeout_handler;
			edtp->type = EV_TIMEOUT_CONTEXT;
			edtp->data.cont = cont;
			if (ev_to_register (edtp) < 0)
				free (edtp);
			else {
				cont->tout = edtp;
				if (T.debug > 2) {
					DX (syslog (LOG_DEBUG, "%s: scheduled in %d", fn, (int) edtp->at));
				}
				/* SUCCESS */
				return 0;
			}
		}
	}

	/* FAILURE */
	return (-1);
}

Context *context_create (int context_type) {
	const char *fn = "context_create()";
	Context *cont;

        cont = malloc (sizeof (Context));
        if (cont) {
        	memset (cont, 0, sizeof (Context));

		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "context_create: %p", (void *) cont));
		}

	        cont->type = context_type;

		cont->ns = NULL;
        	cont->qname = malloc (MAX_DNAME);
        	memset (cont->qname, 0, MAX_DNAME);
        	cont->an_list = list_init ();
        	cont->ns_list = list_init ();
        	cont->ar_list = list_init ();

        	if (cont->an_list && cont->ns_list && cont->ar_list && cont->qname) {
			switch (cont->type) {
			case CTYPE_TCP_REQUEST:
        			cont->param.request = malloc (sizeof (Cos_Request));
        			if (cont->param.request) {
        				memset (cont->param.request, 0, sizeof (Cos_Request));
					return cont;
				}
				break;
			case CTYPE_UDP_REQUEST:
        			cont->param.request = malloc (sizeof (Cos_Request));
        			if (cont->param.request) {
        				memset (cont->param.request, 0, sizeof (Cos_Request));
					cont->param.request->sa = malloc (sizeof (struct sockaddr_storage));
        				if (cont->param.request->sa) {
        					memset (cont->param.request->sa, 0, sizeof (struct sockaddr_storage));
						return cont;
					}
				}
				break;
                	case CTYPE_UDP_RESPONSE:
			        cont->param.u_res = malloc (sizeof (Cos_UDP_Response));
        			if (cont->param.u_res) {
        				memset (cont->param.u_res, 0, sizeof (Cos_UDP_Response));
			        	cont->param.u_res->sa_p = malloc (sizeof (struct sockaddr_storage));
        				if (cont->param.u_res->sa_p) {
        					memset (cont->param.u_res->sa_p, 0, sizeof (struct sockaddr_storage));
						return cont;
					}
				}
                      	  	break;
                	case CTYPE_TCP_RESPONSE:
			        cont->param.t_res = malloc (sizeof (Cos_TCP_Response));
        			if (cont->param.t_res) {
        				memset (cont->param.t_res, 0, sizeof (Cos_TCP_Response));
			        	cont->param.t_res->sa_p = malloc (sizeof (struct sockaddr_storage));
        				if (cont->param.t_res->sa_p) {
        					memset (cont->param.t_res->sa_p, 0, sizeof (struct sockaddr_storage));
						return cont;
					}
				}
                        	break;
                	default:
				if (T.debug > 1) {
                       			DX(syslog (LOG_DEBUG, "unknown context type %d on %s()", cont->type, fn));
				}
				return NULL;
			}
		}

        }

	/* FAILURE */
        syslog (EM_F (EM_F_MEMEX), fn);
	return NULL;
}

void context_destroy (Context * cont) {
	const char *fn = "context_destroy()";

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: %p", fn, (void *) cont));
	}

	if (cont) {
		if (cont->parent)
			cont->parent->child = NULL;
		if (cont->child)
			cont->child->parent = NULL;
		if (cont->qname)
			free (cont->qname);

		if (cont->an_list)
			list_destroy (cont->an_list, rrset_freev);
		if (cont->ns_list)
			list_destroy (cont->ns_list, rrset_freev);
		if (cont->ar_list)
			list_destroy (cont->ar_list, rrset_freev);

		if (cont->mesg.p)
			free (cont->mesg.p);
		if (cont->tout)
			cont->tout->handler = NULL;

		switch (cont->type) {
		case CTYPE_TCP_REQUEST:
       	         	if (cont->param.request) {
                        	if (cont->param.request->conn_sock >= 0) {
                                	shutdown (cont->param.request->conn_sock, SHUT_RDWR);
                                	close (cont->param.request->conn_sock);
                                	switch (cont->current_state) {
                                	case COS_TCP_REQUEST_START:
                                	case COS_TCP_REQUEST_WAIT_CONNECT:
                                	case COS_TCP_REQUEST_WRITING:
                                        	ev_tcp_out_remove (cont->param.request->conn_sock);
                                        	break;
                                	case COS_TCP_REQUEST_READLEN:
                                	case COS_TCP_REQUEST_READING:
                                        	ev_tcp_conn_in_remove (cont->param.request->conn_sock);
                                        	break;
                                	default:
                                        	syslog (LOG_ERR, "unknown state on destruction.");
                                        	break;
                                	}       /* switch */
                                	free (cont->param.request);
                        	}       /* if(...conn_sock > 0) */
                	}               /* if(param.request) */
			break;
		case CTYPE_UDP_REQUEST:
       	        	if (cont->param.request) {
                        	if (cont->param.request->sa && cont->param.request->sa->sa_family)
                                	ev_udp_in_remove (cont->param.request->sa, cont->q_id);
                        	if (cont->param.request->sa)
                               		free (cont->param.request->sa);
                        	free (cont->param.request);
                	}
			break;
		case CTYPE_UDP_RESPONSE:
                	if (cont->param.u_res) {
                        	ev_udp_in_remove (cont->param.u_res->sa_p, cont->q_id);
                        	if (cont->param.u_res->sa_p)
                                	free (cont->param.u_res->sa_p);
                        	if (cont->param.u_res->inif)
                                	ni_free (cont->param.u_res->inif, 0);
                        	free (cont->param.u_res);
                	}
			break;
		case CTYPE_TCP_RESPONSE:
                	if (cont->param.t_res) {
                        	if (cont->param.t_res->sa_p) {
                                	free (cont->param.t_res->sa_p);
                                	cont->param.t_res->sa_p = NULL;
                        	}
                        	if (cont->param.t_res->conn_sock >= 0) {
                                	shutdown (cont->param.t_res->conn_sock, 2);
                                	close (cont->param.t_res->conn_sock);

                                	switch (cont->current_state) {
                                	case COS_TCP_RESPONSE_READLEN:
                                	case COS_TCP_RESPONSE_READING:
                                	case COS_TCP_RESPONSE_WAITING_CLIENT_CLOSE:
                                        	ev_tcp_conn_in_remove (cont->param.t_res->conn_sock);
                                        	break;
                                	case COS_TCP_RESPONSE_WAITING_RECURSIVE:
                                        	/* no registered input should exist...  */
                                        	break;
                                	case COS_TCP_RESPONSE_WRITING:
                                        	ev_tcp_out_remove (cont->param.t_res->conn_sock);
                                       	 	break;
                                	default:
                                        	syslog (LOG_ERR, "%s: unknown stat to destroy.\n", fn);
                                        	break;
                                	}       /* switch */
                        	}       /* if(...conn_sock >= 0) */
                        	free (cont->param.t_res);
                	}               /* if(t_res) */
			break;
		default:
			syslog (LOG_WARNING, "unknown context type %d on context_destroy()",
				cont->type);
			break;
		}

		free (cont);
	}
}
