/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_udp_request.c,v 3.24 2000/12/13 21:29:25 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_udp_request.c,v 3.24 2000/12/13 21:29:25 dillema Exp $");

int cos_udp_request_start (struct context *parent, u_char *qname,
		           int qname_len, u_int16_t r_class, 	
			   u_int16_t r_type, struct sockaddr *sa) {
	char *fn = "cos_udp_request_start()";
	Context *cont;
	int timeout;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* create new context */
	cont = context_create(CTYPE_UDP_REQUEST);
	if (!cont)
		return (cos_udp_request_abort (cont, -1));

	cont->parent = parent;
	cont->parent->child = cont;
	cont->current_state = COS_UDP_REQUEST_START;
	cont->param.request->timeout = SEARCH_REMOTE_TIMEOUT;
        memcpy (cont->param.request->sa, sa, SOCKADDR_SIZEOF(*sa));
	memcpy (cont->qname, qname, qname_len);
	cont->qname_len = qname_len;
	cont->q_class = r_class;
	cont->q_type = r_type;
	cont->q_id = mesg_id ();
	cont->process = cos_udp_request_sended_process;
	cont->retry = cos_udp_request_sended_retry;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: constructing query.\n", fn));
	}

	cont->mesg.p = malloc (MAX_PACKET);
	if (!cont->mesg.p) {
                syslog (EM_F (EM_F_MEMEX), fn);
		return (cos_udp_request_abort (cont, -1));
	}
	cont->wp = cont->mesg.p;
	cont->mesg_len = mesg_make_query (qname, r_type, r_class, cont->q_id,
					  1, cont->mesg.p, MAX_PACKET);
	if (cont->mesg_len < 0) {
		syslog (LOG_WARNING, "%s: cannot make query within a UDP datagram.", fn);
		return (cos_udp_request_abort (cont, 1)); /* try TCP instead? */
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: send query to selected forwarder.\n", fn));
	}

	timeout = 0;
	if (net_mesg_send (NULL, cont->mesg.p, cont->mesg_len, sa) < 0) {
		syslog (LOG_NOTICE, "%s: send failed: %m\n", fn);

		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: force retry at zero timeout", fn));
		}
	} else {
		/* put me to input list */
		if (ev_udp_in_register (cont, sa, SOCKADDR_SIZEOF (*sa), cont->q_id) < 0)
			return (cos_udp_request_abort (cont, -1));

		if (T.debug > 0) 
			DX (syslog (LOG_DEBUG, "Query will time out in %d seconds.\n", cont->param.request->timeout));
		
		timeout = cont->param.request->timeout;
	}

	/* put me on timeout event queue */
	if (context_timeout_register (cont, cont->param.request->timeout) < 0) 
		return (cos_udp_request_abort (cont, -1));

	/* change state to sended */
	cont->current_state = COS_UDP_REQUEST_SENDED;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: end", fn));
	}

	/* SUCCESS */
	return 0;
}

int cos_udp_request_sended_process (Context * cont) {
	DX (char *fn = "cos_udp_request_sended_process()";)

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* don't renew timeout, it automatically finish */
	if (cont->tout)
		cont->tout->handler = NULL;

	/* remove me from I/O list */
	if (ev_udp_in_remove (cont->param.request->sa, cont->q_id) < 0) {
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: end with error", fn));
		}
		return (cos_udp_request_abort (cont, -1));
	}
	else {
		/* no read -- assume ev_udp_in already put it in cont->mesg.p */

		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: end by calling request_finish", fn));
		}
		return cos_udp_request_finish (cont);
	}
}

int cos_udp_request_sended_retry (Context * cont) {
	DX (char *fn = "cos_udp_request_sended_retry()";)
	struct sockaddr *sa;
	int status, len, sa_len;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* remove old I/O List */
	status = ev_udp_in_remove (cont->param.request->sa, cont->q_id);
	if (status < 0)
		goto error;

	cont->param.request->retry++;
	cont->param.request->timeout = cont->param.request->timeout * 2;
	if (cont->param.request->retry >= SEARCH_REMOTE_RETRY) {
	    /* pick another forwarder, if no backup keep on trying for while but not to long */
	    if (fwd_select_next() && cont->param.request->retry < SEARCH_REMOTE_RETRY*2) {
		syslog (LOG_INFO, "Retry limit exceeded, and out of backup forwarders.");
		status = 1;
		goto error;
	    }
	    /* Note that we keep timout time high, even when we switched to backup */
	}

	if (T.debug > 0) {
	    DX (syslog (LOG_DEBUG, "Retry %d of %d+%d will time out in %d seconds.\n", cont->param.request->retry + 1, 
		     SEARCH_REMOTE_RETRY, SEARCH_REMOTE_RETRY, cont->param.request->timeout));
	}

	status = 0;
	do {
	        sa = ((Fwd *) T.current_fwd->list_data)->sa;
	        sa_len = ((Fwd *) T.current_fwd->list_data)->sa_len;
		if (!sa) {
			status = -1;
			goto error;
		}

		memcpy (cont->param.request->sa, sa, sa_len);

		status = 0;	/* important to avoid infinite loop */
		/* retry sending */
		len = net_mesg_send (NULL, cont->mesg.p, cont->mesg_len, cont->param.request->sa);
		if (len < cont->mesg_len) {
			if (len < 0)
				syslog (LOG_NOTICE, "retry failed(default socket): %m");
			else
				syslog (LOG_NOTICE, "can't send detagram.");
			status = -1;
		}
	} while (status != 0);

	/* put me to input list */
	status = ev_udp_in_register (cont, cont->param.request->sa,
				     SOCKADDR_SIZEOF (*(cont->param.request->sa)),
				     cont->q_id);
	if (status < 0)
		goto error;

	/* put me to timeout list */
	if (context_timeout_register (cont, cont->param.request->timeout) < 0) {
		status = -1;
		goto error;
	}
	/* no state change... */

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: end", fn));
	}
	return 0;

	/* NOTREACHED */

error:
	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: error %d", fn, status));
	}
	return (cos_udp_request_abort (cont, status));
}


int cos_udp_request_abort (Context *cont, int status) {

	/*
	 * if parent exists, and the process is started successfully, process
	 * parent
	 */
	if (cont && cont->current_state != COS_UDP_REQUEST_START && cont->parent) {
		cont->parent->child = NULL;	/* means child failed */
		cont->parent->process (cont->parent);
		/* parent cleaned itself up at this point */
		cont->parent = NULL;
	}
	/* finally cleanup the child itself */
	context_destroy (cont);
	return status;
}

int cos_udp_request_finish (Context * cont) {
	char *fn = "cos_udp_request_finish()";

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* parse answers */

	list_destroy (cont->an_list, rrset_freev);
	list_destroy (cont->ns_list, rrset_freev);
	list_destroy (cont->ar_list, rrset_freev);
	cont->an_list = list_init ();
	cont->ns_list = list_init ();
	cont->ar_list = list_init ();
	if (!cont->an_list || !cont->ns_list || !cont->ar_list) {
		syslog (LOG_ERR, "%s: can't recreate lists for parse answer data.", fn);
		return(cos_udp_request_abort (cont, -1));
	}

	if (mesg_parse (cont->mesg.p, cont->mesg_len, cont->an_list,
			     cont->ns_list, cont->ar_list)) {
		syslog (LOG_WARNING, "%s: can't parse answer data.", fn);
		return (cos_udp_request_abort (cont, -1));
	}

	/* if parent exists (it should always), process parent */
	if (cont->parent) {
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: process parent context", fn));
		}
		cont->parent->process (cont->parent);
	}

	context_destroy (cont);
	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: return success", fn));
	}
	return 0; /* we're happy */
}
