/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_tcp_response.c,v 3.25 2001/03/13 11:14:43 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_tcp_response.c,v 3.25 2001/03/13 11:14:43 dillema Exp $");

int cos_tcp_response_start (int sock, struct sockaddr *sa_p, int sa_len) {
	const char *fn = "cos_tcp_response_start()";
	Context *cont;	/* alloc'ed */

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	cont = context_create(CTYPE_TCP_RESPONSE);
	if (cont) {
		cont->current_state = COS_TCP_RESPONSE_READLEN;
		cont->process = cos_tcp_response_readlen_process;
		cont->retry = cos_tcp_response_readlen_retry;
		memcpy (cont->param.t_res->sa_p, sa_p, sa_len);
		cont->param.t_res->sa_len = sa_len;

		cont->param.t_res->conn_sock = sock;
		cont->param.t_res->timeout = COS_TCP_SRV_TIMEOUT;	/* good value? */

		if (!context_timeout_register (cont, cont->param.t_res->timeout)) {
			if (!ev_tcp_conn_in_register (cont->param.t_res->conn_sock, cont)) {
				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: return", fn));
				}
				/* SUCCESS */
				return 0;
			}
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: abort", fn));
	}

	/* FAILURE */
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_sub_assemble (Context * cont) {
	const char *fn = "cos_tcp_sub_assemble()";
	int len;
	u_char *ucp, *qname;
	u_int16_t us;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	if (cont->an_list && cont->ns_list && cont->ar_list) {
		/* question section */
		ucp = qname = cont->mesg.p + sizeof (Mesg_Hdr);
		ucp = mesg_skip_dname(ucp, cont->mesg.p + cont->mesg_len);
		GETSHORT (us, ucp);

		if (us == RT_AAAA && cont->q_type == RT_A) {
			conv_trick_list (cont->an_list);
			conv_trick_list (cont->ns_list);
			conv_trick_list (cont->ar_list);
		        T.current_prefix = (T.current_prefix + 1) % T.prefixnum; /* circulate through prefixes */
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: query for AAAA changed into query for A", fn));
			}
		}
		else if (us == RT_A6 && cont->q_type == RT_A) {
			conv_trick_list_a6(cont->an_list);
			conv_trick_list_a6(cont->ns_list);
			conv_trick_list_a6(cont->ar_list);
			/* circulate through prefixes */
                        T.current_prefix =
				(T.current_prefix + 1) % T.prefixnum;
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: query for A6 changed into query for A", fn));
			}
		}
		else if (us == RT_PTR && conv_trick_is_tot_ptr (qname)) {
			conv_trick_ptr (cont->an_list, qname);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: converted PTR response", fn));
			}
		}
		else if (us == RT_MX) {
			/* rewrite the additional section (if necessary) */
			conv_trick_list(cont->ar_list);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: converted MX response", fn));
			}
			/* circulate through prefixes */
			T.current_prefix =
				(T.current_prefix + 1) % T.prefixnum;
		}
#ifdef SCOPED_REWRITE
                else if (us == RT_AAAA && T.scoped_prefixes &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
                        conv_scoped_list(cont->an_list);
                        conv_scoped_list(cont->ns_list);
                        conv_scoped_list(cont->ar_list);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: checked whether to rewrite global into scoped address", fn));
			}
                }
		else if (us == RT_PTR && conv_is_scoped_ptr(qname, 1) != -1 &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
			conv_scoped_ptr(cont->an_list, qname);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: converted query name: %s", fn, qname));
			}
		}
#endif /* SCOPED_REWRITE */
#ifdef STF
		else if (T.stf && cont->child->q_type == RT_NS && us == RT_NS && conv_stf_is_stf_ptr (qname)) {
			/* 
		  	 * If the original request was for a nameserver record, the 
		 	 * query-name was a 6to4 address, and finally what we got 
		 	 * here in response is a nameserver record for the
		 	 * corresponding IPv4 address instead, then we transform it
		 	 * into a nameserver pseudo-record here for the 6to4 address.
		 	 * This pseudo-record is marked non-authorative. 
			*/

			/* mark non-authorative */
			cont->child->mesg.hdr->aa = 0;
			conv_stf_ns_list(cont->an_list);
			conv_stf_ns_list(cont->ns_list);
			conv_stf_ns_list(cont->ar_list);
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: Converted NS record for 6to4 NS query: %s", fn, qname));
			}
		}
#endif /* STF */
		len = mesg_assemble (cont->mesg.hdr, cont->an_list, cont->ns_list,
			   cont->ar_list, Cos_TCP_Buf, sizeof (Cos_TCP_Buf), cont->mesg_len);
		if (len < 0) 
			syslog (LOG_WARNING, "failed to make up message(TCP response)");
		else {
			/* free old buffer */
			if (cont->mesg.p)
				free (cont->mesg.p);

			/* allocate a new properly sized one */
			cont->mesg.p = malloc (len);
			if (cont->mesg.p) {
				memcpy (cont->mesg.p, Cos_TCP_Buf, len);
				cont->mesg_len = len;
				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: return", fn));
				}
				/* SUCCESS */
				return (cont->mesg_len);
			} else
				syslog (EM_F (EM_F_MEMEX), fn);
		}
	} else {
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: return", fn));
		}
		/* SUCCESS */
		return (cont->mesg_len);
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: fail", fn));
	}
	/* FAILURE */
	return (-1);

}

int cos_tcp_response_readlen_process (Context *cont) {
	const char *fn = "cos_tcp_response_readlen_process()";
	u_int16_t length_buf;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;

	if (!context_timeout_register (cont, cont->param.t_res->timeout)) {
		/* still use old input list -- data following */

		/* read length buffer */
		if (read (cont->param.t_res->conn_sock, (u_char *) (&length_buf), sizeof (u_int16_t)) < sizeof (u_int16_t))
			syslog (LOG_NOTICE, "%s: failed to read the length of TCP message", fn);
		else {
			length_buf = ntohs (length_buf);
			if (length_buf > MAX_STREAM)
				syslog (LOG_NOTICE, "%s: don't accept more than %d for a TCP mesg", fn, MAX_STREAM);
			else {
				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: data length = %d", fn, length_buf));
				}

				/* free old buffer */
				if (cont->mesg.p)
					free (cont->mesg.p);

				/* allocate new properly sized buffer */
				cont->mesg.p = malloc (length_buf);
				if (cont->mesg.p) {
					cont->mesg_len = length_buf;
					cont->wp = cont->mesg.p;

					/* go next state */
					cont->process = cos_tcp_response_reading_process;
					cont->retry = cos_tcp_response_reading_retry;
					cont->current_state = COS_TCP_RESPONSE_READING;

					if (T.debug > 1) {
						DX (syslog (LOG_DEBUG, "%s: return", fn));
					}
					/* SUCCESS */
					return 0;
				} else {
					cont->mesg_len = 0;
					syslog (EM_F (EM_F_MEMEX), fn);
				}
			}
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: abort", fn));
	}

	/* FAILURE */
	return (cos_tcp_response_abort (cont, -1));
}

/* readlen - retry */
int cos_tcp_response_readlen_retry (Context * cont) {
	const char *fn = "cos_tcp_response_readlen_retry()";

	syslog (LOG_NOTICE, "%s: connection does not respond. closing.", fn);
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_reading_process (Context * cont) {
	const char *fn = "cos_tcp_response_reading_process()";
	int len;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;

	if (!context_timeout_register (cont, cont->param.t_res->timeout)) {
		len = read (cont->param.t_res->conn_sock, cont->wp, cont->mesg_len - (cont->wp - cont->mesg.p));
		if (len > 0 && cont->an_list && cont->ns_list && cont->ar_list) {
			cont->wp += len;
			if (cont->wp < (cont->mesg.p + cont->mesg_len)) {
				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: left %d bytes -- continue.", fn, (cont->mesg.p + cont->mesg_len) - cont->wp));
				}
				/* SUCCESS */
				return 0;	/* the processing continues ... */
			} else {
				/* all data has been read now */
				ev_tcp_conn_in_remove (cont->param.t_res->conn_sock);

				if (cont->mesg.hdr->opcode == OP_QUERY) {
					if (T.debug > 1) {
						DX (syslog (LOG_DEBUG, "%s: OPCODE = OP_QUERY", fn));
					}
					if (cont->tout)
						cont->tout->handler = NULL;
					/* don't register input list child context takes input */

					if (!cos_common_start_rq (cont, QUERY_TCP)) {
						/* to go waiting_recursive state */
						/* clear events -- child process will call me then */
						if (cont->tout)
							cont->tout->handler = NULL;

						cont->process = cos_tcp_response_waiting_recursive_process;
						cont->retry = cos_tcp_response_waiting_recursive_retry;
						cont->current_state = COS_TCP_RESPONSE_WAITING_RECURSIVE;
						if (T.debug > 1) {
							DX (syslog (LOG_DEBUG, "%s: end (waiting_recursive)", fn));
						}
						/* SUCCESS */
						return 0;
					}
				} else {
					syslog (LOG_NOTICE, "%s: OPCODE = unknown(%d)", fn, cont->mesg.hdr->opcode);
					cont->mesg.hdr->rcode = RC_NIMP;
				}

				/* 
				 * Not OP_QUERY or Request failed brings us here
				 *
	 			 * Go to writing state. Timeout already done in this function
	 			 * Register new output event 
	 			 */

				if (!ev_tcp_out_register (cont->param.t_res->conn_sock, cont)) {
					/* assemble the answers */
					cos_tcp_sub_assemble (cont);

					/* state change */
					cont->process = cos_tcp_response_writing_process;
					cont->retry = cos_tcp_response_writing_retry;
					cont->current_state = COS_TCP_RESPONSE_WRITING;
					cont->wp = NULL;	/* to write it from the first byte, initialize wp */
					if (T.debug > 1) {
						DX (syslog (LOG_DEBUG, "%s: end (writing:)", fn));
					}
					/* SUCCESS */
					return 0;
				}
			}
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: abort", fn));
	}

	/* FAILURE */
	return(cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_reading_retry (Context * cont) {
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_waiting_recursive_process (Context *cont) {
	const char *fn = "cos_tcp_response_waiting_recursive_process()";
	int len;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	switch (cos_common_waiting_recursive_process (cont)) {
	case 0:
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: return, continue", fn));
		}

		/* SUCCESS */
		return 0;
	case 1:
		/* copy query header to TCP_Buf */
		memcpy (Cos_TCP_Buf, cont->mesg.p, cont->mesg_len);

		/* assemble the answer */
		len = cos_tcp_sub_assemble (cont);

		/* register timeout */
		if (cont->tout)
			cont->tout->handler = NULL;

		if (!context_timeout_register (cont, cont->param.t_res->timeout)) {
			/* register output */
			if (!ev_tcp_out_register (cont->param.t_res->conn_sock, cont)) {
		
				/* copy child RCODE and AA */
				if (cont->mesg.hdr->rcode == RC_OK && cont->child) {
					cont->mesg.hdr->rcode = cont->child->mesg.hdr->rcode;
					cont->mesg.hdr->aa = cont->child->mesg.hdr->aa;
				}

				/* change the state */
				cont->current_state = COS_TCP_RESPONSE_WRITING;
				cont->process = cos_tcp_response_writing_process;
				cont->retry = cos_tcp_response_writing_retry;

				/* reset cont->wp to write it from the very first byte! */
				cont->wp = NULL;

				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: return, finish", fn));
				}

				/* SUCCESS */
				return 0;
			}
		}
	default:
		/* FAILURE */
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: abort", fn));
	}

	/* FAILURE */
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_waiting_recursive_retry (Context * cont) {
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_writing_process (Context * cont) {
	DX(const char *fn = "cos_tcp_response_writing_process()");

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	/* renew timeout */
	if (cont->tout)
		cont->tout->handler = NULL;

	if (!context_timeout_register (cont, cont->param.t_res->timeout)) {
		switch (cos_common_tcp_writemesg (cont, cont->param.t_res->conn_sock)) {
		case 0:
			/* continue this process */
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: return, continue", fn));
			}

			/* SUCCESS */
			return 0;
		case 1:
			/* all data written */
			cont->current_state = COS_TCP_RESPONSE_WAITING_CLIENT_CLOSE;
			cont->process = cos_tcp_response_waiting_client_close_process;
			cont->retry = cos_tcp_response_waiting_client_close_retry;

			/* stop output and waiting for input */
			ev_tcp_out_remove (cont->param.t_res->conn_sock);
			ev_tcp_conn_in_register (cont->param.t_res->conn_sock, cont);

			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: return, finish", fn));
			}

			/* SUCCESS */
			return 0;
		default:
			/* FAILURE */
			break;
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: abort", fn));
	}

	/* FAILURE */
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_writing_retry (Context * cont) {
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_waiting_client_close_process (Context * cont) {
	const char *fn = "cos_tcp_response_waiting_client_close_process()";
	u_int16_t length_buf;
	int i;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	i = read (cont->param.t_res->conn_sock, (u_char *) (&length_buf), sizeof (u_int16_t));
	if (!i) {
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: EOF: finish the session.", fn));
		}

		/* SUCCESS */
		return cos_tcp_response_finish (cont);
	} else if (i < sizeof (u_int16_t)) {
		/* read error */
		syslog (LOG_INFO, "%s: read(): %m", fn);
	} else {
		/* redo query processing */
		length_buf = ntohs (length_buf);

		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: find incoming length %d", fn, length_buf));
		}

		/* free old buffer */
		if (cont->mesg.p)
			free (cont->mesg.p);

		/* allocate new buffer */
		cont->mesg.p = malloc (length_buf);
		if (!cont->mesg.p) {
			cont->mesg_len = 0;
			syslog (EM_F (EM_F_MEMEX), fn);
		}
		else {
			cont->mesg_len = length_buf;
			cont->wp = cont->mesg.p;
			cont->param.t_res->timeout = COS_TCP_SRV_TIMEOUT;

			/* renew timeout */
			if (cont->tout)
				cont->tout->handler = NULL;
	
			if (!context_timeout_register (cont, cont->param.t_res->timeout)) {
				/* I/O event is not changed -- tcp_conn_in,  go back to reading */
				cont->process = cos_tcp_response_reading_process;
				cont->retry = cos_tcp_response_reading_retry;
				cont->current_state = COS_TCP_RESPONSE_READING;

				if (T.debug > 1) {
					DX (syslog (LOG_DEBUG, "%s: return, continue reading", fn));
				}

				/* SUCCESS */
				return 0;
			}
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: abort", fn));
	}

	/* FAILURE */
	return (cos_tcp_response_abort (cont, -1));
}

int cos_tcp_response_waiting_client_close_retry (Context * cont) {
	return (cos_tcp_response_abort (cont, 0));
}

void cos_tcp_response_destroy (Context * cont) {
	const char *fn = "cos_tcp_response_destroy()";

	if (cont) {
		if (cont->param.t_res) {
			if (cont->param.t_res->sa_p) {
				free (cont->param.t_res->sa_p);
				cont->param.t_res->sa_p = NULL;
			}
			if (cont->param.t_res->conn_sock >= 0) {
				shutdown (cont->param.t_res->conn_sock, 2);
				close (cont->param.t_res->conn_sock);

				switch (cont->current_state) {
				case COS_TCP_RESPONSE_READLEN:
				case COS_TCP_RESPONSE_READING:
				case COS_TCP_RESPONSE_WAITING_CLIENT_CLOSE:
					/*
					 * remove connected input socket event
					 */
					ev_tcp_conn_in_remove (cont->param.t_res->conn_sock);
					break;
				case COS_TCP_RESPONSE_WAITING_RECURSIVE:
					/*
					 * no registered input should exist...
					 */
					break;
				case COS_TCP_RESPONSE_WRITING:
					/*
					 * remove connected output socket event
					 */
					ev_tcp_out_remove (cont->param.t_res->conn_sock);
					break;
				default:
					syslog (LOG_ERR, "%s: unknown stat to destroy", fn);
					break;
				} /* switch */

			} /* if(...conn_sock >= 0) */
			free (cont->param.t_res);
		} /* if(t_res) */
	}
	return;
}

int cos_tcp_response_abort (Context * cont, int status) {
	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "cos_tcp_response_abort()"));
	}

	context_destroy (cont);
	return status;
}

int cos_tcp_response_finish (Context * cont) {

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "cos_tcp_response_finish()"));
	}

	context_destroy (cont);
	return 0;
}
