/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_common.c,v 3.34 2001/03/13 11:14:43 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_common.c,v 3.34 2001/03/13 11:14:43 dillema Exp $");

u_char Cos_TCP_Buf[MAX_STREAM];


/*
 * returns next nameserver address stored in context,
 * or NULL upon error or no (more) addresses
 * cont->current_glue and cont->current_ns are index 
 * to last nameserver used. cont->ns contains record
 * set with nameserver records.
 */
struct sockaddr *cos_common_next_ns_addr_alloc (Context *cont) {
  	static char *fn = "cos_common_next_ns_addr_alloc";
  	int address_family, address_len;
  	u_char *address;
  	struct sockaddr* sa_p = NULL; /* alloc'ed */
  	RR* rr_tmp;

  	address_family = 0; /* avoid overrun */

    	/* try to find another glue within AR list or cache */
    	while (cont->current_ns < cont->ns->data.d->data_cnt) {
#ifdef USE_INET6
      		address_family = AF_INET6;
      		address_len = IPV6_ADDR_LEN;
      		cont->ns_glue = cos_common_search_glue(cont->ar_list, cont->ns, cont->current_ns, address_family);
#endif /* USE_INET6 */
#ifdef USE_INET4
      		if (!cont->ns_glue) { /* mean no IPv6 glue found */
			address_family = AF_INET;
			address_len = IPV4_ADDR_LEN;
			cont->ns_glue = cos_common_search_glue(cont->ar_list, cont->ns, cont->current_ns, address_family);
      		}
#endif /* USE_INET4 */

      		/* advance id regardless we've got good glue or not. */
      		cont->current_ns++;

      		if(cont->ns_glue) {
			/* good glue found! */
			break;
      		}
    	} /* while we've another NS in ns rrset */

  	/* select address in current glue RRset */
  	if (cont->ns_glue) {
    		rr_tmp = (RR*)(cont->ns_glue->data.p
			   + data_offset(cont->current_glue, cont->ns_glue->data.d));

	    	address = rr_rdata(rr_tmp);
    		sa_p = net_sockaddr_alloc(address_family, address, address_len, PORT_TO);
    		if (!sa_p) {
      			syslog(LOG_WARNING, "%s: can't allocate sockaddr structure.\n", fn);
			return NULL;
    		}
	}

  	return sa_p;
}

/* search glue record in specified NS record list */
RRset *cos_common_search_glue (G_List *ar_list, RRset *ns_rrsp, int ns_cnt, int af) {
  	RRset *rrs_tmp; /* not alloc'ed */
  	RR *rr_tmp;
  	u_char *ns_domain;
  	int ns_domain_len, r_type_search;
  	G_List* gl_tmp;

  	if (af == AF_INET) {
    		r_type_search = RT_A;
#ifdef USE_INET6
  	} else if (af == AF_INET6) {
    		r_type_search = RT_AAAA;
#endif /* USE_IPV6 */
  	} else {
    		/* I don't think there's answer... */
    		return NULL;
  	}
  
  	/* first, locate the NS record to use */
  	rr_tmp = (RR*)(ns_rrsp->data.p + data_offset(ns_cnt, ns_rrsp->data.d));
  	ns_domain_len = rr_tmp->rd_len;
  	ns_domain = rr_rdata(rr_tmp);

  	/* search for A/AAAA record of corresponding domain name in ar_list */
  	ar_list->list_data = NULL;
  	for (gl_tmp = ar_list->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
    		rrs_tmp = (RRset*)gl_tmp->list_data;
    		if (rrs_tmp->key.info->r_type == r_type_search && rrs_tmp->key.info->owner_len == ns_domain_len
       		    && !mesg_dname_cmp(NULL, rrset_key_info_owner(rrs_tmp), ns_domain)) {
      			/* record match */
      			return rrset_copy(rrs_tmp); /* copy: return must be alloc'ed */
    		}
  	}

  	/* no record found */
  	return NULL;
}

u_char *cos_common_cname_without_crecord (G_List * an_list, int *cnamelen_ret) {
        DX(char *fn = "cos_common_cname_without_crecord()";)
	int canonical_domain_len;
	u_char *canonical_domain, *domain;

	G_List *gl_tmp;
	RRset *rrs_tmp;
	RR *rr_tmp;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: Search for CNAME Record in Answer Record List\n", fn));
	}

	canonical_domain = NULL;
	an_list->list_data = NULL;
	for (gl_tmp = an_list->next; gl_tmp->list_data != NULL; gl_tmp = gl_tmp->next) {
		rrs_tmp = (RRset *) gl_tmp->list_data;
		if (rrs_tmp->key.info->r_type == RT_CNAME) {
			rr_tmp = (RR *) (rrs_tmp->data.p + data_offset (0, rrs_tmp->data.p));
			canonical_domain = rr_rdata (rr_tmp);
			canonical_domain_len = rr_tmp->rd_len;
		}
	}
	if (!canonical_domain) {
		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: no problem -- no CNAME record.\n", fn));
		}
		return NULL;	/* no problem -- no cname record */
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: Match for CNAME?\n", fn));
	}

	an_list->list_data = NULL;
	for (gl_tmp = an_list->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rrs_tmp = (RRset *) gl_tmp->list_data;
		domain = rrset_key_info_owner (rrs_tmp);
		if ((rrs_tmp->key.info->owner_len == canonical_domain_len)
		    && !mesg_dname_cmp (NULL, domain, canonical_domain)) {
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: OK, NP -- CNAME and canonical record.\n", fn));
			}
			return NULL;
		}
	}

	if (cnamelen_ret)
		*cnamelen_ret = canonical_domain_len;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: Problem: CNAME without canonical record.\n", fn));
	}

	return canonical_domain;
}

/*
 * change the target to specified domain, preserving original context's
 *  target r_type and class.
 */
int cos_common_change_target (Context * cont, u_char * target, int target_len, u_int16_t r_type) {
	static char *fn = "cos_common_change_target()";
	u_char *ucp;
	u_char *ucp2;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: starts.\n", fn));
	}

	if (cont->ns_list)
		list_destroy (cont->ns_list, rrset_freev);

	if (cont->ar_list)
		list_destroy (cont->ar_list, rrset_freev);

	cont->ns_list = list_init ();
	cont->ar_list = list_init ();
	if (!cont->ns_list || !cont->ar_list) {
		syslog (LOG_ERR, "%s: can't initialize lists.", fn);
		return -1;
	}
	/* check query section */
	ucp = cont->mesg.p + sizeof (Mesg_Hdr);
	if ((ucp2 = mesg_skip_dname (ucp, cont->mesg.p  + cont->mesg_len))
	    == NULL) {
		syslog(LOG_INFO, "%s: bad length", fn);
		return(-1);
	}

	if (target) {
		memcpy (cont->qname, target, target_len);
		cont->qname_len = target_len;
	} else {
		memcpy (cont->qname, ucp, ucp2 - ucp);
		cont->qname_len = ucp2 - ucp;
	}

	if (r_type == 0) {
		GETSHORT (cont->q_type, ucp2);
	} else {
		cont->q_type = r_type;
		ucp2 += 2;	/* skip q_type */
	}

	GETSHORT (cont->q_class, ucp2);

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: ends.\n", fn));
	}

	return 0;
}

int cos_common_start_rq (Context *cont, int tcp) {
	const char *fn = "cos_common_start_rq()";
	int ret, qname_len;
	u_char *qname, *cp;
	u_int16_t qclass, qtype;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}

	ret = 0;
	qname = NULL;
	if (cont->qname_len == 0) {
		/* new query, get qstuff from query message */
		qname = cont->mesg.p + sizeof (Mesg_Hdr);
		if ((cp = mesg_skip_dname (qname, cont->mesg.p + cont->mesg_len))
		    == NULL) {
			syslog(LOG_INFO, "%s: malformed question.", fn);
			ret = 1;
			goto done;
		}
		qname_len = cp - qname;
		if (qname_len > MAX_DNAME) {
			syslog (LOG_INFO, "%s: malformed question.", fn);
			ret = 1;
			goto done;
		} else {
			GETSHORT (qtype, cp);
			GETSHORT (qclass, cp);

			cp = qname;
			qname = cont->qname;
			memcpy (qname, cp, qname_len);
			cont->q_type = qtype;
			cont->q_class = qclass;

			if (T.debug > 0) {
				DX (syslog (LOG_DEBUG, "%s: query name: %s, %d", fn, qname, qname_len));
			}

			if (qtype == RT_PTR) {
				struct in6_addr a6;

				if (conv_trick_is_tot_ptr (qname)) {
					conv_trick_ptr_rq(qname);
					qname_len = strlen (qname);
					if (T.debug > 0) {
						DX (syslog (LOG_DEBUG, "%s: converted query name: %s, %d", fn, qname, qname_len));
					}
				}
				else if (conv_trick_is_tot_newptr (qname, &a6)) {
					conv_trick_newptr_rq(qname, &a6);
					qname_len = strlen (qname);
					if (T.debug > 0) {
						DX (syslog (LOG_DEBUG, "%s: converted query name: %s, %d", fn, qname, qname_len));
					}
				}
#ifdef SCOPED_REWRITE
				else if (conv_is_scoped_ptr(qname, 1) != -1) {
					conv_scoped_ptr_rq(qname);
					qname_len = strlen(qname);
					if (T.debug > 0) {
						DX (syslog (LOG_DEBUG, "%s: converted query name: %s, %d", fn, qname, qname_len));
					}
				}
#endif
			}
		}
	} else {
		qname_len = strlen (cont->qname) + 1;	/* safer than: cont->qname_len */
		if (qname_len != cont->qname_len) {
			syslog (LOG_INFO, "%s: qname and qname_len don't match!", fn);
			ret = 1;
		}
		if (cont->qname_len > MAX_DNAME) {
			syslog (LOG_INFO, "%s: malformed question.\n", fn);
			ret = 1;
		}
		qname = malloc (qname_len);
		strcpy (qname, cont->qname);
		qname_len = cont->qname_len;
		qtype = cont->q_type;
		qclass = cont->q_class;
	}

  done:
	cont->qname_len = qname_len;

	if (!ret) {
		if (T.debug > 1) {
	       		DX (syslog (LOG_DEBUG, "%s: do forwarding.\n", fn));
		}

                if (!((Fwd *) T.current_fwd->list_data)->sa) {
                        syslog (LOG_ERR, "%s: no forwarders configured!", fn);
                        ret = -1;
                } else {
			if (!tcp && !ret)
				tcp = cos_udp_request_start (cont, qname, qname_len, qclass, qtype,
					((Fwd *) T.current_fwd->list_data)->sa);
			if (tcp == 1 && !ret) 
				ret = cos_tcp_request_start (cont, qname, qname_len, qclass, qtype,
					((Fwd *) T.current_fwd->list_data)->sa);
		}
	}

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: end", fn));
	}
	return (ret);
}

int cos_common_waiting_recursive_process (Context *cont) {
        const char *fn = "cos_common_waiting_recursive_process()";
	u_char *cname, *ucp;
	int cname_len;
	u_int16_t us;
#ifdef STF
	int sa_len, qname_len, tcp;
	u_int16_t qclass, qtype;
        struct sockaddr *sa;
	u_char qname[MAX_DNAME], *qn, *cp;
	G_List *gl_tmp;
#endif

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: start", fn));
	}
	if (!cont->child) {
		if (T.debug > 0) {
			DX (syslog (LOG_DEBUG, "%s: child died", fn));
		}
		return -1;
	}

	ucp = cont->child->mesg.p + sizeof (Mesg_Hdr);
	ucp = mesg_skip_dname (ucp, cont->child->mesg.p + cont->child->mesg_len);
	if (ucp == NULL) {
		syslog(LOG_INFO, "%s: malformed message", fn);
		return(-1);
	}
	GETSHORT (us, ucp);	/* resource type */

	/* 
	 * If we got no answers to our query, we may need to do our trick. 
	 * really do we wanna look at child? (return code better/possible?) 
	 */
	if (cont->child->mesg.hdr->ancnt == htons (0)) {
		/* We got no answers in the reply we got to our query. 
		 * We check here whether we need to modify the query
		 * to get answers we can transform into (pseudo-)
		 * answer records for the original query.
		 */
		if (T.prefixnum && us == RT_AAAA && cont->child->q_type != RT_A) {
			if (T.debug > 0) {
				DX (syslog (LOG_DEBUG, "%s: change target from AAAA to A\n", fn));
			}
			if (cos_common_change_target (cont, NULL, 0, RT_A) < 0)
				return -1;

			/* forget about old child */
			cont->child->parent = NULL;
			cont->child = NULL;

			return cos_common_start_rq (cont, QUERY_TCP);
		}
		if (T.prefixnum && us == RT_A6 && cont->child->q_type != RT_A) {
			if (T.debug > 0) {
				DX (syslog (LOG_DEBUG, "%s: change target from A6 to A\n", fn));
			}
			if (cos_common_change_target (cont, NULL, 0, RT_A) < 0)
				return -1;

			/* forget about old child */
			cont->child->parent = NULL;
			cont->child = NULL;

			return cos_common_start_rq (cont, QUERY_TCP);
		}
	}

#ifdef STF
	/* 
	 * Reverse lookup for 6to4 name.
	 */
	if (T.stf && conv_stf_is_stf_ptr (cont->qname) && !cont->ns && (us == RT_NS || us == RT_PTR)) {
		if (T.debug > 0) {
			DX (syslog (LOG_DEBUG, "%s: 6to4 reverse query...\n", fn));
		}
		/* 
		 * Parent query was for 6to4 reverse domainname 
		 * Now check what our child query produced 
		 */
		if (conv_stf_is_stf_ptr (cont->child->qname) && cont->child->mesg.hdr->rcode == RC_NXDOMAIN) {
			/*
			 * Child was normal 6to4 query as requested...
		 	 * ...but failed with `unknown domain'. We will make 
			 * a new NS query request for the embedded 
		 	 * IPv4 address in it. That one is supposed to
			 * know about the corresponding 6to4 domain also.
			 */
			qname_len = strlen(cont->qname) + 1;
			if (qname_len > 33) 
				memcpy(cont->qname, cont->qname + qname_len - 33, 33);
			cont->qname_len = strlen(cont->qname) + 1;
			if (cont->qname_len > MAX_DNAME)
				return -1;

			if (T.debug > 0) {
				DX (syslog (LOG_DEBUG, "%s: 6to4 PTR trick...\n", fn));
			}

			/* 
			 * We want to issue the request to the same forwarder
			 * nameserver we used for the original query, so get
			 * that info simply from the old child. 
			 */
			tcp = (cont->child->type == CTYPE_TCP_REQUEST);
			if (tcp) {
				struct sockaddr_storage sockstor;
				sa = (struct sockaddr *) &sockstor;
				sa_len = sizeof(*sa);
				if (getsockname(cont->child->param.request->conn_sock, sa, &sa_len))
					return(-1);
			} else
				sa = cont->child->param.request->sa;

			/* 
			 * Now just forget about old child. child will free itself, 
			 * i.e. when this one returns to finish that child processing 
			 */
			cont->child->parent = NULL;
			cont->child = NULL;

			/* 
			 * get embedded IPv4 address in 6to4 address
			 */
			memcpy(qname, cont->qname, cont->qname_len);
			qname_len = cont->qname_len;
			if (conv_stf_ptr (qname, qname_len) < 0)
				return -1;
			qname_len = strlen(qname) + 1;
			qclass = C_IN;
			qtype = RT_NS;

			/*
		 	 * Do new child query
		 	 */
               		if (!tcp) 
                       		tcp = cos_udp_request_start (cont, qname, qname_len, qclass, qtype, sa);
               		if (tcp == 1)
                       		tcp = cos_tcp_request_start (cont, qname, qname_len, qclass, qtype, sa);
			return (tcp);
		}

		if (T.debug > 1) {
			DX (syslog (LOG_DEBUG, "%s: child was embedded v4 query\n", fn));
		}

		if (cont->q_type == RT_PTR && (cont->child->mesg.hdr->ancnt == htons(0))) {
			/*
			 * Parent query was for PTR 6to4 name query, and
			 * we tried to get the v4 nameserver for it.
			 * If we got no answer, so have to move up in the 
			 * PTR hierarchy.
			 */

			qname_len = strlen(cont->qname) + 1;
			if (qname_len > 33) 
				syslog (LOG_WARNING, "%s: 6to4 PTR name bigger than expected %s\n", fn, cont->qname);

			memcpy(cont->qname, cont->qname+4, qname_len - 4); /* maybe bcopy is safer, more portable with overlap */
			cont->qname_len = strlen(cont->qname) + 1;

			if (T.debug > 0) {
				DX (syslog (LOG_DEBUG, "%s: 6to4 moving up PTR hierarchy name = %s\n", fn, cont->qname));
			}

			/* 
			 * We want to issue the request to the same forwarder
			 * nameserver we used for the original query, so get
			 * that info simply from the old child. 
			 */
			tcp = (cont->child->type == CTYPE_TCP_REQUEST);
			if (tcp) {
				struct sockaddr_storage sockstor;
				sa = (struct sockaddr *) &sockstor;
				sa_len = sizeof(*sa);
				if (getsockname(cont->child->param.request->conn_sock, sa, &sa_len))
					return(-1);
			} else
				sa = cont->child->param.request->sa;

			/* 
			 * Now just forget about old child. child will free itself, 
			 * i.e. when this one returns to finish that child processing 
			 */
			cont->child->parent = NULL;
			cont->child = NULL;

			/* 
			 * get embedded IPv4 address in 6to4 address
			 */
			memcpy(qname, cont->qname, cont->qname_len);
			qname_len = cont->qname_len;
			if (conv_stf_ptr (qname, qname_len) < 0)
				return -1;
			qname_len = strlen(qname) + 1;
			qclass = C_IN;
			qtype = RT_NS;

			/*
		 	 * Do new child query
		 	 */
               		if (!tcp) 
                       		tcp = cos_udp_request_start (cont, qname, qname_len, qclass, qtype, sa);
               		if (tcp == 1)
                       		tcp = cos_tcp_request_start (cont, qname, qname_len, qclass, qtype, sa);
			return (tcp);

		} 

		if (cont->q_type == RT_PTR) {
               		if (T.debug > 0) {
  	     			DX (syslog (LOG_DEBUG, "%s: 6to4 query to IPv4 nameserver: %s", fn, cont->qname));
       			}

			/* 
	 		 * Parent query was for PTR 6to4 name query, and
	 		 * our child got us the nameserver(s) for the
	 		 * embedded v4 name.
               		 * Now we should ask that nameserver the
               		 * original 6to4 PTR query we wanted to answer.
	 		 */

			/* new query, get qstuff from query message */
			qn = cont->mesg.p + sizeof (Mesg_Hdr);
			cp = mesg_skip_dname (qn, cont->mesg.p + cont->mesg_len);
			if (cp == NULL) {
				syslog (LOG_INFO, "%s: malformed question.", fn);
				return -1;
			}
			qname_len = cp - qn;
			if (qname_len > MAX_DNAME) {
				syslog (LOG_INFO, "%s: malformed question.", fn);
				return -1;
			}
			GETSHORT (qtype, cp);
			GETSHORT (qclass, cp);

			cp = qn;
			qn = cont->qname;
			strncpy (qname, cp, qname_len);
			strncpy (cont->qname, cp, qname_len);
			cont->q_type = qtype;
			cont->q_class = qclass;

			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: query name: %s, %d", fn, qname, qname_len));
			}

               		/* Extract nameservers */
			list_destroy (cont->an_list, rrset_freev);
			list_destroy (cont->ns_list, rrset_freev);
			list_destroy (cont->ar_list, rrset_freev);
			cont->an_list = cont->child->an_list;
			cont->ns_list = cont->child->ns_list;
			cont->ar_list = cont->child->ar_list;
			cont->child->an_list = NULL;
			cont->child->ns_list = NULL;
			cont->child->ar_list = NULL;

			/*  We cycle through the list of nameserver answers */
        		for (gl_tmp = cont->an_list->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
				/*
				 * But we only do that if we fail to send a
				 * request to the nameserver we try to contact.
				 * We don't try another one if we don't get
				 * a valid answer back the first time. Am
				 * not sure that is the proper thing to do
				 * but for now it should be good enough.
				 */
				cont->ns = gl_tmp->list_data;
				cont->current_ns = 0;
				cont->current_glue = 0;
				sa = cos_common_next_ns_addr_alloc(cont);
				if (!sa)
					return -1;

				/* 
	 		 	 * Now just forget about old child. child will free itself, 
	 		 	 * i.e. when this one returns to finish that child processing 
	 		 	 */
				cont->child->parent = NULL;
				cont->child = NULL;

               			/* Send query to first nameserver */
               			if (T.debug > 0) {
  	     				DX (syslog (LOG_DEBUG, "%s: Asking IPv4 nameserver for the 6to4 PTR name: %s", fn, cont->qname));
       				}

				/*
	 		 	 * Do new child query
	 		 	 */
				tcp = QUERY_TCP;
               			if (!tcp) 
               				tcp = cos_udp_request_start (cont, qname, qname_len, qclass, qtype, sa);
        			if (tcp == 1)
               				tcp = cos_tcp_request_start (cont, qname, qname_len, qclass, qtype, sa);

				if (tcp != -1)
					return(tcp);
        		}
		}
	}
#endif

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: checking cname validity...\n", fn));
	}
	cname = cos_common_cname_without_crecord (cont->child->an_list, &cname_len);
	if (cname && (cont->cname_links++ < SEARCH_CNAME_LEVEL)) {
		/* change target and start again */
		if (cos_common_change_target (cont, cname, cname_len, 0) < 0)
			return -1;

		/* forget about old child */
		cont->child->parent = NULL;
		cont->child = NULL;

		if (T.debug > 0) {
			DX (syslog (LOG_DEBUG, "%s: following CNAME links.\n", fn));
		}
		return cos_common_start_rq (cont, QUERY_TCP);
	}

	/* 
	 * This child response is useful to us, so we pull it up to the parent
	 */
	list_destroy (cont->an_list, rrset_freev);
	list_destroy (cont->ns_list, rrset_freev);
	list_destroy (cont->ar_list, rrset_freev);
	cont->an_list = cont->child->an_list;
	cont->child->an_list = NULL;
	cont->ns_list = cont->child->ns_list;
	cont->child->ns_list = NULL;
	cont->ar_list = cont->child->ar_list;
	cont->child->ar_list = NULL;

	if (T.debug > 1) {
		DX (syslog (LOG_DEBUG, "%s: finish", fn));
	}
	return 1;		/* recursive query finished */
}

int cos_common_tcp_writemesg (Context * cont, int sock) {
	char *fn = "cos_common_tcp_writemesg()";
	u_int16_t lenbuf_nbo;
	int len;

	if (!cont->wp) {
		/* first time: write length */
		lenbuf_nbo = htons (cont->mesg_len);
		len = write (sock, (u_char *) (&lenbuf_nbo), sizeof (u_int16_t));
		if (len < 0) {
			syslog (LOG_INFO, "%s: write length failed: %m", fn);
			return -1;
		}
		cont->wp = cont->mesg.p;
		return 0;
	} else {
		len = write (sock, cont->wp, cont->mesg_len - (cont->wp - cont->mesg.p));
		if (len < 0) {
			syslog (LOG_INFO, "%s: write failed: %m", fn);
			return -1;
		}
		cont->wp += len;

		if (cont->wp < cont->mesg.p + cont->mesg_len) {
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: cont'ed this context (return 0)\n", fn));
			}
			return 0;
		} else {
			if (T.debug > 1) {
				DX (syslog (LOG_DEBUG, "%s: write finished(return 1)\n", fn));
			}
			return 1;
		}
	}

	/* NOTREACHED */
	abort ();
}
