/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons.h,v 3.9 2000/09/06 20:28:34 dillema Exp $>
 */

#ifndef CONS_H
#define CONS_H

u_char Cos_TCP_Buf[MAX_STREAM];

typedef struct cos_request {
	u_int16_t retry;
	u_int16_t timeout;
/*
	int current_ns;
	int current_glue;
	RRset *ns;
	RRset *ns_glue;
*/
	int conn_sock;		/* connection socket for tcp request */
	struct sockaddr *sa;	/* address structure for udp request */
} Cos_Request;

#define BASE_TCP_REQ_SIZE 512

#define COS_TCP_REQUEST_START 0
#define COS_TCP_REQUEST_WAIT_CONNECT 1
#define COS_TCP_REQUEST_WRITING 2
#define COS_TCP_REQUEST_READLEN 3
#define COS_TCP_REQUEST_READING 4
#define COS_TCP_REQUEST_SUSPENDED 5

#define COS_UDP_REQUEST_START 0
#define COS_UDP_REQUEST_SENDED 1
#define COS_UDP_REQUEST_SUSPENDED 2


#define COS_TCP_RESPONSE_START 0
#define COS_TCP_RESPONSE_ACCEPTED 0	/* same as above */
#define COS_TCP_RESPONSE_READLEN 1
#define COS_TCP_RESPONSE_READING 2
#define COS_TCP_RESPONSE_WAITING_RECURSIVE 3
#define COS_TCP_RESPONSE_WRITING 4
#define COS_TCP_RESPONSE_WAITING_CLIENT_CLOSE 5

#define COS_TCP_SRV_TIMEOUT 120

typedef struct cos_tcp_response {
	int timeout;
	int conn_sock;		/* connected socket */
	struct sockaddr *sa_p;	/* sockaddr of peer / alloc'ed */
	int sa_len;
} Cos_TCP_Response;

#define COS_UDP_RESPONSE_START 0
#define COS_UDP_RESPONSE_WAITNIG_RECURSIVE 1

typedef struct cos_udp_response {
	struct sockaddr *sa_p;	/* alloc'ed */
	int sa_len;		/* <- length of alloc'ed memory for peer */
	NI_List *inif;		/* <- input interface / alloc'ed */
}   Cos_UDP_Response;

#endif				/* CONS_H */
