/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/
/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: queue.c,v 3.8 1999/08/17 16:52:10 feico Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: queue.c,v 3.8 1999/08/17 16:52:10 feico Exp $");

Q_Set *queue_create (void)
{
	Q_Set *qs_tmp;

	if ((qs_tmp = malloc (sizeof (Q_Set))) == NULL) {
		syslog (LOG_WARNING, "queue_create(): memory exhausted\n");
		return NULL;
	}
	if ((qs_tmp->head = qs_tmp->tail = malloc (sizeof (G_Queue))) == NULL) {
		syslog (LOG_WARNING, "queue_create(): memory exhausted\n");
		free (qs_tmp);
		return NULL;
	}
#ifdef CHECK_QUEUE_LEN
	qs_tmp->queue_len = 0;
#endif				/* CHECK_QUEUE_LEN */

	qs_tmp->head->next = NULL;
	qs_tmp->head->p = NULL;

	return qs_tmp;
}

int enqueue (Q_Set * qs, void *p)
{
	G_Queue *gq_tmp;

	if ((gq_tmp = malloc (sizeof (G_Queue))) == NULL) {
		syslog (LOG_WARNING, "enqueue(): memory exhausted.\n");
		return -1;
	}
	gq_tmp->next = NULL;
	gq_tmp->p = NULL;

	qs->tail->p = p;
	qs->tail->next = gq_tmp;

	qs->tail = gq_tmp;

#ifdef CHECK_QUEUE_LEN
	qs->queue_len++;
	DX (syslog (LOG_DEBUG, "enqueue(): queue_len = %d", qs->queue_len));
#endif				/* CHECK_QUEUE_LEN */

	return 0;
}

void *dequeue (Q_Set * qs)
{
	void *p;
	G_Queue *gq_tmp;

	if (qs->head->next == NULL) {
		return NULL;
	}
	do {
		p = qs->head->p;
		gq_tmp = qs->head;
		qs->head = qs->head->next;
		free (gq_tmp);

#ifdef CHECK_QUEUE_LEN
		qs->queue_len--;
		DX (syslog (LOG_DEBUG, "dequeue(): queue_len = %d", qs->queue_len));
#endif				/* CHECK_QUEUE_LEN */
	} while (p == NULL && qs->head != qs->tail);

	return p;
}

void *queue_peek (Q_Set * qs)
{

	if (qs->head->next == NULL) {
		return NULL;
	}
	return qs->head->p;
}

void *queue_disable (G_Queue * gq)
{
	void *p;
	p = gq->p;
	gq->p = NULL;
	return p;
}

void queue_destroy (Q_Set * qs, void (*freefnc) (void *))
{
	void *p;
	while ((p = dequeue (qs)) != NULL) {
		(*freefnc) (p);
	}

	if (qs->head) {
		/* watchdog */
		free (qs->head);
	}
	free (qs);

	return;
}
