/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/


/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: protos.h,v 3.11 2000/04/02 12:35:26 dillema Exp $>
 */

#ifndef PROTOS_H
#define PROTOS_H
struct sockaddr *cos_common_next_ns_addr_alloc (Context *);
RRset *cos_common_search_glue (G_List *, RRset *, int, int);
u_char *cos_common_cname_without_crecord (G_List *, int *);
int cos_common_change_target (Context *, u_char * target, int, u_int16_t);
int cos_common_find_ns (Context *, RRset **);
int cos_common_start_rq (Context *, int);
int cos_common_waiting_recursive_process (Context *);
int cos_common_tcp_writemesg (Context *, int);
int cos_tcp_request_start (struct context *, u_char *, int, u_int16_t, u_int16_t);
int cos_tcp_request_wait_connect_process (Context *);
int cos_tcp_request_wait_connect_retry (Context *);
int cos_tcp_request_writing_process (Context *);
int cos_tcp_request_writing_retry (Context *);
int cos_tcp_request_readlen_process (Context *);
int cos_tcp_request_readlen_retry (Context *);
int cos_tcp_request_reading_process (Context *);
int cos_tcp_request_reading_retry (Context *);
void cos_tcp_request_destroy (Context *);
void cos_tcp_request_abort (Context *);
int cos_tcp_request_finish (Context *);
int cos_tcp_response_start (int, struct sockaddr *, int);
int cos_tcp_response_readlen_process (Context *);
int cos_tcp_response_readlen_retry (Context *);
int cos_tcp_response_reading_process (Context *);
int cos_tcp_response_reading_retry (Context *);
int cos_tcp_response_waiting_recursive_process (Context *);
int cos_tcp_response_waiting_recursive_retry (Context *);
int cos_tcp_response_writing_process (Context *);
int cos_tcp_response_writing_retry (Context *);
int cos_tcp_response_waiting_client_close_process (Context *);
int cos_tcp_response_waiting_client_close_retry (Context *);
void cos_tcp_response_destroy (Context *);
void cos_tcp_response_abort (Context *);
int cos_tcp_response_finish (Context *);
int cos_udp_request_start (struct context *, u_char *, int, u_int16_t, u_int16_t);
int cos_udp_request_sended_process (Context *);
int cos_udp_request_sended_retry (Context *);
void cos_udp_request_destroy (Context *);
int cos_udp_request_abort (Context *);
int cos_udp_request_finish (Context *);
int cos_udp_response_start (u_char *, int, int, struct sockaddr *, int, NI_List *);
int cos_udp_response_waiting_recursive_process (Context *);
int cos_udp_response_waiting_recursive_retry (Context *);
int cos_udp_response_destroy (Context *);
int cos_udp_response_abort (Context *);
int cos_udp_response_finish (Context *);
int context_timeout_handler (struct ev_to_data *);
struct ev_to_data *context_timeout_register (Context *, int);
void context_destroy (Context *);
RRset *conv_trick_rrset (RRset *, int);
void conv_trick_list (G_List *);
void conv_trick_ptr (G_List *, u_char *);
int conv_trick_conf (u_char *);
int conv_trick_is_tot_ptr (u_char *);
void conv_trick_ptr_rq (u_char * qname);
void ev_dup_init (int);
int ev_dup_hashval (struct sockaddr *, u_int16_t, u_int16_t);
int ev_dup (struct sockaddr *, u_int16_t, u_int16_t);
void ev_main (int);
int ev_signal_init (void);
void ev_signal_process (void);
void ev_signal_finish (void);
int ev_tcp_common_eq (void *, void *);
G_List *ev_tcp_common_init (void);
int ev_tcp_common_register (G_List *, int, Context *);
int ev_tcp_common_remove (G_List *, int);
int ev_tcp_common_fds (G_List *, fd_set *);
int ev_tcp_common_fd_check (G_List *, fd_set *);
int ev_tcp_conn_in_init (void);
void ev_tcp_conn_in_finish (void);
int ev_tcp_conn_in_register (int, Context *);
int ev_tcp_conn_in_remove (int);
int ev_tcp_conn_in_fds (fd_set *);
int ev_tcp_conn_in_fd_check (fd_set *);
int ev_tcp_out_init (void);
void ev_tcp_out_finish (void);
int ev_tcp_out_register (int, Context *);
int ev_tcp_out_remove (int);
int ev_tcp_out_fds (fd_set *);
int ev_tcp_out_fd_check (fd_set *);
int ev_tcp_srv_in_init (int, int);
int ev_tcp_srv_accept (int);
int ev_to_init (void);
int ev_to_register (Ev_TO_Data *);
time_t ev_timeout_process (void);
void ev_to_data_free (Ev_TO_Data *);
void ev_to_data_free_v (void *);
void ev_to_finish (void);
int ev_to_handler_ifcheck (Ev_TO_Data *);
int ev_udp_in_eq (void *, void *);
void ev_udp_in_data_free (Ev_UDP_In_Data * _p);
void ev_udp_in_data_free_v (void *_vp);
NI_List *ev_udp_in_init (int);
void ev_udp_in_finish (void);
int ev_udp_in_register (Context *, struct sockaddr *, int, u_int16_t);
int ev_udp_in_remove (struct sockaddr *, int);
int ev_udp_in_read (int);
int seqdump (char *, u_char *, int);
void fwd_free (Fwd *);
void fwd_freev (void *);
Fwd *fwd_alloc (struct sockaddr *, int);
void fwd_init (void);
void fwd_finish (void);
int fwd_add (struct sockaddr *, int);
int fwd_del (struct sockaddr *, int);
void fwd_select (void);
int fwd_select_next (void);
char *sprint_inet(struct sockaddr *);
G_List *list_init (void);
int list_add (G_List *, void *);
int list_add_tail (G_List *, void *);
G_List *list_search (G_List *, void *, int (*comp_func) (void *, void *));
void *list_delete (G_List *);
void list_destroy (G_List *, void (*freefnc) (void *));
G_List *list_dup (G_List *, void (freefunc) (void *), void *(dupfunc) (void *));
void list_cat (G_List * list, G_List * toadd);
void list_move_f (G_List * to, G_List * from, void (*freefnc) (void *));
struct sockaddr *net_parse_alloc_addr (char *, int, int *);
int net_sockaddr_cmp (struct sockaddr *, int, struct sockaddr *, int, int);
int net_ifc_cmp (u_char *, u_char *, int);
int net_addr_len (int);
struct sockaddr *net_sockaddr_alloc (int, u_char *, int, int);
NI_List *ni_list_alloc (struct sockaddr *, int);
void ni_free (NI_List *, int);
void ni_list_destroy (NI_List *);
void ni_list_print (int);
NI_List *ni_find_by_sock (int);
NI_List *ni_find_by_addr (struct sockaddr *);
void ni_fds_set (fd_set *, int *);
NI_List *ni_fds_isset (fd_set *);
int ni_set_wildsock (void);
NI_List *ni_default (int);
int ni_default_sock (int);
NI_List *ni_copy (NI_List *);
int net_stream_socket (u_int16_t, int);
int net_stream_connect (u_int16_t, u_char *, int, u_int16_t);
NI_List *net_mesg_getif (int, int);
void net_mesg_getif_finish (void);
int net_mesg_socket (NI_List *, int);
int net_mesg_send (NI_List *, u_char *, int, struct sockaddr *);
u_int16_t mesg_id (void);
int mesg_make_query (u_char *, u_int16_t, u_int16_t, u_int32_t, int, u_char *, int);
int mesg_dname_copy (u_char *, u_char *, int);
u_char *mesg_dname_redirect (u_char *, u_char *);
int mesg_write_dname (u_char *, u_char *, u_int16_t *, int, u_char *, u_char *);
u_char *mesg_skip_dname (u_char * dname);
int mesg_dname_cmp (u_char *, u_char *, u_char *);
int mesg_write_rrset_list (G_List *, u_char *, u_char *, u_int16_t *, int, u_char **, u_int16_t *);
int mesg_assemble (Mesg_Hdr *, G_List *, G_List *, G_List *, u_char *, u_int16_t, int);
void rrset_couple_free (RRset_Couple *);
void rrset_couple_freev (void *);
int mesg_rdata_cmp (u_int16_t, u_int16_t, u_char *, u_char *, u_char *);
int mesg_extract_rr (u_char *, u_char *, u_int16_t, u_int16_t, u_char *, u_char *, int);
u_char *mesg_read_sec (int, u_char *, u_char *, u_char *, G_List *);
u_char *mesg_read_sec_in_order (int, u_char *, u_char *, u_char *, G_List *);
int mesg_parse (u_char *, int, G_List *, G_List *, G_List *);
int mesg_parse_upd (u_char *, int, G_List *, G_List *, G_List *);
Q_Set *queue_create (void);
void queue_destroy (Q_Set *, void (*freefnc) (void *));
int enqueue (Q_Set *, void *);
void *dequeue (Q_Set *);
void *queue_peek (Q_Set *);
void *queue_disable (G_Queue *);
int read_config (char *);
RR *rr_alloc (u_int32_t, int, u_char *);
RR_List *rr_list_alloc (void);
void rr_list_free (RR_List *);
RR_List *rr_list_add (RR_List *, u_int32_t, int, u_char *);
RR *rrset_get_rr_f (int, RRset *);
RR_List *rr_list_of_rrset (RRset *);
RRset *rrset_alloc (void);
RRset *rrset_create (u_int16_t, u_int16_t, u_int16_t, u_char *, RR_List *);
RRset *rrset_create_single (u_char *, int, u_int16_t, u_int16_t, u_int32_t, u_int16_t, u_char *);
void rrset_freev (void *);
void rrset_free (RRset *);
RRset *rrset_copy (RRset *);
void *rrset_copyv (void *);
RRset *rrset_dup (RRset *);
void rrset_list_dump (G_List *, FILE *);
u_char *conv_dname_decompress (u_char *, int, u_char *, u_char *, u_char *, int *);
u_char *conv_rdata2string (u_char *, int, int, int, u_char *, u_char *, u_char *);
char *string_opcode (u_int16_t);
char *string_rclass (u_int16_t);
char *string_rtype (u_int16_t);
void tot_exit (int);

int conv_scoped_query __P((NI_List *, Context *));
int conv_scoped_conf __P((const char *, const char *, int));
void conv_scoped_list __P((G_List *));
int conv_is_scoped_ptr __P((u_char *, int));
void conv_scoped_ptr __P((G_List *, u_char *));
void conv_scoped_ptr_rq __P((u_char *));
#endif
