/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/
/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ns_var.h,v 3.6 1999/08/17 16:52:10 feico Exp $>
 */

#ifndef NS_VAR_H
#define NS_VAR_H

typedef struct mesg_hdr {
	u_int16_t id;		/* query id */
#if BYTE_ORDER == BIG_ENDIAN
	/* 3rd byte */
	u_char qr:1;		/* is it query(0) or answer(1)? */
	u_char opcode:4;	/* what's the message for? */
	u_char aa:1;		/* is it authoritive(true)? */
	u_char tc:1;		/* is it truncated(true)? */
	u_char rd:1;		/* recursion requied(true)? */
	/* 4th byte */
	u_char ra:1;		/* recursion avilable(true)? */
	u_char zero:3;		/* for future use */
	u_char rcode:4;		/* response code */
#elif BYTE_ORDER == LITTLE_ENDIAN
	/* 3rd byte */
	u_char rd:1;		/* recursion requied(true)? */
	u_char tc:1;		/* is it truncated(true)? */
	u_char aa:1;		/* is it authoritive(true)? */
	u_char opcode:4;	/* what's the message for? */
	u_char qr:1;		/* is it query(0) or answer(1)? */
	/* 4th byte */
	u_char rcode:4;		/* response code */
	u_char zero:3;		/* for future use */
	u_char ra:1;		/* recursion avilable(true)? */
#else
#error Specify ENDIAN in config.h
#endif
	u_int16_t qdcnt;	/* question count */
	u_int16_t ancnt;	/* answer count */
	u_int16_t nscnt;	/* ns info count */
	u_int16_t arcnt;	/* additional record count */
}   Mesg_Hdr;

typedef struct upd_hdr {
	u_int16_t id;		/* query id */
#if BYTE_ORDER == BIG_ENDIAN
	/* 3rd byte */
	u_char qr:1;		/* is it query(0) or answer(1)? */
	u_char opcode:4;	/* what's the message for? */
	u_char zero_a:3;	/* zero */
	/* 4th byte */
	u_char zero_b:4;	/* zero */
	u_char rcode:4;		/* response code */
#elif BYTE_ORDER == LITTLE_ENDIAN
	/* 3rd byte */
	u_char zero_a:3;	/* zero */
	u_char opcode:4;	/* what's the message for? */
	u_char qr:1;		/* is it query(0) or answer(1)? */
	/* 4th byte */
	u_char rcode:4;		/* response code */
	u_char zero_b:4;	/* zero */
#else
#error Specify ENDIAN in config.h
#endif
	u_int16_t zocnt;	/* zone count */
	u_int16_t prcnt;	/* prerequisite count */
	u_int16_t upcnt;	/* update count */
	u_int16_t arcnt;	/* additional record count */
}   Upd_Hdr;

typedef union mesg {
	Mesg_Hdr *hdr;
	u_char *p;
}   Mesg;

#endif				/* NS_VAR_H */
