/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ne_io.h,v 3.7 1999/08/17 16:52:10 feico Exp $>
 */

#ifndef NE_IO_H
#define NE_IO_H

typedef struct net_if_list {
	struct net_if_list *next;	/* next interface */
	struct sockaddr *sa_p;	/* pointer to sockaddr (each allocated) */
	int sock;		/* if sock>=0, socket opened for this IF */
}   NI_List;

#ifdef IPV6
#define NET_SOCKADDR_PORT(sa_p)\
(((sa_p)->sa_family == AF_INET)\
 ? (((struct sockaddr_in*)sa_p)->sin_port)\
 : (((sa_p)->sa_family == AF_INET6) \
    ? (((struct sockaddr_in6*)sa_p)->sin6_port) : 0))
#define NET_SOCKADDR_ADDR(sa_p)\
(((sa_p)->sa_family == AF_INET)\
 ? (((struct sockaddr_in*)sa_p)->sin_addr)\
 : (((sa_p)->sa_family == AF_INET6) \
    ? (((struct sockaddr_in6*)sa_p)->sin6_addr) : 0))

#define NET_SOCKADDR_ADDR_STRING(sa_p)\
(((sa_p)->sa_family == AF_INET)\
 ? (addr2ascii(AF_INET,(void*)&(((struct sockaddr_in*)sa_p)->sin_addr),\
	       IPV4_ADDR_LEN,NULL))\
 : (((sa_p)->sa_family == AF_INET6) \
    ? (addr2ascii(AF_INET6,(void*)&(((struct sockaddr_in6*)sa_p)->sin6_addr),\
		  IPV6_ADDR_LEN,NULL))\
    : ""))

#else
#define NET_SOCKADDR_PORT(sa_p)\
(((sa_p)->sa_family == AF_INET)\
 ? (((struct sockaddr_in*)sa_p)->sin_port) : 0)
#define NET_SOCKADDR_ADDR(sa_p)\
(((sa_p)->sa_family == AF_INET)\
 ? (((struct sockaddr_in*)sa_p)->sin_addr) : 0)
#define NET_SOCKADDR_ADDR_STRING(sa_p)\
(((sa_p)->sa_family == AF_INET)\
 ? (inet_ntoa(((struct sockaddr_in*)sa_p)->sin_addr)) : "")
#endif				/* IPV6 */

#define NET_SOCKADDR_CMP_IGNORE_PORT (1<<1)

#endif				/* NE_IO_H */
