/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 */

#ifndef MACROS_H
#define MACROS_H

#include "config.h"
#include "tot.h"
#include "ns_const.h"

#define COPYRIGHT1(string) \
        static const char copyright1[] __attribute__((__unused__)) = string
#define COPYRIGHT2(string) \
        static const char copyright2[] __attribute__((__unused__)) = string
#define COPYRIGHT3(string) \
        static const char copyright3[] __attribute__((__unused__)) = string
#define CVSID(string) \
        static const char cvsid[] __attribute__((__unused__)) = string

/*
  macro ROOTPRIV_ENABLE
  enable root priviledge mode
*/
/*
  macro ROOTPRIV_DISABLE
  disable root priviledge mode
*/
#ifdef TOT_USER_LOGLVL
#define ROOTPRIV_ENABLE_LOG(mesg) syslog(TOT_USER_LOGLVL, "Priv.Enable: %s", mesg);
#define ROOTPRIV_DISABLE_LOG(mesg) syslog(TOT_USER_LOGLVL, "Priv.Disable: %s", mesg);
#else
#define ROOTPRIV_ENABLE_LOG(mesg)
#define ROOTPRIV_DISABLE_LOG(mesg)
#endif

#ifdef TOT_USER
#define ROOTPRIV_ENABLE(mesg) if(T.su == 0){seteuid(0);setegid(0);T.su = 1;ROOTPRIV_ENABLE_LOG(mesg);}else{syslog(LOG_ERR, "Duplicate ROOTPRIV_ENABLE\n");}
#define ROOTPRIV_DISABLE(mesg) {seteuid(T.tot_uid); setegid(T.tot_gid);T.su = 0;ROOTPRIV_DISABLE_LOG(mesg);}
#else
#define ROOTPRIV_ENABLE(mesg)
#define ROOTPRIV_DISABLE(mesg)
#endif

/*
  macro CHOP(char* str);
  cut off last char.
*/
#define CHOP(str)  (str[strlen(str)-1] = '\0')

/*
  macro MINNUM(x,y);
  return minimum number of x and y.
  */
#define MINNUM(x,y) (((x)>(y)) ? (y) : (x))

/*
  macro MAXNUM(x,y);
  return maximum number of x and y.
  */
#define MAXNUM(x,y) (((x)>(y)) ? (x) : (y))

/*
  macro SKIP_DNAME(char* dname);
  skip domainname
  [warning] this macro doesnt care about INDIRECTION MASK...
  */
#define SKIP_DNAME(dname)  for(; *(dname) != 0; (dname) += (*(dname) + 1)) \
                             ; /* just skip it */ \
                           dname++;	/* push away the null terminator */

/*
  macro FOR_DNAME(char* dname)
  for statement for domain name
  use this as following:
    FOR_DNAME(cp){
      offset[i++] = cp;
    }
    cp++;
  Don't forget to push away the null terminator!
  */
#define FOR_DNAME(dname)  for(; *(dname) != 0; (dname) += (*(dname) + 1))

/*
  macro IS_FQDN(char* dname)
  check if the dname is FQDN or not.
*/
#define IS_FQDN(dname)    ((dname[strlen(dname)-1] == '.')?1:0)

/** these get/put short/long is copied from BIND destribution **/
/*
 * Inline versions of get/put short/long.
 * Pointer is advanced; we assume that both arguments
 * are lvalues and will already be in registers.
 * cp MUST be u_char *.
 */
#define GETSHORT(us, ucp) { \
	(us) = *(ucp)++ << 8; \
	(us) |= *(ucp)++; \
}

#define GETLONG(ul, ucp) { \
	(ul) = *(ucp)++ << 8; \
	(ul) |= *(ucp)++; (ul) <<= 8; \
	(ul) |= *(ucp)++; (ul) <<= 8; \
	(ul) |= *(ucp)++; \
}

#define PUTSHORT(us, ucp) { \
	*(ucp)++ = (us) >> 8; \
	*(ucp)++ = (us); \
}

/*
 * Warning: PUTLONG destroys its first argument.
 */
#define PUTLONG(ul, ucp) { \
	(ucp)[3] = ul; \
	(ucp)[2] = (ul >>= 8); \
	(ucp)[1] = (ul >>= 8); \
	(ucp)[0] = ul >> 8; \
	(ucp) += sizeof(u_int32_t); \
}

/*
  get size of sockaddr structure
*/
#define SOCKADDR_SIZEOF(sa) (MAXNUM((sa).sa_len, sizeof(sa)))

/* debug execution */
#ifdef NDEBUG
#define DX(x)
#else
#define DX(x) x
#endif

#ifdef USE_INET6
#define V6(x) x
#else
#define V6(x)
#endif

#ifdef USE_INET4
#define V4(x) x
#else
#define V4(x)
#endif

#endif				/* MACROS_H */
