/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/
/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ev_udp_in.c,v 3.11 1999/08/17 16:52:09 feico Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: ev_udp_in.c,v 3.11 1999/08/17 16:52:09 feico Exp $");

G_List *UDPL_head;		/* UDP head */
G_List *UDPL_tail;		/* tail */

int ev_udp_in_eq (void *arg1, void *arg2)
{
	Ev_UDP_In_Data *e1;
	Ev_UDP_In_Data *e2;
	int sa_len;

	e1 = (Ev_UDP_In_Data *) arg1;
	e2 = (Ev_UDP_In_Data *) arg2;

	if (e1 == NULL || e2 == NULL || e1->sa_p == NULL || e2->sa_p == NULL) {
		return -1;
	}
	sa_len = SOCKADDR_SIZEOF (*(e1->sa_p));

	if ((SOCKADDR_SIZEOF (*(e1->sa_p)) == SOCKADDR_SIZEOF (*(e2->sa_p)))
	    && (memcmp (e1->sa_p, e2->sa_p, sa_len) == 0)
	    && (e1->id == e2->id)) {
		return 0;	/* the same */
	} else
		return 1;	/* not same */

}

void ev_udp_in_data_free (Ev_UDP_In_Data * euid_p)
{
	DX (syslog (LOG_DEBUG, "ev_udp_in_data_free(): Ev_UDP_In_Data(%p)\n", euid_p));

	if (euid_p) {
		if (euid_p->sa_p)
			free (euid_p->sa_p);
		free (euid_p);
	}
	return;
}

void ev_udp_in_data_free_v (void *euid_vp)
{
	ev_udp_in_data_free ((Ev_UDP_In_Data *) euid_vp);
	return;
}

NI_List *ev_udp_in_init (int tcp_srvsock)
{
	NI_List *ni_l;

	ni_l = net_mesg_getif (tcp_srvsock, PORT_SRV);
	if (!ni_l) {
		syslog (LOG_ERR, "ev_udp_in_init(): no interface found.\n");
		return NULL;
	}
	UDPL_head = list_init ();
	if (!UDPL_head) {
		return NULL;
	}
	UDPL_tail = UDPL_head;
	UDPL_head->list_data = NULL;

	return ni_l;
}

void ev_udp_in_finish (void)
{
	net_mesg_getif_finish ();
	list_destroy (UDPL_head, ev_udp_in_data_free_v);
}

int ev_udp_in_register (Context * cptr, struct sockaddr * sa_p, int sa_len,
			    u_int16_t id)
{
	const char *fn = "ev_udp_in_register()";
	Ev_UDP_In_Data *euid_new = NULL;
	int status = 0;

	DX (syslog (LOG_DEBUG, "%s: id=%d", fn, id));

	euid_new = malloc (sizeof (Ev_UDP_In_Data));
	if (!euid_new) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto error;
	}
	euid_new->sa_p = malloc (sa_len);
	if (!euid_new->sa_p) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto error;
	}
	memcpy (euid_new->sa_p, sa_p, sa_len);
	euid_new->cptr = cptr;
	euid_new->id = id;

	if (list_add (UDPL_head, euid_new) < -1) {
		status = -1;
		goto error;
	}
	DX (syslog (LOG_DEBUG, "%s: Ev_UDP_In_Data(%p)\n", fn, euid_new));
	return 0;
	/* NOTREACHED */

error:
	ev_udp_in_data_free (euid_new);
	return status;
}

int ev_udp_in_remove (struct sockaddr * sa_p, int id)
{
	Ev_UDP_In_Data euid_tmp;
	Ev_UDP_In_Data *euid_p;
	G_List *gl_tmp;

	euid_tmp.sa_p = sa_p;
	euid_tmp.id = id;

	gl_tmp = list_search (UDPL_head, (void *) &euid_tmp, ev_udp_in_eq);
	if (!gl_tmp)
		return -1;

	euid_p = (Ev_UDP_In_Data *) list_delete (gl_tmp);
	ev_udp_in_data_free (euid_p);

	return 0;
}

int ev_udp_in_read (int sock)
{
	const char *fn = "ev_udp_in_read()";
	int status = 0;
	Mesg_Hdr *mesg;
	u_char *newbuf;
	int mesg_len;
	struct sockaddr *sa_recv;
#ifdef USE_INET6
	char sa_buf[sizeof (struct sockaddr_in6)];
#elif defined(USE_INET4)
	char sa_buf[sizeof (struct sockaddr_in)];
#endif
	int sa_len;
	G_List *gl_tmp;
	Ev_UDP_In_Data euid_tmp;
	Ev_UDP_In_Data *euid_p;
	NI_List *ni_l;
	Context *cont;

	/* receive sockaddr -- be careful! */
	sa_recv = (struct sockaddr *) sa_buf;

	/* allocate buffer */
	newbuf = malloc (MAX_PACKET);
	if (!newbuf) {
		syslog (EM_F (EM_F_MEMEX), fn);
		return -1;
	}
	mesg = (Mesg_Hdr *) newbuf;

	/* read packet */
	sa_len = sizeof (sa_buf);
	memset ((void *) sa_recv, 0, sa_len);
	mesg_len = recvfrom (sock, newbuf, MAX_PACKET, 0, sa_recv, &sa_len);
	if (mesg_len < 0) {
		syslog (LOG_ERR, "recvfrom: %m");
		status = -1;
		goto error;
	}
	DX (syslog (LOG_DEBUG, "%s: read from sockid %d, len %d.", fn, sock, mesg_len));

	/* check dup */
	if (ev_dup (sa_recv, sa_len, mesg->id) <0) {
		/* duplicate */
		DX (syslog (LOG_DEBUG, "%s: duplicated request.", fn));
		status = 0;
		goto error;
	}
	/* identify */
	euid_tmp.sa_p = sa_recv;
	euid_tmp.id = mesg->id;
	gl_tmp = list_search (UDPL_head, (void *) &euid_tmp, ev_udp_in_eq);

	if (!gl_tmp) {
		if (mesg->qr == 1) {
			/* unknown response -- just ignore */
			DX (syslog (LOG_DEBUG, "%s: unknown UDP response--just ignore.", fn));
			status = 0;
			goto error;
		} else {
			/* new transaction */
			DX (syslog (LOG_DEBUG, "%s: this is query. create new transaction", fn));
			ni_l = ni_find_by_sock (sock);
			if (!ni_l) {
				syslog (LOG_ERR, "unknown socket for network interface.");
				status = -1;
				goto error;
			}
			return cos_udp_response_start (newbuf, mesg_len, MAX_PACKET, sa_recv, sa_len, ni_l);
		}
	} else {
		DX (syslog (LOG_DEBUG, "%s: resume transaction.", fn));

		euid_p = (Ev_UDP_In_Data *) gl_tmp->list_data;

		/* euid_p may be released within context processing */
		cont = euid_p->cptr;

		/* replace message buffer */
		if (cont->mesg.p) {
			free (cont->mesg.p);
		}
		cont->mesg.p = newbuf;
		cont->mesg_len = mesg_len;
		cont->buf_len = MAX_PACKET;
		cont->wp = NULL;/* now ``wp'' has no meaning */

		/* process context */
		status = (cont->process) (cont);
		/* context shall release the timeout event */
	}

	return 0;

	/* NOTREACHED */

error:
	if (newbuf) {
		free (newbuf);
	}
	return status;
}
