/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ev_timeout.c,v 3.10 1999/09/29 15:09:28 feico Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: ev_timeout.c,v 3.10 1999/09/29 15:09:28 feico Exp $");

static Q_Set *ev_to_queue;

int ev_to_init (void)
{

	ev_to_queue = queue_create ();
	if (!ev_to_queue)
		return -1;

	ev_to_handler_ifcheck (NULL);
	return 0;
}

int ev_to_register (Ev_TO_Data * td)
{
	char *fn = "ev_to_register()";
	G_Queue *gq_new, *gq_tmp, *gq_prev;

	gq_new = malloc (sizeof (G_Queue));
	if (!gq_new) {
		syslog (LOG_ERR, "%s: out of memory.", fn);
		return -1;
	}
	gq_prev = NULL;
	for (gq_tmp = ev_to_queue->head;
	     gq_tmp->next && ((Ev_TO_Data *) (gq_tmp->p))->at < td->at;
	     gq_tmp = gq_tmp->next)
		gq_prev = gq_tmp;	/* just skip */

	if (!gq_prev) {
		DX (syslog (LOG_DEBUG, "%s: add event to head of queue.", fn));
		gq_new->p = (void *) td;
		gq_new->next = ev_to_queue->head;
		ev_to_queue->head = gq_new;
	} else {
		while (gq_tmp->p && (((Ev_TO_Data *) (gq_tmp->p))->at == td->at)) {
			gq_prev = gq_tmp;
			gq_tmp = gq_tmp->next;
		}
		if (!gq_tmp->p) {
			DX (syslog (LOG_DEBUG, "%s: add event to tail of queue.", fn));
			ev_to_queue->tail->p = (void *) td;
			ev_to_queue->tail->next = gq_new;
			gq_new->p = NULL;
			gq_new->next = NULL;
			ev_to_queue->tail = gq_new;
		} else {
			DX (syslog (LOG_DEBUG, "%s: add event to mid of queue.", fn));
			gq_new->p = (void *) td;
			gq_prev->next = gq_new;
			gq_new->next = gq_tmp;
		}
	}

#ifdef CHECK_QUEUE_LEN
	ev_to_queue->queue_len++;
	DX (syslog (LOG_DEBUG, "%s: queue_len = %d", fn, ev_to_queue->queue_len));
#endif				/* CHECK_QUEUE_LEN */

	return 0;
}

time_t ev_timeout_process (void)
{
	DX (char *fn = "ev_timeout_process()";
	)
		Ev_TO_Data *td_tmp;

	while ((td_tmp = (Ev_TO_Data *) queue_peek (ev_to_queue))
	       && (td_tmp->at <= time (NULL))) {
		/* process the event */
		td_tmp = dequeue (ev_to_queue);
		if (td_tmp->handler) {
			DX (syslog (LOG_DEBUG, "%s: calling timeout handler.", fn));
			(td_tmp->handler) (td_tmp);	/* <- call handler */
		} else
			DX (syslog (LOG_DEBUG, "%s: cancelled timeout event found.", fn));
		ev_to_data_free (td_tmp);
	}

	td_tmp = (Ev_TO_Data *) queue_peek (ev_to_queue);
	if (td_tmp)
		return td_tmp->at;	/* next event scheduled time */
	else
		return 0;	/* no event scheduled */
}

void ev_to_data_free (Ev_TO_Data * td)
{
	char *fn = "ev_to_data_free()";

	switch (td->type) {
	case EV_TIMEOUT_NULL:
		if (td->data.p)
			free (td->data.p);
		break;
	case EV_TIMEOUT_CONTEXT:
		/* dont free td->data.cont because it frees of itself */
		break;
	default:
		syslog (LOG_ERR, "%s: unknown data type for timeout event.", fn);
		syslog (LOG_ERR, "%s: PROGRAM ERROR: possibly memory leak.", fn);
		break;
	}

	free (td);
}

void ev_to_data_free_v (void *td_v)
{
	ev_to_data_free ((Ev_TO_Data *) td_v);
}

void ev_to_finish (void)
{
	queue_destroy (ev_to_queue, ev_to_data_free_v);
}

void ev_to_flush (int type)
{
	G_Queue *gqp;
	Ev_TO_Data *etdp;

	/* check one by one */
	for (gqp = ev_to_queue->head; gqp->next; gqp = gqp->next) {
		if (gqp->p) {
			etdp = (Ev_TO_Data *) (gqp->p);
			if (etdp->type == type) {
				if (etdp->handler)
					(etdp->handler) (etdp);	/* handler call */
				etdp->handler = NULL;	/* disable the queue */
			}
		}
	}
	return;
}

int ev_to_handler_ifcheck (Ev_TO_Data * td)
{
	char *fn = "ev_to_handler_ifcheck()";
	Ev_TO_Data *td_new;

	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	/* check it -- XXX error handling? */
	if (td) {
 		ROOTPRIV_ENABLE ("Event: interface check");
		if (!net_mesg_getif (-1, PORT_SRV))
			syslog (LOG_ERR, "%s: fatal error: can't get new interface list.\n", fn);
 		ROOTPRIV_DISABLE ("Event: interface check");
	}

	/* re-register my event */
	td_new = malloc (sizeof (Ev_TO_Data));
	if (!td_new) {
		syslog (LOG_ERR, "%s: can't allocate new event.\n", fn);
		return -1;
	}
	td_new->at = time (NULL) + IF_CHECK_INTERVAL;
	td_new->handler = ev_to_handler_ifcheck;
	td_new->type = EV_TIMEOUT_NULL;
	td_new->data.p = NULL;

	ev_to_register (td_new);
	return 0;
}
