/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ev_tcp_common.c,v 3.7 1999/08/17 16:52:09 feico Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: ev_tcp_common.c,v 3.7 1999/08/17 16:52:09 feico Exp $");

int ev_tcp_common_eq (void *arg1, void *arg2)
{
	Ev_TCP_Common_Data *etcd_arg1;
	Ev_TCP_Common_Data *etcd_arg2;

	etcd_arg1 = arg1;
	etcd_arg2 = arg2;

	if (etcd_arg1->sock == etcd_arg2->sock)
		return 0;
	else
		return 1;
}

G_List *
    ev_tcp_common_init (void)
{
	G_List *gl;

	if ((gl = list_init ()) == NULL) {
		syslog (LOG_ERR, "memory exhausted.\n");
		return NULL;
	}
	gl->list_data = NULL;
	return gl;
}

int ev_tcp_common_register (G_List * gl, int sock, Context * cptr)
{
	Ev_TCP_Common_Data *etcd_new;

	DX (syslog (LOG_DEBUG, "ev_tcp_common_register(sock = %d)", sock));

	if ((etcd_new = malloc (sizeof (Ev_TCP_Common_Data))) == NULL) {
		syslog (LOG_ERR, "ev_tcp_common_regsiter(): memory exhausted.");
		return -1;
	}
	etcd_new->sock = sock;
	etcd_new->cptr = cptr;

	if (list_add (gl, etcd_new) < 0)
		return -1;

	return 0;
}

int ev_tcp_common_remove (G_List * gl, int sock)
{
	Ev_TCP_Common_Data etcd_tmp;
	Ev_TCP_Common_Data *etcd_p;
	G_List *gl_tmp;

	DX (syslog (LOG_DEBUG, "ev_tcp_common_remove(sock = %d)", sock));

	etcd_tmp.sock = sock;
	etcd_tmp.cptr = NULL;

	gl_tmp = list_search (gl, (void *) &etcd_tmp, ev_tcp_common_eq);
	if (gl_tmp == NULL)
		return -1;

	etcd_p = (Ev_TCP_Common_Data *) list_delete (gl_tmp);
	free (etcd_p);

	return 0;
}

int ev_tcp_common_fds (G_List * gl, fd_set * fds)
{
	G_List *gl_tmp;
	int maxid = 0;

	gl->list_data = NULL;
	for (gl_tmp = gl->next; gl_tmp->list_data != NULL; gl_tmp = gl_tmp->next) {
		DX (syslog (LOG_DEBUG, "ev_tcp_common_fds: FD_SET(%d)",
		       ((Ev_TCP_Common_Data *) (gl_tmp->list_data))->sock));
		FD_SET (((Ev_TCP_Common_Data *) (gl_tmp->list_data))->sock, fds);
		maxid = MAXNUM (((Ev_TCP_Common_Data *) (gl_tmp->list_data))->sock, maxid);
	}

	return maxid;
}

int ev_tcp_common_fd_check (G_List * gl, fd_set * fds)
{
	G_List *gl_tmp;
	Context *cont;
	Ev_TCP_Common_Data *etcd_p;
	int s_tmp;

	for (gl_tmp = gl->next; gl_tmp->list_data != NULL; gl_tmp = gl_tmp->next) {
		etcd_p = (Ev_TCP_Common_Data *) (gl_tmp->list_data);
		s_tmp = etcd_p->sock;

		if (FD_ISSET (s_tmp, fds)) {
			FD_CLR (s_tmp, fds);

			/*
			 * etcd_p MAY be released within context, so keep
			 * context alone
			 */
			cont = etcd_p->cptr;

			/* resume context */
			return cont->process (cont);
		}
	}
	return 0;
}
