/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: ev_main.c,v 3.15 2000/01/20 18:36:16 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: ev_main.c,v 3.15 2000/01/20 18:36:16 dillema Exp $");

void ev_main (int port)
{
#ifdef USE_INET4
	int tcp_srv_sock = -1;
#endif
#ifdef USE_INET6
	int tcp_srv_sock6 = -1;
#endif
	time_t next_timeout;
	fd_set fd_read;
	fd_set fd_write;
	NI_List *ni_tmp;
	struct timeval tv_out;
	struct timeval *tvp;
	int max_fd;
	int fdnum;
	int i;

#ifdef DBMALLOC
	unsigned long histid1, histid2, orig_size, current_size;
#endif

	/* initialize each event routines */
	ev_dup_init (60);
	if (ev_signal_init () < 0) {
		fprintf (stderr, "Signal event handling routine initialize failed.\n");
		tot_exit (-1);
	}
	if (ev_to_init () < 0) {
		fprintf (stderr, "Timeout event handling routine initialize failed.\n");
		tot_exit (-1);
	}
	ROOTPRIV_ENABLE ("Event: initialize");

#ifdef USE_INET4
	if (T.ip4) {
		tcp_srv_sock = ev_tcp_srv_in_init (port, AF_INET);
		if (tcp_srv_sock < 0) {
			fprintf (stderr, "TCP service socket routine initialize failed.\n");
			tot_exit (-1);
		}
	}
#endif
#ifdef USE_INET6
	if (T.ip6)
		tcp_srv_sock6 = ev_tcp_srv_in_init (port, AF_INET6);
	if (tcp_srv_sock6 < 0) {
		fprintf (stderr, "TCP service socket routine initialize failed.\n");
		tot_exit (-1);
	}
#endif

	if (ev_tcp_conn_in_init () < 0) {
		fprintf (stderr, "TCP connection routine initialize failed.\n");
		tot_exit (-1);
	}
#ifdef USE_INET4
	if (tcp_srv_sock < 0)
#endif
#ifdef USE_INET6
		if (tcp_srv_sock6 < 0)
#endif
		{
			fprintf (stderr, "no TCP socket activated. can't continue.\n");
			tot_exit (-1);
		}
#ifdef USE_INET6
		else
			i = tcp_srv_sock6;
#endif
#ifdef USE_INET4
	else
		i = tcp_srv_sock;
#endif

	if (ev_udp_in_init (i) == NULL) {
		fprintf (stderr, "UDP socket routine initialize failed.\n");
		tot_exit (-1);
	}
	if (ev_tcp_out_init () < 0) {
		fprintf (stderr, "TCP output routine initialize failed.\n");
		tot_exit (-1);
	}
	ROOTPRIV_DISABLE ("Event: initialize");

#ifdef DBMALLOC
	/* Malloc debugging */
	malloc_dump (2);
	orig_size = malloc_inuse (&histid1);
	syslog (LOG_DEBUG, "\n\nMalloc Size: %ld", orig_size);
#endif

	while (1) {		/* main loop */
		ROOTPRIV_DISABLE ("Event: mainloop");

		DX (syslog (LOG_DEBUG, "main loop: start"));

		/* pick a proper forwarder */
		fwd_select ();

#ifdef DBMALLOC
		/* Malloc debugging */
		current_size = malloc_inuse (&histid2);

		if (current_size != orig_size) {
			syslog (LOG_DEBUG, "\n\nMalloc Size: %ld", current_size);
			malloc_list (2, histid1, histid2);
			orig_size = current_size;
			/* histid1 = histid2; */
		}
#endif

		/* signal event */
		ev_signal_process ();

		/* timeout event */
		next_timeout = ev_timeout_process ();
		if (!next_timeout) {
			DX (syslog (LOG_DEBUG, "no timeout is scheduled at present."));
			tvp = NULL;
		} else {
			tv_out.tv_usec = 0;
			tv_out.tv_sec = next_timeout - time (NULL);
			tvp = &tv_out;
			DX(syslog (LOG_DEBUG, "next timeout is after %ld secs.", tv_out.tv_sec));
		}

		/* get FD_SET for now */
		max_fd = 0;
		FD_ZERO (&fd_read);
		FD_ZERO (&fd_write);

		DX (syslog (LOG_DEBUG, "check for UDP fds..."));
		ni_fds_set (&fd_read, &max_fd);
#ifdef USE_INET4
		i = ni_default_sock (AF_INET);
		if (i > 0) {
			FD_SET (i, &fd_read);
			max_fd = MAXNUM (max_fd, i);
		}
#endif
#ifdef USE_INET6
		i = ni_default_sock (AF_INET6);
		if (i > 0) {
			FD_SET (i, &fd_read);
			max_fd = MAXNUM (max_fd, i);
		}
#endif
		DX (syslog (LOG_DEBUG, "check for TCP-in fds..."));
		i = ev_tcp_conn_in_fds (&fd_read);
		max_fd = MAXNUM (i, max_fd);

		DX (syslog (LOG_DEBUG, "check for TCP-out fds..."));
		i = ev_tcp_out_fds (&fd_write);
		max_fd = MAXNUM (i, max_fd);

#ifdef USE_INET4
		if (tcp_srv_sock >= 0) {
			FD_SET (tcp_srv_sock, &fd_read);
			DX (syslog (LOG_DEBUG, "ev_main(): service socket(v4) FD_SET(%d)",
				    tcp_srv_sock));
			max_fd = MAXNUM (max_fd, tcp_srv_sock);
		}
#endif
#ifdef USE_INET6
		if (tcp_srv_sock6 >= 0) {
			FD_SET (tcp_srv_sock6, &fd_read);
			DX (syslog (LOG_DEBUG, "ev_main(): service socket(v6) FD_SET(%d)",
				    tcp_srv_sock6));
			max_fd = MAXNUM (max_fd, tcp_srv_sock6);
		}
#endif

		DX (syslog (LOG_DEBUG, "ev_main(): max_fd = %d", max_fd));

		/* select */
		DX (syslog (LOG_DEBUG, "main loop: select"));
		fdnum = select (max_fd + 1, &fd_read, &fd_write, NULL, tvp);
		if (fdnum < 0) {
			if (errno == EINTR) {
				DX (syslog (LOG_DEBUG, "ev_main(): select() interrupted."));
				continue;	/* while(1) */
			} else {
				if (errno == EBADF)
					ni_list_print (1);
				fprintf (stderr, "ev_main(): select(): %m");
				tot_exit (-1);
			}
		} else {
			ni_tmp = ni_fds_isset (&fd_read);
			if (ni_tmp) {
				i = ev_udp_in_read (ni_tmp->sock);
				if (i < 0)
					syslog (LOG_INFO, "udp processing error.");
			} else if (ev_tcp_out_fd_check (&fd_write) < 0)
				syslog (LOG_INFO, "tcp output routine failed.");
			else if (ev_tcp_conn_in_fd_check (&fd_read) < 0)
				syslog (LOG_INFO, "tcp connection input routine failed.");
#ifdef USE_INET4
			else if (tcp_srv_sock >= 0 && FD_ISSET (tcp_srv_sock, &fd_read)) {
				if (ev_tcp_srv_accept (tcp_srv_sock) < 0)
					syslog (LOG_INFO, "tcp service error.");
			}
#endif
#ifdef USE_INET6
			else if (tcp_srv_sock6 >= 0 && FD_ISSET (tcp_srv_sock6, &fd_read))
				if (ev_tcp_srv_accept (tcp_srv_sock6) < 0)
					syslog (LOG_INFO, "tcp service error.\n");
#endif
		}		/* if(...select...) */
	}			/* while(1) */
}
