/****************************************************************************
 * Copyright(C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright(C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: conv_scoped.c,v 1.4 2000/04/02 12:35:26 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright(C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright(C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: conv_scoped.c,v 1.4 2000/04/02 12:35:26 dillema Exp $");

static RRset *conv_scoped_rrset __P((RRset *));

int
conv_scoped_query(ni, context)
	NI_List *ni;
	Context *context;
{
	struct sockaddr_in6 *me;
	struct sockaddr_in6 *peer;

	me =(struct sockaddr_in6 *)ni->sa_p;
	if (me->sin6_family != AF_INET6)
		return 0;
	switch(context->type) {
	case CTYPE_TCP_RESPONSE:
		peer =(struct sockaddr_in6 *)context->param.t_res->sa_p;
		break;
	case CTYPE_UDP_RESPONSE:
		peer =(struct sockaddr_in6 *)context->param.u_res->peer.sa;
		break;
	default:
		return 0;
	}
	if (peer->sin6_family != AF_INET6)
		return 0;

	if (IN6_IS_ADDR_LINKLOCAL(&me->sin6_addr) &&
	    IN6_IS_ADDR_LINKLOCAL(&peer->sin6_addr) &&
	    me->sin6_scope_id == peer->sin6_scope_id) {
		return 1; /* good */
	} else if (IN6_IS_ADDR_SITELOCAL(&me->sin6_addr) &&
		 IN6_IS_ADDR_SITELOCAL(&peer->sin6_addr) &&
		 me->sin6_scope_id == peer->sin6_scope_id) {
		return 1; /* good */
	} else
		return 0;
}

static RRset *
conv_scoped_rrset(RRset * rrs_old)
{
	RR_List *rrl = NULL, *rrl_tmp = NULL;
	RRset *ret_val = NULL, *rrs_new = NULL;
	u_char *rd = NULL, *rd_new = NULL;
	int i;
	RR_List sentinel, *cur;

	DX(syslog(LOG_DEBUG, "conv_scoped_rrset: start\n"));
	if (!T.scoped_prefixes) {
		ret_val = NULL;
		goto finish;
	}

	memset(&sentinel, 0, sizeof(sentinel));
	cur = &sentinel;

	if (rrs_old->key.info->r_type != RT_AAAA) {
		ret_val = NULL;
		goto finish;
	}
	/* parse A rrset */
	rrl = rr_list_of_rrset(rrs_old);
	if (!rrl) {
		ret_val = NULL;
		goto finish;
	}
	/* convert each RR_List data */
	for (rrl_tmp = rrl; rrl_tmp->next; rrl_tmp = rrl_tmp->next) {
		rd = rr_rdata(rrl_tmp->rrp);

		for (i = 0; i < T.scoped_prefixes; i++) {
			if (memcmp(rd, &T.scoped_from[i], T.scoped_plen[i] / 8) == 0)
				break;
		}
		if (i >= T.scoped_prefixes)
			continue;

		/* make a duplicate */
		cur->next = rr_list_alloc();
		*(cur->next) = *rrl_tmp;
		cur->next->rrp = NULL;
		cur->next->next = NULL;

		rd_new = malloc(sizeof(struct in6_addr));
		if (!rd_new) {
			rr_list_free(cur->next);
			cur->next = NULL;
			continue;
		}

		memcpy(rd_new, &T.scoped_to[i], T.scoped_plen[i] / 8);
		memcpy(rd_new + T.scoped_plen[i] / 8, rd + T.scoped_plen[i] / 8,
		    sizeof(struct in6_addr) - T.scoped_plen[i] / 8);

		cur->next->rrp = rr_alloc(rrl_tmp->rrp->ttl,
				sizeof(struct in6_addr), rd_new);
		rd_new = NULL;
		if (!cur->next->rrp) {
			rr_list_free(cur->next);
			cur->next = NULL;
			continue;
		}

		while (cur && cur->next)
			cur = cur->next;
	}

	cur->next = rrl;

	/* why do we need to count like this? */
	i = 0;
	for (cur = sentinel.next; cur; cur = cur->next)
		i++;
	i -= 2;
	for (cur = sentinel.next; cur; cur = cur->next)
		cur->cnt = i--;

	/* assemble AAAA rrset */
	rrs_new = rrset_create(RT_AAAA, rrs_old->key.info->r_class,
				 rrs_old->key.info->owner_len,
				 rrset_key_info_owner(rrs_old),
				 sentinel.next);
	if (!rrs_new) {
		ret_val = NULL;
		goto finish;
	}
	/* set return value */
	ret_val = rrs_new;
	rrs_new = NULL;	/* kept in ret_val */
finish:

	if (rrs_new)
		rrset_free(rrs_new);
	if (sentinel.next)
		rr_list_free(sentinel.next);
	if (rd_new)
		free(rd_new);

	DX(syslog(LOG_DEBUG, "conv_scoped_rrset: return\n"));
	return ret_val;
}

void
conv_scoped_list(rrsl)
	G_List *rrsl;
{
        RRset *rrsp, *rrsp_new;
	G_List *gl_tmp;

	DX(syslog(LOG_DEBUG, "conv_scoped_list: start.\n"));

	rrsl->list_data = NULL;
	for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rrsp =(RRset *)gl_tmp->list_data;
		if (rrsp->key.info->r_type != RT_AAAA)
			continue;

		/* add scoped address if necessary */
		rrsp_new = conv_scoped_rrset(rrsp);
		if (!rrsp_new) {
			syslog(LOG_ERR, "Can't add scoped address\n");
		} else {
			rrset_free(rrsp);
			gl_tmp->list_data = rrsp_new;
			rrsp_new = NULL;
		}
	}

	DX(syslog(LOG_DEBUG, "conv_scoped_list: return\n"));
	return;
}

int
conv_scoped_conf(from, to, plen)
	const char *from;
	const char *to;
	int plen;
{
	const int max = sizeof(T.scoped_from)/sizeof(T.scoped_from[0]);

	if (T.scoped_prefixes >= max) {
		syslog(LOG_ERR,
		    "conv_scoped_conf: max number of %d prefixes exceeded",
		    max);
		return(-1);
	}
	if (plen % 8) {
		syslog(LOG_ERR,
		    "conv_scoped_conf: plen needs to be multiple of 8");
		return(-1);
	}

	if (inet_pton(AF_INET6, from, &T.scoped_from[T.scoped_prefixes]) != 1) {
		syslog(LOG_ERR, "invalid format: from %s", from);
		return(-1);
	}
	if (inet_pton(AF_INET6, to, &T.scoped_to[T.scoped_prefixes]) != 1) {
		syslog(LOG_ERR, "invalid format: to %s", to);
		return(-1);
	}
	T.scoped_plen[T.scoped_prefixes] = plen;

	DX(syslog(LOG_DEBUG, "conv_scoped_conf: %s %s\n", from, to));
	return(0);
}

void conv_scoped_ptr(G_List * rrsl, u_char *qname)
{
	G_List *gl_tmp;
	U_Key rk;
	int idx;
	char *p, *q;
	int off;
	const char *hex = "0123456789abcdef";

	DX(syslog(LOG_DEBUG, "conv_scoped_ptr: start.\n"));

	if (T.scoped_prefixes == 0) {
		syslog (LOG_ERR, "No scoped prefix configured!\n");
		return;
	}

	idx = conv_is_scoped_ptr(qname, 1);
	if (idx == -1)
		return;

	rrsl->list_data = NULL;
	for (gl_tmp = rrsl->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rk = ((RRset *) gl_tmp->list_data)->key;
		if (rk.info->r_type != RT_PTR)
			continue;

		/* convert PTR record from in-addr.arpa to ip6.int */
		p = rk.p + KEYINFO_HEAD_LEN;
		q = &T.scoped_to[idx].s6_addr[0];
		for (off = 0; off < T.scoped_plen[idx] / 8; off++) {
			p[64 - 4 - off * 4 + 3] = hex[(q[off] >> 4) & 0x0f];
			p[64 - 4 - off * 4 + 1] = hex[q[off] & 0x0f];
		}
	}

	DX(syslog (LOG_DEBUG, "conv_scoped_ptr: return\n"));
	return;
}

/* 
 * returns index of scoped rewrite, if netprefix of qname equals one of scoped
 * prefixes.  returns -1 if not.
 */
int
conv_is_scoped_ptr(qname, to)
	u_char *qname;
	int to;	/* 0: from 1: to */
{
	u_char *qname6, *q6;
	int i;
	struct in6_addr a6;
	char *p;
	unsigned int val;
	char buf[3];

	if (T.scoped_prefixes == 0)
		return -1;

	if (!(strstr(qname, "INT") || strstr(qname, "int")))
		return -1;
	qname6 = strstr(qname, "IP6");
	if (!qname6)
		qname6 = strstr(qname, "ip6");
	if (!qname6)
		return -1;

	memset(&a6, 0, sizeof(a6));
	qname6--;
	if (qname6 - qname != 64)
		return -1;
	qname6--;
	q6 = qname6;
	p = &a6.s6_addr[0];
	while (q6 - 3 >= qname) {
		buf[0] = *q6--;
		if (*q6-- != 1)
			return -1;
		buf[1] = *q6--;
		if (*q6-- != 1)
			return -1;
		buf[2] = '\0';
		sscanf(buf, "%x", &val);
		*p = val & 0xff;

		p++;
	}

	for (i = 0; i < T.scoped_prefixes; i++) {
		if (memcmp(&a6, to ? &T.scoped_to[i] : &T.scoped_from[i],
				T.scoped_plen[i] / 8) == 0) {
			return i;
		}
	}
	return -1;
}

void
conv_scoped_ptr_rq(qname)
	u_char *qname;
{
	char *p, *q;
	int off;
	const char *hex = "0123456789abcdef";
	int idx;

	idx = conv_is_scoped_ptr(qname, 1);
	if (idx == -1)
		return;

	/* convert PTR record from in-addr.arpa to ip6.int */
	p = qname;
	q = &T.scoped_from[idx].s6_addr[0];
	for (off = 0; off < T.scoped_plen[idx] / 8; off++) {
		p[64 - 4 - off * 4 + 3] = hex[(q[off] >> 4) & 0x0f];
		p[64 - 4 - off * 4 + 1] = hex[q[off] & 0x0f];
	}
}
