/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_udp_response.c,v 3.19 2000/04/02 12:35:26 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_udp_response.c,v 3.19 2000/04/02 12:35:26 dillema Exp $");

int cos_udp_response_start (u_char * mesg_buf, int mesg_len, int buf_len,
		           struct sockaddr * sa, int sa_len, NI_List * inif)
{
	const char *fn = "cos_udp_response_start()";
	Context *cont;
	int status;

	DX (syslog (LOG_DEBUG, "%s: start", fn));
	status = 0;

	/* create context */
	cont = malloc (sizeof (Context));
	if (!cont) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto error;
	}
	memset (cont, 0, sizeof (Context));

	cont->param.u_res = malloc (sizeof (Cos_UDP_Response));
	cont->param.u_res->peer.p = malloc (sa_len);
	if (!cont->param.u_res || !cont->param.u_res->peer.p) {
		syslog (EM_F (EM_F_MEMEX), fn);
		status = -1;
		goto error;
	}
	cont->type = CTYPE_UDP_RESPONSE;
	cont->mesg.p = mesg_buf;
	cont->mesg_len = mesg_len;
	cont->buf_len = buf_len;
	cont->wp = mesg_buf + mesg_len;	/* just after the answer section */
	cont->q_id = cont->mesg.hdr->id;
	cont->param.u_res->inif = ni_copy (inif);
	memcpy (cont->param.u_res->peer.p, (u_char *) sa, sa_len);
	cont->param.u_res->peer_len = sa_len;

	if (cont->mesg.hdr->opcode == OP_QUERY) {
		DX (syslog (LOG_DEBUG, "%s: OPCODE = OP_QUERY", fn));

		/* query-response specific variables */
		cont->process = cos_udp_response_waiting_recursive_process;
		cont->retry = cos_udp_response_waiting_recursive_retry;

		cont->an_list = list_init ();
		cont->ns_list = list_init ();
		cont->ar_list = list_init ();
		if (!cont->an_list || !cont->ns_list || !cont->ar_list) {
			syslog (EM_F (EM_F_MEMEX), fn);
			status = -1;
			goto error;
		}
		if (cos_common_start_rq (cont, QUERY_TCP)) {
			syslog (LOG_NOTICE, "%s: forwarder doesn't recurse!", fn);
			return cos_udp_response_finish (cont);
		}
		return 0;

	} else {
		syslog (LOG_NOTICE, "%s: OPCODE = unknown(%d)", fn, cont->mesg.hdr->opcode);
		cont->mesg.hdr->rcode = RC_NIMP;
		return cos_udp_response_finish (cont);
	}

	/* NOTREACHED */

error:
	DX (syslog (LOG_DEBUG, "%s: return error(status = %d)", fn, status));
	cos_udp_response_abort (cont);

	return status;
}

int cos_udp_response_waiting_recursive_process (Context * cont)
{
	switch (cos_common_waiting_recursive_process (cont)) {
		case 1:
		/* finished */
		return cos_udp_response_finish (cont);
	case 0:
		/* continue */
		return 0;
	default:
		/* failed */
		return cos_udp_response_abort (cont);
	}
}

int cos_udp_response_waiting_recursive_retry (Context * cont)
{
	printf ("cos_udp_response_waiting_recursive_retry(): should not be called.");
	return cos_udp_response_abort (cont);
}

int cos_udp_response_destroy (Context * cont)
{
	if (cont) {
		if (cont->param.u_res) {
			ev_udp_in_remove (cont->param.u_res->peer.sa, cont->q_id);
			if (cont->param.u_res->peer.p)
				free (cont->param.u_res->peer.p);
			if (cont->param.u_res->inif)
				ni_free (cont->param.u_res->inif, 0);
			free (cont->param.u_res);
		}
	}
	return 0;
}

int cos_udp_response_abort (Context * cont)
{
	context_destroy (cont);
	return 0;
}

int cos_udp_response_finish (Context * cont)
{
        DX(const char *fn = "cos_udp_response_finish()";)
	int status = 0;
	int len;
	u_char *ucp, *qname;
	u_int16_t us;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	/* assemble the answer */
	if (cont->an_list && cont->ns_list && cont->ar_list) {
                ucp = qname = cont->mesg.p + sizeof (Mesg_Hdr);
		SKIP_DNAME (ucp);
		GETSHORT (us, ucp);

		if (us == RT_AAAA && cont->q_type == RT_A) {
			conv_trick_list (cont->an_list);
			conv_trick_list (cont->ns_list);
			conv_trick_list (cont->ar_list);
                        T.current_prefix = (T.current_prefix + 1) % T.prefixnum; /* circulate through prefixes */
			DX (syslog (LOG_DEBUG, "%s: query for AAAA changed into query for A", fn));
		}
		else if (us == RT_PTR && !conv_trick_is_tot_ptr (qname)) {
			conv_trick_ptr (cont->an_list, qname);
			DX (syslog (LOG_DEBUG, "%s: converted PTR response", fn));
		}
#ifdef SCOPED_REWRITE
		else if (us == RT_AAAA && T.scoped_prefixes &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
			conv_scoped_list(cont->an_list);
			conv_scoped_list(cont->ns_list);
			conv_scoped_list(cont->ar_list);
                        DX (syslog (LOG_DEBUG, "%s: checked whether to rewrite global into scoped address", fn));
		}
		else if (us == RT_PTR && conv_is_scoped_ptr(qname, 1) != -1 &&
			 conv_scoped_query(cont->param.u_res->inif, cont)) {
			conv_scoped_ptr(cont->an_list, qname);
			DX (syslog (LOG_DEBUG, "%s: converted query name: %s", fn, qname));
		}
#endif

		len = mesg_assemble (NULL, cont->an_list, cont->ns_list, cont->ar_list,
			       cont->mesg.p, cont->buf_len, cont->mesg_len);
		if (len < 0) {
			syslog (LOG_WARNING, "failed to make up message.");
			status = 1;
			goto finish;
		}
	} else
		len = cont->mesg_len;

	/* failsafe */
	cont->mesg.hdr->qr = 1;
	cont->mesg.hdr->ra = 1;

	/* copy AA and RCODE from child context */
	if (cont->mesg.hdr->rcode == RC_OK && cont->child) {
		cont->mesg.hdr->rcode = cont->child->mesg.hdr->rcode;
		cont->mesg.hdr->aa = cont->child->mesg.hdr->aa;
	}
	/* send the answer */
	if (net_mesg_send (cont->param.u_res->inif, cont->mesg.p, len,
			   cont->param.u_res->peer.sa) <len) {
		syslog (LOG_NOTICE, "failed to send message.");
		status = -1;
		goto finish;
	}
finish:
	/* free all resources */
	context_destroy (cont);
	DX (syslog (LOG_DEBUG, "%s: return %d", fn, status));

	return status;
}
