/****************************************************************************
 * Copyright (C) 1998 WIDE Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by WIDE Project and
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/****************************************************************************
 * Copyright (C) 1999 University of Tromso.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    This product includes software developed by the University of Tromso
 *    and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 ****************************************************************************/

/*
 * <$Id: cons_common.c,v 3.17 2000/04/02 12:35:26 dillema Exp $>
 */

#include "tot.h"

COPYRIGHT1(
"@(#) Copyright (C) 1998 WIDE Project.  All rights reserved.\n");

COPYRIGHT2(
"@(#) Copyright (C) 1999 The University of Tromso.  All rights reserved.\n");

COPYRIGHT3("Written by: F. W. Dillema. feico@pasta.cs.uit.no.\n
based on code by: Yusuke DOI, Keio Univ. Murai Lab.");

CVSID("$Id: cons_common.c,v 3.17 2000/04/02 12:35:26 dillema Exp $");

u_char Cos_TCP_Buf[MAX_STREAM];

u_char *cos_common_cname_without_crecord (G_List * an_list, int *cnamelen_ret)
{
        DX(char *fn = "cos_common_cname_without_crecord()";)
	int canonical_domain_len;
	u_char *canonical_domain, *domain;

	G_List *gl_tmp;
	RRset *rrs_tmp;
	RR *rr_tmp;

	DX (syslog (LOG_DEBUG, "%s: start\n", fn));

	DX (syslog (LOG_DEBUG, "%s: Search for CNAME Record in Answer Record List\n", fn));
	canonical_domain = NULL;
	an_list->list_data = NULL;
	for (gl_tmp = an_list->next; gl_tmp->list_data != NULL; gl_tmp = gl_tmp->next) {
		rrs_tmp = (RRset *) gl_tmp->list_data;
		if (rrs_tmp->key.info->r_type == RT_CNAME) {
			rr_tmp = (RR *) (rrs_tmp->data.p + data_offset (0, rrs_tmp->data.p));
			canonical_domain = rr_rdata (rr_tmp);
			canonical_domain_len = rr_tmp->rd_len;
		}
	}
	if (canonical_domain == NULL) {
		DX (syslog (LOG_DEBUG, "%s: no problem -- no CNAME record.\n", fn));
		return NULL;	/* no problem -- no cname record */
	}
	DX (syslog (LOG_DEBUG, "%s: Match for CNAME?\n", fn));
	an_list->list_data = NULL;
	for (gl_tmp = an_list->next; gl_tmp->list_data; gl_tmp = gl_tmp->next) {
		rrs_tmp = (RRset *) gl_tmp->list_data;
		domain = rrset_key_info_owner (rrs_tmp);
		if ((rrs_tmp->key.info->owner_len == canonical_domain_len)
		    && !mesg_dname_cmp (NULL, domain, canonical_domain)) {
			DX (syslog (LOG_DEBUG, "%s: OK, NP -- CNAME and canonical record.\n", fn));
			return NULL;
		}
	}

	if (cnamelen_ret)
		*cnamelen_ret = canonical_domain_len;

	DX (syslog (LOG_DEBUG, "%s: Problem: CNAME without canonical record.\n", fn));
	return canonical_domain;
}

/*
 * change the target to specified domain, preserving original context's
 *  target r_type and class.
 */
int cos_common_change_target (Context * cont, u_char * target, int target_len,
			          u_int16_t r_type)
{
	static char *fn = "cos_common_change_target()";
	u_char *ucp;
	u_char *ucp2;

	if (cont->ns_list)
		list_destroy (cont->ns_list, rrset_freev);

	if (cont->ar_list)
		list_destroy (cont->ar_list, rrset_freev);

	cont->ns_list = list_init ();
	cont->ar_list = list_init ();
	if (!cont->ns_list || !cont->ar_list) {
		syslog (LOG_ERR, "%s: can't initialize lists.\n", fn);
		return -1;
	}
	/* check query section */
	ucp = cont->mesg.p + sizeof (Mesg_Hdr);
	ucp2 = mesg_skip_dname (ucp);

	if (cont->qname)
		free (cont->qname);

	if (target) {
		cont->qname = malloc (target_len);
		if (!cont->qname) {
			syslog (EM_F (EM_F_MEMEX), fn);
			return -1;
		}
		memcpy (cont->qname, target, target_len);
		cont->qname_len = target_len;
	} else {
		cont->qname = malloc (ucp2 - ucp);
		if (!cont->qname) {
			syslog (EM_F (EM_F_MEMEX), fn);
			return -1;
		}
		memcpy (cont->qname, ucp, ucp2 - ucp);
		cont->qname_len = ucp2 - ucp;
	}

	if (r_type == 0) {
		GETSHORT (cont->q_type, ucp2);
	} else {
		cont->q_type = r_type;
		ucp2 += 2;	/* skip q_type */
	}

	GETSHORT (cont->q_class, ucp2);
	return 0;
}

int cos_common_start_rq (Context * cont, int tcp)
{
	const char *fn = "cos_common_start_rq()";
	int ret, qname_len;
	u_char *qname, *cp;
	u_int16_t qclass, qtype;

	DX (syslog (LOG_DEBUG, "%s: start", fn));

	ret = 0;
	qname = NULL;
	if (!cont->qname) {
		/* new query, get qstuff from query message */
		qname = cont->mesg.p + sizeof (Mesg_Hdr);
		cp = mesg_skip_dname (qname);
		qname_len = cp - qname;
		if (qname_len > MAX_DNAME) {
			syslog (LOG_INFO, "%s: malformed question.\n", fn);
			ret = 1;
		} else {
			GETSHORT (qtype, cp);
			GETSHORT (qclass, cp);

			cp = qname;
			qname = malloc (qname_len);
			strncpy (qname, cp, qname_len);

			DX (syslog (LOG_DEBUG, "%s: query name: %s, %d", fn, qname, qname_len));
			if (qtype == RT_PTR) {
				DX (syslog (LOG_DEBUG, "%s: PTR query type", fn));
				if (!conv_trick_is_tot_ptr (qname)) {
					conv_trick_ptr_rq(qname);
					qname_len = strlen (qname);
					DX (syslog (LOG_DEBUG, "%s: converted query name: %s, %d", fn, qname, qname_len));
				}
#ifdef SCOPED_REWRITE
				else if (conv_is_scoped_ptr(qname, 1) != -1) {
					conv_scoped_ptr_rq(qname);
					qname_len = strlen(qname);
					DX (syslog (LOG_DEBUG, "%s: converted query name: %s, %d", fn, qname, qname_len));
				}
#endif
			}
		}
	} else {
		qname_len = strlen (cont->qname) + 1;	/* safer than:
							 * cont->qname_len */
		if (qname_len != cont->qname_len) {
			syslog (LOG_INFO, "%s: qname and qname_len don't match!", fn);
			ret = 1;
		}
		if (cont->qname_len > MAX_DNAME) {
			syslog (LOG_INFO, "%s: malformed question.\n", fn);
			ret = 1;
		}
		qname = malloc (qname_len);
		strcpy (qname, cont->qname);
		qname_len = cont->qname_len;
		qtype = cont->q_type;
		qclass = cont->q_class;
	}

	if (!tcp && !ret)
		tcp = cos_udp_request_start (cont, qname, qname_len, qclass, qtype);
	if (tcp == 1 && !ret)
		ret = cos_tcp_request_start (cont, qname, qname_len, qclass, qtype);

	if (qname)
		free (qname);

	DX (syslog (LOG_DEBUG, "%s: end", fn));
	return (ret);
}

int cos_common_waiting_recursive_process (Context * cont)
{
        DX(const char *fn = "cos_common_waiting_recursive_process()";)
	u_char *cname, *ucp;
	int cname_len;
	u_int16_t us;

	DX (syslog (LOG_DEBUG, "%s: start", fn));
	if (!cont->child) {
		DX (syslog (LOG_DEBUG, "%s: child died", fn));
		return -1;
	}
	/* really we wanna look at child? */
	if (cont->child->mesg.hdr->ancnt == htons (0)) {
		ucp = cont->child->mesg.p + sizeof (Mesg_Hdr);
		ucp = mesg_skip_dname (ucp);
		GETSHORT (us, ucp);	/* resource type */

		if (T.prefixnum && us == RT_AAAA && cont->child->q_type != RT_A) {
			DX (syslog (LOG_DEBUG, "%s: change target from AAAA to A\n", fn));
			if (cos_common_change_target (cont, NULL, 0, RT_A) < 0)
				return -1;

			/* forget about old child */
			cont->child->parent = NULL;
			cont->child = NULL;

			DX (syslog (LOG_DEBUG, "%s: tricking client...\n", fn));
			return cos_common_start_rq (cont, QUERY_TCP);
		}
	}
	DX (syslog (LOG_DEBUG, "%s: checking cname validity...\n", fn));
	cname = cos_common_cname_without_crecord (cont->child->an_list, &cname_len);
	if (cname && (cont->cname_links++ < SEARCH_CNAME_LEVEL)) {
		/* change target and start again */
		if (cos_common_change_target (cont, cname, cname_len, 0) < 0)
			return -1;

		/* forget about old child */
		cont->child->parent = NULL;
		cont->child = NULL;

		DX (syslog (LOG_DEBUG, "%s: following CNAME links.\n", fn));
		return cos_common_start_rq (cont, QUERY_TCP);
	}
	/* finished, pull up the answer */
	list_destroy (cont->an_list, rrset_freev);
	list_destroy (cont->ns_list, rrset_freev);
	list_destroy (cont->ar_list, rrset_freev);
	cont->an_list = cont->child->an_list;
	cont->child->an_list = NULL;
	cont->ns_list = cont->child->ns_list;
	cont->child->ns_list = NULL;
	cont->ar_list = cont->child->ar_list;
	cont->child->ar_list = NULL;

	DX (syslog (LOG_DEBUG, "%s: finish", fn));
	return 1;		/* recursive query finished */
}

int cos_common_tcp_writemesg (Context * cont, int sock)
{
	char *fn = "cos_common_tcp_writemesg()";
	u_int16_t lenbuf_nbo;
	int len;

	if (!cont->wp) {
		/* first time: write length */
		lenbuf_nbo = htons (cont->mesg_len);
		len = write (sock, (u_char *) (&lenbuf_nbo), sizeof (u_int16_t));
		if (len < 0) {
			syslog (LOG_INFO, "%s: write length failed: %m", fn);
			return -1;
		}
		cont->wp = cont->mesg.p;
		return 0;
	} else {
		len = write (sock, cont->wp, cont->mesg_len - (cont->wp - cont->mesg.p));
		if (len < 0) {
			syslog (LOG_INFO, "%s: write failed: %m", fn);
			return -1;
		}
		cont->wp += len;

		if (cont->wp < cont->mesg.p + cont->mesg_len) {
			DX (syslog (LOG_DEBUG, "%s: cont'ed this context (return 0)\n", fn));
			return 0;
		} else {
			DX (syslog (LOG_DEBUG, "%s: write finished(return 1)\n", fn));
			return 1;
		}
	}

	/* NOTREACHED */
	abort ();
}
