<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
<head>
  <title>Guide d'installation pour Linux/BSD/Unix</title>
  <meta name="Author" content="Roger Dingledine">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://www.torproject.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.fr">Accueil</a>
<a href="../overview.html.fr">Vue d'ensemble</a>
<a href="../download.html.fr">Téléchargement</a>
<a href="../documentation.html.fr">Docs</a>
<a href="../volunteer.html.fr">Contribuer</a>
<a href="../people.html.fr">Auteurs</a>
<a href="../donate.html.fr">Dons!</a>
        </td>
        <td class="banner-right">
	<img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-unix.html.en"><acronym title="English"><img src="../images/en.png" alt="English" width="24" height="16"></acronym></a> <a href="tor-doc-unix.html.es"><acronym title="espa&ntilde;ol"><img src="../images/es.png" alt="espa&ntilde;ol" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <acronym title="fran&ccedil;ais"><img src="../images/fr.png" alt="fran&ccedil;ais" width="24" height="16"></acronym> <a href="tor-doc-unix.html.it"><acronym title="Italiano"><img src="../images/it.png" alt="Italiano" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-unix.html.pl"><acronym title="polski"><img src="../images/pl.png" alt="polski" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-unix.html.ru"><acronym title="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)"><img src="../images/ru.png" alt="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-unix.html.zh-cn"><acronym title="&#20013;&#25991;(&#31616;) (Simplified Chinese)"><img src="../images/zh-cn.png" alt="&#20013;&#25991;(&#31616;) (Simplified Chinese)" width="24" height="16"></acronym></a>
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Installer un client <a href="../index.html.fr">Tor</a> sur système Linux/BSD/Unix</h1>
<br>
<p>
<b>Ces instructions ne s'appliquent qu'à l'installation d'un client Tor.
Si vous voulez aider à la croissance du réseau Tor en relayant du trafic pour les autres
(ce qui est une très bonne idée), lisez le guide sur la <a
href="../docs/tor-doc-relay.html.fr">configuration d'un relais</a>.</b>
</p>
<hr>
<a id="installing"></a>
<h2><a class="anchor" href="#installing">Étape 1 : Télécharger et Installer Tor</a></h2>
<br>
<p>
Vous pouvez trouver la dernière version de Tor sur la page de <a
href="../download.html.fr">téléchargement</a>. Nous avons ici des paquets pour Debian,
Red Hat, Gentoo, *BSD, etc.
</p>
<p>Si vous installez depuis le code source, installez d'abord <a
href="http://www.monkey.org/~provos/libevent/">libevent</a>, et
assurez vous de bien d'avoir openssl et zlib (avec les paquets
-devel). Tapez ensuite :<br>
<tt>tar xzf tor-0.1.2.19.tar.gz; cd tor-0.1.2.19<br>
./configure && make</tt><br>
Vous pouvez maintenant lancer tor depuis <tt>src/or/tor</tt>, ou vous pouvez
l'installer dans /usr/local/ avec <tt>make install</tt> (en root si nécessaire), ce qui
vous permettra de le lancer en tapant simplement <tt>tor</tt>.
</p>
<p>Tor est préconfiguré par défaut en tant que client. Le fichier de
configuration qu'il utilise par défaut conviendra à la plupart des
utilisateurs. Tor est maintenant installé.
</p>
<hr>
<a id="privoxy"></a>
<h2><a class="anchor" href="#privoxy">Étape 2 : Installer Privoxy pour la navigation web</a></h2>
<br>
<p>Une fois Tor installé, vous devez configurer vos applications pour l'utiliser.
</p>
<p>
Il faut tout d'abord s'occuper de la navigation web. Commencez par installer <a
href="http://www.privoxy.org/">Privoxy</a> : sélectionnez « recent
releases », et choisissez votre paquet, ou installez depuis le code source. Privoxy
est un proxy web filtrant qui s'intègre très bien avec Tor.
</p>
<p>Une fois Privoxy installé (par un paquet, ou par les sources),
<b>il vous faudra configurer Privoxy pour utiliser Tor</b>.
Vous pouvez trouver <a href="https://wiki.torproject.org/noreply/TheOnionRouter/PrivoxyConfig">cet
exemple de configuration de Privoxy</a> intéressant. Sinon vous aurez à configurer
Privoxy à la main, en utilisant les pistes qui suivent.
</p>
<p>
Ouvrez le fichier de configuration de Privoxy (regardez dans /etc/privoxy/ ou dans
/usr/local/etc/), et ajoutez la ligne <br>
<tt>forward-socks4a / 127.0.0.1:9050 .</tt><br>
au début de ce fichier. N'oubliez pas le point en fin de ligne.
</p>
<p>Privoxy garde dans un fichier de log des traces de tout ce qu'il retransmet. Afin de prévenir cela, vous
pouvez commenter (en insérant # en début de ligne) ces deux lignes :
<br>
<tt>logfile logfile</tt><br>
et la ligne<br>
<tt>jarfile jarfile</tt><br>
enfin (sur certains systèmes) la ligne <br>
<tt>debug 1 # affiche chaque requète GET/POST/CONNECT</tt><br>
</p>
<p>Suivant la configuration par défaut que vous avez pour Privoxy,
vous pourrez avoir à couper <tt>enable-remote-toggle</tt>,
<tt>enable-remote-http-toggle</tt>, et <tt>enable-edit-actions</tt>.
</p>
<p>Vous devrez redémarrer Privoxy pour que les modifications prennent effet.</p>
<hr>
<a id="using"></a>
<h2><a class="anchor" href="#using">Étape 3 : Configurer vos applications pour utiliser Tor</a></h2>
<br>
<p>Une fois Tor installé, vous devez configurer vos applications pour l'utiliser.</p>
<p>Si vous utilisez Firefox (nous vous le conseillons), vous pouvez installer <a
href="https://addons.mozilla.org/firefox/2275/">l'extension Torbutton</a>,
puis redemarrez votre Firefox et c'est terminé :
</p>
<img alt="Torbutton plugin for Firefox"
src="../img/screenshot-torbutton.png"
border="1" width="161" height="78">
<br>
<p>
(<a href="https://torbutton.torproject.org/">En savoir plus sur
Torbutton ici</a>.
Si vous envisagez de faire tourner Firefox sur un ordinateur différent de Tor, jetez un œil à l'entrée <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SocksListenAddress">FAQ
traitant de l'utilisation de Tor sur un ordinateur différent</a>. Si vous avez besoin
d'utiliser un navigateur autre que Firefox, vous aurez à <a href="../docs/tor-doc-web.html.fr">configurer son proxy vous même</a>.)
</p>
<p>Il est <strong>nécessaire</strong> d'utiliser Privoxy car <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">les
navigateurs ne cachent pas vos requêtes DNS lorsque vous utilisez SOCKS
directement</a>, ce qui est mauvais pour votre anonymat. Privoxy supprime aussi
de vos requêtes web certains en-têtes dangereux, et bloque les infectes
publicités de sites comme Doubleclick.</p>
<p>Pour Torréfier d'autres applications qui gèrent les proxies HTTP, faites les
simplement utiliser Privoxy (c'est à dire, localhost port 8118). Pour utiliser SOCKS
directement (pour la messagerie instantanée, Jabber, IRC, etc), faites pointer votre
application directement sur Tor (localhost port 9050), mais consultez
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#SOCKSAndDNS">cet article de
la FAQ</a> pour comprendre en quoi cela peut être dangereux. Pour les applications qui ne
gèrent ni SOCKS, ni le HTTP, vous pouvez utiliser <a
href="http://tsocks.sourceforge.net/">tsocks</a> ou <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO#socat">socat</a>.
</p>
<p>Vous pouvez trouver des informations sur la Torréfaction d'autres applications
sur le <a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorifyHOWTO">HOWTO Torréfaction</a>.
</p>
<hr>
<a id="verify"></a>
<h2><a class="anchor" href="#verify">Étape 4 : Vérifier que ça fonctionne</a></h2>
<br>
<p>Vous devriez ensuite essayer d'utiliser votre navigateur avec Tor, et vérifier que votre adresse
IP est anonyme. Rendez vous sur le
<a href="http://torcheck.xenobite.eu/">détecteur Tor</a>, vous
verrez s'il pense que vous utilisez Tor ou non. (Si ce site ne marche pas, voyez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#IsMyConnectionPrivate">cet
article de la FAQ</a> pour des suggestions supplémentaires sur la manière de tester Tor.)
</p>
<p>Si vous avez un pare-feu personnel qui limite la possibilité de votre ordinateur à se
connecter en local (par exemple SELinux sur Fedora Core 4), assurez vous de permettre les
connexions de vos applications vers Privoxy (local port 8118) et tor (local port 9050). Si
votre pare-feu bloque les connexions sortantes, faites une brèche dedans pour pouvoir vous
connecter au moins sur les ports 80 et 443, et consultez ensuite <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#FirewalledClient">cet
article de la FAQ</a>. Si votre configuration de SELinux ne permet pas à tor ou privoxy de
fonctionner correctement, créez un fichier nommé booleans.local dans votre répertoire
/etc/selinux/targeted. Éditez le avec votre éditeur de texte favori, et écrivez
"allow_ypbind=1". Redémarrez votre machine pour que cette modification prenne effet.
</p>
<p>Si cela ne fonctionne toujours pas, consultez <a
href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#ItDoesntWork">cet article de
la FAQ</a>.</p>
<hr>
<a id="server"></a>
<a id="relay"></a>
<h2><a class="anchor" href="#relay">Étape 5 : Configurer Tor en tant que relais</a></h2>
<br>
<p>Le réseau Tor se base sur des volontaires qui donnent de leur bande passante.
Plus il y a de monde qui fait tourner de relais, plus le réseau Tor sera rapide. Si vous
disposez d'au moins 20 Ko/s en upload et en download, vous pouvez aider Tor en configurant
Tor pour être un relais lui aussi. Nous avons beaucoup de fonctionnalités qui rendent les
relais Tor simples et pratiques, comme la gestion des adresses IP dynamiques, ou la
limitation de la bande passante maximale et les politiques de sortie afin que vous
puissiez limiter votre vulnérabilité aux possibles plaintes suite à des abus.</p>
<p>Tor est un système dont la sécurité dépend de la diversité des lieux géographiques où tournent
les relais.
<a href="https://wiki.torproject.org/noreply/TheOnionRouter/TorFAQ#RelayAnonymity">Faire
tourner un relais renforce votre anonymat</a>, car les sites distants ne peuvent pas
savoir si les connexions proviennent de votre ordinateur, ou si vous les avez juste
relayé depuis un autre endroit.</p>
<p>Pour en savoir plus, voir le guide de <a href="../docs/tor-doc-relay.html.fr">configuration
d'un relais</a>.</p>
<hr>
<p>Si vous avez des suggestions pour améliorer ce document, <a
href="../contact.html.fr">envoyez les nous</a> s'il vous plaît. Merci !</p>
  </div><!-- #main -->
</div>
</div>
  <div class="bottom" id="bottom">
     <p>
     <i><a href="../contact.html.fr" class="smalllink">Webmaster</a></i> -
      Dernière modification : Tue Feb 26 19:27:13 2008
      -
      Dernière compilation : Sun Mar 2 17:35:50 2008
     </p>
     <p>"Tor" et le Logo Onion sont des <a href="../trademark-faq.html">marques déposées</a> du Projet Tor, Inc.
  	      </p>
     <p>
      Attention: Cette traduction peut être obsolète. La version anglaise originale est la
      13768 alors que la version traduite est basée sur la
      12809.
     </p>
     <p>
       Cette page est aussi disponible dans les langues suivantes :
       <a href="tor-doc-unix.html.en">English</a>, <a href="tor-doc-unix.html.es">espa&ntilde;ol</a>, <a href="tor-doc-unix.html.it">Italiano</a>, <a href="tor-doc-unix.html.pl">polski</a>, <a href="tor-doc-unix.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>, <a href="tor-doc-unix.html.zh-cn">&#20013;&#25991;(&#31616;) (Simplified Chinese)</a>.<br>
       Comment configurer la <a href="http://www.debian.org/intro/cn#howtoset">langue par défaut du document</a>.
     </p>
      <p>Les développeurs de Tor n'ont pas revu cette traduction en ce qui concerne la
      pertinence et l'exactitude. Elle peut être obsolète ou fausse. La version
      officielle du site web Tor est la version anglaise, disponible sur <a
      href="https://www.torproject.org/">https://www.torproject.org/</a>.
      </p>
  </div>
</body>
</html>
