<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
<head>
  <title>Tor: Instruction de configuration d'un serveur</title>
  <meta name="Author" content="Roger Dingledine">
  <meta http-equiv="content-type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../stylesheet.css">
  <link rel="shortcut icon" type="image/x-icon" href="../favicon.ico">
</head>
<body>
<div class="center">
<table class="banner" border="0" cellpadding="0" cellspacing="0" summary="">
    <tr>
        <td class="banner-left"><a href="https://tor.eff.org/"><img src="../images/top-left.png" alt="Click to go to home page" width="193" height="79"></a></td>
        <td class="banner-middle">
	<a href="../index.html.fr">Accueil</a>
<a href="../overview.html.fr">Vue d'ensemble</a>
<a href="../download.html.fr">Téléchargement</a>
<a href="../documentation.html.fr">Docs</a>
<a href="../volunteer.html.fr">Contribuer</a>
<a href="../people.html.fr">Auteurs</a>
<a href="../donate.html.fr">Dons!</a>
        </td>
        <td class="banner-right">
	<a href="tor-doc-server.html.de"><acronym title="Deutsch"><img src="../images/de.png" alt="Deutsch" width="24" height="16"></acronym></a> <a href="tor-doc-server.html.en"><acronym title="English"><img src="../images/en.png" alt="English" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <acronym title="fran&ccedil;ais"><img src="../images/fr.png" alt="fran&ccedil;ais" width="24" height="16"></acronym> <a href="tor-doc-server.html.it"><acronym title="Italiano"><img src="../images/it.png" alt="Italiano" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-server.html.pl"><acronym title="polski"><img src="../images/pl.png" alt="polski" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <a href="tor-doc-server.html.ru"><acronym title="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)"><img src="../images/ru.png" alt="&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)" width="24" height="16"></acronym></a> <img src="../images/green-flagspace.png" alt="" width="24" height="16"> <img src="../images/green-flagspace.png" alt="" width="24" height="16">
        </td>
    </tr>
</table>
<div class="center">
<div class="main-column">
<h1>Configurer un <a href="../index.html.fr">serveur Tor</a></h1>
<br>
<p>
Le réseau Tor repose sur des contributeurs qui offrent de leur bande passante. Plus
il y'aura de gens à faire tourner un serveur, plus le réseau sera rapide. Si vous avez
au moins 20 kilo octets/s dans chaque sens, aidez Tor en le configurant
comme serveur. Nous avons plusieurs options qui rendent Tor facile
et agréable, par exemple la limitation de bande passante consommée, les contrôles sur ports de sortie
pour que vous puissiez limiter votre expositions aux plaintes, et le support des
adresses dynamiques.</p>
<p>Avoir des serveurs dans plein de lieux différents sur Internet c'est
ce qui sécurise les utilisateurs. <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#ServerAnonymity">Vous
auriez également d'avantage d'anonymat</a>,
puisque les sites distants ne pourraient pas savoir si une connexion vient de votre
ordinateur ou si elle est relayée d'un autre.</p>
<p>Paramétrer un serveur Tor est facile et commode :
<ul>
<li>Tor a des fonctions intégrées pour <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">la limitation
de bande passante</a>. De plus, si vous avez une ligne rapide
mais souhaitez limiter le nombre d'octets échangés par jour
(ou semaine ou mois) que vous offrez, regardez la fonctionnalité d'<a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#Hibernation">hibernation
</a>.
</li>
<li>Chaque serveur Tor a <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#RunAServerBut">une politique
de sortie</a> qui spécifie quelles sortes de trafic sortant sont autorisées
ou refusées depuis ce serveur. Si vous êtes géné à l'idée de laisser des gens
sortir par votre connexion, vous pouvez paramétrer Tor pour qu'il ne se connecte
qu'a d'autres serveurs Tor.
</li>
<li>Ce n'est pas grave que le serveur soit coupé de temps en temps. Les annuaires
le note rapidement et stoppent la propagation du serveur. Assurez vous simplement
que ça n'arrive pas trop souvent, puisque les connexions en cours dans le
serveur seront coupées.
</li>
<li>Nous pouvons prendre en compte les serveurs avec une adresse IP dynamique, tant que le
serveur lui même connait son adresse. Jetez un œil sur cette
<a href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#DynamicIP">
entrée de la FAQ</a>.
</li>
<li>Si votre serveur est derrière un NAT et qu'il ne connait pas son adresse IP
publique (par exemple si l'IP est 192.168.x.y), vous aurez à paramétrer une
translation de port. La translation de port est dépendante du système mais cette <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#ServerForFirewalledClients">entrée
de la FAQ</a> offre quelques exemple sur comment le faire.
</li>
<li>Votre serveur va de manière passive estimer et propager sa capacité récente
en terme de bande passante, ainsi les serveurs à fort débit attireront davantage d'utilisateurs que
ceux en ayant un faible. Bien qu'avoir un serveur à petit débit soit tout de même utile.
</li>
</ul>
<p>Vous pouvez faire tourner un serveur Tor sur
pratiquement n'importe quel système, mais voyez <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#ServerOS">cette
entrée de la FAQ</a> pour vous documenter sur ceux qui fontionnent le mieux et les différents problèmes
que vous seriez suceptibles de rencontrer.</p>
<hr>
<a id="zero"></a>
<h2><a class="anchor" href="#zero">Étape zéro : télécharger et installer Tor</a></h2>
<br>
<p>Avant de commencer, vous devez vous assurer que Tor fonctionne correctement.
</p>
<p>Pour les utilisateurs Windows, ceci signifie qu'au moins <a
href="../docs/tor-doc-win32.html.fr#installing">l'étape une</a>
du Guide d'installation de Tor sous Windows est faite. Les utilisateurs de Mac OS X doivent au moins avoir fait
<a href="../docs/tor-doc-osx.html.fr#installing">l'étape une</a>
du Guide d'installation de Tor sous OS X. Les utilisateurs Linux/BSD/Unix devraient au moins avoir fait
<a href="../docs/tor-doc-unix.html.fr#installing">l'étape une</a>
du guide d'installation de Tor sous Unix.
</p>
<p>Si ça vous dit, vous pouvez également l'utiliser comme client pendant
quelques temps pour savoir si ça fonctionne réellement.</p>
<hr>
<a id="setup"></a>
<h2><a class="anchor" href="#setup">Étape une : le paramétrer comme serveur</a></h2>
<br>
<p>
1. Verifiez que votre horloge est à l'heure. Si possible, synchronisez là
sur un serveur de temps public.
</p>
<p>
2. Assurer vous que les résolutions de nom fonctionnent (c'est à dire que, votre ordinateur est
en mesure de résoudre les adresses Internet correctement).
</p>
<p>
3. Éditer la partie basse de votre fichier torrc. (Voyez <a
href="http://wiki.noreply.org/wiki/TheOnionRouter/TorFAQ#torrc">cette entrée
de la FAQ</a> pour l'aide.)
Assurez vous de définir au moins les options Nickname et ORPort. Créez un DataDirectory
si nécessaire, et prenez soin de lui attribuer les droits de l'utilisateur qui fera tourner
Tor. <em>Si vous souhaitez faire tourner plus d'un serveur, c'est possible, mais
prenez soin de positionner l'option <a href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#MultipleServers">
MyFamily</a> sur l'ensemble de vos fichiers de configurations serveurs.</em>
</p>
<p>
4. Si vous utilisez un pare-feu, ouvrez le port tel que les
connections entrantes puissent atteindre le port que vous avez configuré (ORPort, et
DirPort si vous l'avez activé). Assurez vous qu'il autorise toutes les connections sortantes
pour que votre serveur puisse atteindre les autres serveurs Tor.
</p>
<p>
5. Lancer votre serveur : si vous avez installé à partir des sources vous n'avez qu'à
lancer <tt>tor</tt>, tandis que les paquets lancent typiquement Tor à partir de leur
scripts d'initialisation et de demarrage. S'il affiche des traces de log en
warnings, faites les nous parvenir. (Par defaut, Tor affiche les traces sur stdout,
mais quelques paquets les envoie dans <tt>/var/log/tor/</tt> ou <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#Logs">d'autres
endroits</a>. Vous pouvez editer votre fichier de configuration torrc pour configurer l'emplacement des logs.)
</p>
<p>
6. Inscrivez vous à la liste de diffusion <a
href="http://archives.seul.org/or/announce/">or-announce</a>.
Il y a relativement peu de messages, et vous tiendra informé
des nouvelles versions stables. Vous devriez aussi envisager de vous inscrire à <a
href="http://archives.seul.org/or/talk/">or-talk</a> (davantage de messages),
où les versions de développement sont annoncées.
</p>
<p>
7. Jetez un œil sur le manuel.
Le <a href="../tor-manual.html">manuel</a> pour la
dernière version stable apporte des instructions détaillées sur comment installer
et utiliser Tor, fourni également les options de configuration serveurs et clientes.
Si vous utilisez la version de développement de Tor, le manuel est disponible
<a href="../tor-manual-dev.html">ici</a>.
</p>
<hr>
<a id="check"></a>
<h2><a class="anchor" href="#check">Étape deux : assurez vous que ça fonctionne</a></h2>
<br>
<p>Dès que votre serveur va tenter de se connecter au réseau, il va
essayer de déterminer si le port que vous avez configuré est atteignable de
l'extérieur. Ceci peut prendre jusqu'à 20 minutes. Jetez un œil sur les
<a href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#Logs">traces
</a> comme l'
<tt>Self-testing indicates your ORPort is reachable from the outside. Excellent.</tt>
Si vous ne voyez pas ce message, ça signifie que votre serveur n'est pas atteignable
de l'extérieur &mdash; vous devriez revérifier vos pare-feux, vérifier qu'il
teste l'adresse IP et le port que vous penser qu'il devrait tester, etc.
</p>
<p>Quand votre serveur est joignable, il envoie un « descripteur
de serveur » aux annuaires. Ceci permettra aux clients de connaitre
quelle adresse, ports, clé, etc votre serveur utilise. Vous pouvez <a
href="http://belegost.mit.edu/tor/status/authority">charger l'état
du réseau</a> et
voir si vous trouvez dedans le nickname que vous avez configuré, pour être certain qu'il
est là. Vous aurez probablement à attendre quelques secondes pour avoir un
rafraichissement du répertoire.</p>
<hr>
<a id="after"></a>
<h2><a class="anchor" href="#after">Étape trois : une fois que ça marche</a></h2>
<br>
<p>
Nous recommandons tout aussi bien les étapes suivantes :
</p>
<p>
8. Lisez
<a href="http://wiki.noreply.org/noreply/TheOnionRouter/OperationalSecurity">ce document</a>
pour avoir des idées sur comment accroitre la sécurité de votre serveur.
</p>
<p>
9. Décidez quelle politique de sortie vous souhaitez. Par défaut, votre serveur autorise
l'accès à plusieurs services populaires, mais en restreint certains (comme le port 25)
en raison des abus potentiels. Vous pouvez préférer une politique de sortie qui soit
plus ou moins restrictive ; éditez votre fichier torrc de manière appropriée.
Lisez l'entrée de la FAQ sur les <a
href="../faq-abuse.html.fr#TypicalAbuses">les problèmes que vous seriez suceptible
de rencontrer si vous utilisez la politique par défaut</a>.
Si vous choisissez une politique de sortie particulièrement ouverte, assurez vous
que votre fournisseur d'accès est d'accord avec ce choix.
S'il y'a des ressources que votre ordinateur ne peux atteindre (par exemple,
vous êtes derrière un pare-feu restrictif ou un filtrage applicatif, prenez soin
de les rejeter explicitement dans votre politique de sortie &mdash; sinon les utilisateurs de Tor
seront également impactés.
</p>
<p>
10. Décidez de la limitation de débit. Le cable, les xDSL, et les utilisateurs
qui ont une bande passante asymétrique (par exemple : plus de débit en téléchargement qu'en envoi) devraient
limiter leur débit à la plus petite bande passante pour éviter les congestions. Voyez l'entrée <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#LimitBandwidth">FAQ sur
la limitation de débit</a> pour plus de détails.
</p>
<p>
11. Sauvegardez la clé privée de votre serveur Tor (stockée dans "keys/secret_id_key"
de votre DataDirectory). C'est l'« identité » de votre serveur, et
prenez soin de la garder en sécurité pour que personne ne puisse lire le trafic qui passe
au travers de votre nœud. C'est un fichier critique à conserver si vous compter <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#UpgradeServer">déplacer
ou restorer votre serveur Tor</a> si quelque chose se passe mal.
</p>
<p>
12. Si vous contrôlez le serveur de nom de votre domaine, n'hésitez pas à
paramétrer votre nom d'hôte avec 'anonymous' or 'proxy' or 'tor-proxy', pour que les
autres personnes voyant l'adresse dans les traces web puissent facilement comprendre
ce qui se passe.
</p>
<p>
13. Si votre ordinateur ne fait pas tourner un serveur web, envisagez de
changer l'option ORPort à 443 et votre DirPort à 80. Un certain nombre d'utilisateur
 Tor sont cloitrés derrière des pare-feux qui ne leur permettent que d'aller sur le
web, et ce changement leur permettra d'atteindre votre serveur Tor. Les serveurs
Win32 peuvent simplement changer leurs options ORPort et DirPort directement
dans leur configuration torrc et relancer Tor. Les serveurs OS X ou Unix ne peuvent pas attacher
directement ces ports (puisqu'ils doivent être lancé en root), alors ils doivent
paramétrer une sorte de <a
href="http://wiki.noreply.org/wiki/TheOnionRouter/TorFAQ#ServerForFirewalledClients">
translation de port</a> pour que les connections puissent atteindre leur serveur Tor. Si vos ports
80 et 443 sont déjà utilisés mais que vous souhaitez quand même aider, d'autres sont interessant comme
les ports 22, 110, et 143.
</p>
<p>
14. Si votre serveur Tor apporte d'autres services sur la même adresse IP
&mdash; comme par exemple un site web &mdash; assurez vous que les connexions
au serveur web sont autorisées à partir de l'hôte local également. Vous devez faire ça
parceque les clients Tor détecteront que le serveur Tor est le <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#ExitEavesdroppers">le chemin
le plus sûr pour atteindre le serveur web</a>, et construira toujours un chemin qui finira
par votre serveur. Si vous ne souhaitez pas autoriser les connexions, vous devrez
explicitement les rejeter dans votre politique de sortie.
</p>
<p>
15. (Unix uniquement). Créer un utilisateur séparé pour faire tourner le serveur. Si vous
installez le paquet OS X ou deb ou rpm, ceci est déjà
fait. Sinon, vous devez le faire à la main. (Le serveur Tor ne nécessite pas d'être
lancé sous root, c'est une bonne pratique de ne pas le faire. Le lancer
sous l'utilisateur 'tor' évite les problèmes avec identd et d'autres services qui
détectent le nom d'utilisateur. Si vous êtes dans le genre paranoïaque, sentez vous libre de <a
href="http://wiki.noreply.org/wiki/TheOnionRouter/TorInChroot">mettre Tor
dans une prison chroot</a>.)
</p>
<p>
16. (Unix uniquement.) Votre système d'exploitation limite probablement le nombre
de fichier ouvert par processus à 1024 (voir moins). Si vous
envisagez de faire tourner un nœud de sorti rapide, ceci ne sera sans doute pas suffisant. Sous
Linux, vous ajoutez une ligne genre "toruser hard nofile 8192" à votre fichier
/etc/security/limits.conf (ou toruser est l'utilisateur qui fait tourner le
processus Tor), et ensuite relancer Tor s'il est installé comme paquet (ou déconnectez vous
puis reconnectez vous si vous le lancez par vous même). Si ça ne fonctionne pas, voyez <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#FileDescriptors">cette entrée de la
FAQ</a> pour d'autre suggestions permettant de faire "ulimit -n 8192" avant
de lancer Tor.
</p>
<p>
17. Si vous installez Tor à partir d'une installation automatisée, il le lance probablement
automatiquement pour vous au démarrage du système. Mais si vous l'installez par les sources,
vous trouverez surement les scripts de demarrage situés dans contrib/tor.sh ou contrib/torctl utiles.
</p>
<p>
Quand vous changez la configuration de votre Tor, <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#Restarting">dans de
nombreux cas vous pouvez recharger la configuration sans avoir à relancer Tor</a>,
souvenez vous simplement de vérifier qu'il fonctionne toujours après
le changement.
</p>
<hr>
<a id="register"></a>
<h2><a class="anchor" href="#register">Étape quatre : enregistrer votre nickname</a></h2>
<br>
<p>
Laissez le tourner quelques semaines pour être certain que tout se passe bien et que vous
êtes content du niveau de ressouces consommées. Alors, si vous le souhaitez, enregistrez votre serveur.
Ceci réserve votre nickname de manière à ce que personne d'autre que vous puisse le prendre, et nous permet
de vous contacter si vous avez besoin d'une mise à jour ou si quelque chose ne va pas.
</p>
<p>
Envoyez un mail à <a
href="mailto:tor-ops@freehaven.net">tor-ops@freehaven.net</a> avec le
sujet '[New Server] &lt;le nickname de votre server&gt;' et
joignez les informations suivantes dans le message :
</p>
<ul>
<li>Le nom de votre serveur</li>
<li>L'empreinte (fingerprint) de votre clé d'identité. Ceci est <a
href="http://wiki.noreply.org/noreply/TheOnionRouter/TorFAQ#Logs">tracé</a>
au démarrage :
quelque chose comme "<tt>moria1 FFCB 46DB 1339 DA84 674C 70D7 CB58 6434
C437 0441</tt>".
<!--
C'est également écrit dans le fichier "fingerprint" de votre DataDirectory.
&mdash; Sous Windows, regardez dans
\<i>nom_utilisateur</i>\Application&nbsp;Data\tor\ or \Application&nbsp;Data\tor\;
sous OS X, regardez dans /Library/Tor/var/lib/tor/; et sous Linux/BSD/Unix,
regardez dans /var/lib/tor or ~/.tor)
-->
</li>
<li>Qui vous êtes, pour que nous puissions vous joindre en cas de problème.</li>
<li>Quel type de connexion le nouveau serveur a.</li>
</ul>
<p>
Alors nous évaluerons votre serveur pendant une semaine ou deux pour
s'assurer qu'il reste stable et fonctionne ; ne soyez pas surpris si ça nous prend
du temps pour vous répondre.
</p>
<hr>
<p>Si vous avez des commentaires pour étoffer ce document, n'hésitez pas <a
href="../contact.html.fr">à nous en faire part</a>. Merci !</p>
  </div><!-- #main -->
</div>
</div>
  <div class="bottom" id="bottom">
     <p>
     <i><a href="../contact.html.fr" class="smalllink">Webmaster</a></i> -
      Dernière modification : Thu May 24 20:05:18 2007
      -
      Dernière compilation : Thu May 24 20:10:00 2007
     </p>
     <p>
       Cette page est aussi disponible dans les langues suivantes :
       <a href="tor-doc-server.html.de">Deutsch</a>, <a href="tor-doc-server.html.en">English</a>, <a href="tor-doc-server.html.it">Italiano</a>, <a href="tor-doc-server.html.pl">polski</a>, <a href="tor-doc-server.html.ru">&#1056;&#1091;&#1089;&#1089;&#1082;&#1080;&#1081;&nbsp;(Russkij)</a>.<br>
       Comment configurer la <a href="http://www.debian.org/intro/cn#howtoset">langue par défaut du document</a>.
     </p>
  </div>
</body>
</html>
